/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.AttributeList;
import z3950.v3.AttributesPlusTerm;
import z3950.v3.InternationalString;
import z3950.v3.OccurrenceByAttributes;
import z3950.v3.OtherInformation;
import z3950.v3.Term;

public final class TermInfo
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public Term s_term;
    public InternationalString s_displayTerm;
    public AttributeList s_suggestedAttributes;
    public AttributesPlusTerm[] s_alternativeTerm;
    public ASN1Integer s_globalOccurrences;
    public OccurrenceByAttributes s_byAttributes;
    public OtherInformation s_otherTermInfo;

    public TermInfo() {
    }

    public TermInfo(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis TermInfo: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis TermInfo: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        this.s_term = new Term(berencoding1, true);
        ++j;
        this.s_displayTerm = null;
        this.s_suggestedAttributes = null;
        this.s_alternativeTerm = null;
        this.s_globalOccurrences = null;
        this.s_byAttributes = null;
        this.s_otherTermInfo = null;
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 0 && berencoding1.tag_type_get() == 128) {
            this.s_displayTerm = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_suggestedAttributes = new AttributeList(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_suggestedAttributes = null;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_alternativeTerm = new AttributesPlusTerm[k];
                for (int l = 0; l < k; ++l) {
                    this.s_alternativeTerm[l] = new AttributesPlusTerm(berconstructed1.elementAt(l), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_globalOccurrences = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_byAttributes = new OccurrenceByAttributes(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherTermInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherTermInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis TermInfo: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_displayTerm != null) {
            ++k;
        }
        if (this.s_suggestedAttributes != null) {
            ++k;
        }
        if (this.s_alternativeTerm != null) {
            ++k;
        }
        if (this.s_globalOccurrences != null) {
            ++k;
        }
        if (this.s_byAttributes != null) {
            ++k;
        }
        if (this.s_otherTermInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        aberencoding[l++] = this.s_term.ber_encode();
        if (this.s_displayTerm != null) {
            aberencoding[l++] = this.s_displayTerm.ber_encode(128, 0);
        }
        if (this.s_suggestedAttributes != null) {
            aberencoding[l++] = this.s_suggestedAttributes.ber_encode();
        }
        if (this.s_alternativeTerm != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_alternativeTerm.length];
            for (int i1 = 0; i1 < this.s_alternativeTerm.length; ++i1) {
                aberencoding1[i1] = this.s_alternativeTerm[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 4, aberencoding1);
        }
        if (this.s_globalOccurrences != null) {
            aberencoding[l++] = this.s_globalOccurrences.ber_encode(128, 2);
        }
        if (this.s_byAttributes != null) {
            aberencoding[l++] = this.s_byAttributes.ber_encode(128, 3);
        }
        if (this.s_otherTermInfo != null) {
            aberencoding[l++] = this.s_otherTermInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        stringbuffer.append("term ");
        stringbuffer.append(this.s_term);
        ++j;
        if (this.s_displayTerm != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("displayTerm ");
            stringbuffer.append(this.s_displayTerm);
            ++j;
        }
        if (this.s_suggestedAttributes != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("suggestedAttributes ");
            stringbuffer.append(this.s_suggestedAttributes);
            ++j;
        }
        if (this.s_alternativeTerm != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("alternativeTerm ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_alternativeTerm.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_alternativeTerm[i]);
            }
            stringbuffer.append("}");
            ++j;
        }
        if (this.s_globalOccurrences != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("globalOccurrences ");
            stringbuffer.append(this.s_globalOccurrences);
            ++j;
        }
        if (this.s_byAttributes != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("byAttributes ");
            stringbuffer.append(this.s_byAttributes);
            ++j;
        }
        if (this.s_otherTermInfo != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherTermInfo ");
            stringbuffer.append(this.s_otherTermInfo);
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

