alter VIEW VIEW_KNIHOVNA (ID_KNIHOVNA, NAZEV_JMENO, NAZEV_SIDLO, SIGLA, FK_PUJC, ADR_MI, ADR_UL, ADR_PSC, KOD_STAT, ADR_STAT, KONTAKT, EMAIL, EMAIL_KOPIE, TELEFON, MOBIL, POZNAMKA, VZKAZ, TRIDNAZ, FLATNAZ, KONTO)
AS 
select
  ctenari.fk_uziv,
  inst.nazev,
  prim_kontakt.trv_MI,
  kn.sigla,
  kn.fk_pujc,
  prim_kontakt.trv_MI,
  prim_kontakt.trv_UL,
  prim_kontakt.trv_PSC,
  kod_stavu,
  def_mvsstaty.nazev,
  (select first 1 zobr_jmeno from uzivatele uz2 join uziv_vazby on uz2.id_uziv = uziv_vazby.fk_uziv_cil where uziv_vazby.fk_uziv = uzi.id_uziv),
  prim_kontakt.email,
  prim_kontakt.email_kopie,
  prim_kontakt.telefon,
  prim_kontakt.sms,
  ctenari.poznamka,
  ctenari.vzkaz,
  uzi.tridjmeno,
  uzi.flatjmeno,
  (select sum(castka) from platby where platby.fk_uziv_vlastnik = ctenari.fk_uziv)
from ctenari
join uzivatele uzi on ctenari.fk_uziv = uzi.id_uziv
join instituce inst on inst.fk_uziv = uzi.id_uziv
join knihovny kn on kn.fk_uziv = uzi.id_uziv
left join def_mvsstaty on ctenari.kod_stavu = def_mvsstaty.id_statu
left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = uzi.id_uziv
^

CREATE OR ALTER VIEW VIEW_TISK_UPOMINKY(
    FK_VYPUC,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    TITUL_ZA,
    TRIDJMENO,
    PUJC_CTEN,
    BLOK_CTEN,
    CIS_LEG,
    EMAIL,
    SMS,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    FK_CTENKAT,
    BAR_COD_CTEN,
    FK_ZAZ,
    FK_DOKFOND,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    TRIDNAZ,
    FK_EX,
    OZNAC,
    DAT_PROL,
    DAT_VYP,
    POC_PROL,
    DOB_VYP,
    CENA,
    FK_LOKACE,
    FK_VYPKAT,
    CIS_UPOM,
    FK_PUJC,
    FK_TYPPUJC,
    DAT_GEN,
    DAT_TISK,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    KOR_MI,
    KOR_UL,
    KOR_PSC,
    KOR_STAT,
    PRIR_CISLO,
    SIGNATURA,
    BAR_COD_EXEMP,
    FK_PUJC_NADR,
    NAZEV_PUJC_NADR,
    ISSUE_CISLO,
    ISSUE_EVID_CIS,
    VOLUME_CISLO,
    VOLUME_ROK,
    ISSUE_ISSVOL,
    CASTKA,
    POZNAMKA,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_CISOP,
    ZAKZAST_DATNAR,
    ZAKZAST_TITUL,
    ZAKZAST_KOR_MI,
    ZAKZAST_KOR_UL,
    ZAKZAST_KOR_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMS,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    VZDELANI,
    POCET_KUSU_TIT,
    ZAMESTNANI)
AS
select
    VYPUC.FK_VYPUC,
    VYPUC.FK_UZIV_CTEN,
    uzi.zobr_jmeno, os.PRIJMENI, os.JMENO, os.TITUL, os.TITUL_ZA,
    uzi.tridjmeno,
    CTENAR.fk_pujc,
    ctenar.je_blokovan,
    ctenar.CIS_LEG,
    prim_kontakt.email,
    prim_kontakt.sms,
    CTENAR.TYP_TISK_REZE,
    CTENAR.TYP_TISK_UPOM,
    CTENAR.fk_ctenkat,
    ctenar.bar_cod,
    VYPUC.FK_ZAZ, kat1_4.fk_dokfond,
    KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od, kat1_4.tridnaz,
    VYPUC.FK_EX, VYPUC.OZNAC, VYPUC.DAT_PROL, VYPUC.dat_vyp, VYPUC.POC_PROL, VYPUC.DAT_PROL + VYPUC.DOB_VYP, VYPUC.CENA,
    VYPUC.FK_LOKACE,
    VYPUC.FK_VYPKAT,
    VYPUC.CIS_UPOM,
    VYPUC.FK_PUJC,
    VYPUC.FK_TYPPUJC,
    UPOMINKY.DAT_GEN, UPOMINKY.DAT_TISK,
    prim_kontakt.trv_mi, prim_kontakt.trv_ul, prim_kontakt.trv_psc, prim_kontakt.trv_stat,
    prim_kontakt.kor_mi, prim_kontakt.kor_ul, prim_kontakt.kor_psc, prim_kontakt.kor_stat,
    kat1_5.prir_cislo,
    kat1_5.signatura,
    kat1_5.bar_cod,
    (select fk_nadr from def_pujc where id_pujc = vypuc.fk_pujc),
    (select nadr.nazev from def_pujc nadr join def_pujc podr on nadr.id_pujc = podr.fk_nadr where podr.id_pujc = vypuc.fk_pujc),
    issues.issue,
    issues.evcislo,
    volume.cis_vol,
    volume.rok_vol,
    issues.issue || '/' || volume.cis_vol,
    (select sum(castka) from platby where platby.fk_uziv_vlastnik = vypuc.fk_uziv_cten and fk_popl = 3),
    vypuc.poznamka,
    prim_kontakt.EMAIL_KOPIE,
    zak_zast.email, zak_zast.prijmeni, zak_zast.jmeno, zak_zast.trv_mi, zak_zast.trv_ul, zak_zast.trv_psc,
    zak_zast.cisop, zak_zast.datnar, ZAK_ZAST.TITUL, ZAK_ZAST.kor_MI, ZAK_ZAST.kor_UL, ZAK_ZAST.kor_PSC, ZAK_ZAST.EMAIL, ZAK_ZAST.SMS, ZAK_ZAST.TELEFON,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik,
    os.funkce, os.vzdelani,
    (select sum(zmena) from vypuc_titper where vypuc.fk_vypuc = vypuc_titper.fk_vypuc),
    os.zamestnani
from vypuc  join upominky on vypuc.fk_vypuc = upominky.fk_vypuc and vypuc.cis_upom = upominky.cis_upom
            join kat1_4 on vypuc.fk_zaz = kat1_4.id_zaz
            left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
            join ctenari ctenar on vypuc.fk_uziv_cten = ctenar.fk_uziv
            join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
            left join osoby os on os.fk_uziv = uzi.id_uziv
            left join instituce on instituce.fk_uziv = uzi.id_uziv
            join def_ctenkat on ctenar.fk_ctenkat = id_ctenkat
            join def_pujc on vypuc.fk_pujc = id_pujc
            left join issues on kat1_5.id_ex = issues.fk_ex
            left join volume on issues.fk_vol = volume.id_vol
            left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ctenar.fk_uziv = zak_zast.fk_uziv
            left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenar.fk_uziv
^

CREATE OR ALTER VIEW VIEW_TISK_UPOMINKY_NETISK(
    FK_VYPUC,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    TITUL_ZA,
    TRIDJMENO,
    PUJC_CTEN,
    BLOK_CTEN,
    CIS_LEG,
    EMAIL,
    SMS,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    FK_CTENKAT,
    BAR_COD_CTEN,
    FK_ZAZ,
    FK_DOKFOND,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    TRIDNAZ,
    FK_EX,
    OZNAC,
    DAT_PROL,
    DAT_VYP,
    POC_PROL,
    DOB_VYP,
    CENA,
    FK_LOKACE,
    FK_VYPKAT,
    CIS_UPOM,
    FK_PUJC,
    FK_TYPPUJC,
    DAT_GEN,
    DAT_TISK,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    KOR_MI,
    KOR_UL,
    KOR_PSC,
    KOR_STAT,
    PRIR_CISLO,
    SIGNATURA,
    BAR_COD_EXEMP,
    FK_PUJC_NADR,
    NAZEV_PUJC_NADR,
    ISSUE_CISLO,
    ISSUE_EVID_CIS,
    VOLUME_CISLO,
    VOLUME_ROK,
    ISSUE_ISSVOL,
    CASTKA,
    POZNAMKA,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_CISOP,
    ZAKZAST_DATNAR,
    ZAKZAST_TITUL,
    ZAKZAST_KOR_MI,
    ZAKZAST_KOR_UL,
    ZAKZAST_KOR_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMS,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    VZDELANI,
    POCET_KUSU_TIT,
    ZAMESTNANI)
AS
select
    VYPUC.FK_VYPUC,
    VYPUC.FK_UZIV_CTEN,
    uzi.zobr_jmeno, os.PRIJMENI, os.JMENO, os.TITUL, os.TITUL_ZA,
    uzi.tridjmeno,
    CTENAR.fk_pujc,
    ctenar.je_blokovan,
    ctenar.CIS_LEG,
    prim_kontakt.email,
    prim_kontakt.sms,
    CTENAR.TYP_TISK_REZE,
    CTENAR.TYP_TISK_UPOM,
    CTENAR.fk_ctenkat,
    ctenar.bar_cod,
    VYPUC.FK_ZAZ, kat1_4.fk_dokfond,
    KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od, kat1_4.tridnaz,
    VYPUC.FK_EX, VYPUC.OZNAC, VYPUC.DAT_PROL, VYPUC.dat_vyp, VYPUC.POC_PROL, VYPUC.DAT_PROL + VYPUC.DOB_VYP, VYPUC.CENA,
    VYPUC.FK_LOKACE,
    VYPUC.FK_VYPKAT,
    VYPUC.CIS_UPOM,
    VYPUC.FK_PUJC,
    VYPUC.FK_TYPPUJC,
    UPOMINKY.DAT_GEN, UPOMINKY.DAT_TISK,
    prim_kontakt.trv_mi, prim_kontakt.trv_ul, prim_kontakt.trv_psc, prim_kontakt.trv_stat,
    prim_kontakt.kor_mi, prim_kontakt.kor_ul, prim_kontakt.kor_psc, prim_kontakt.kor_stat,
    kat1_5.prir_cislo,
    kat1_5.signatura,
    kat1_5.bar_cod,
    (select fk_nadr from def_pujc where id_pujc = vypuc.fk_pujc),
    (select nadr.nazev from def_pujc nadr join def_pujc podr on nadr.id_pujc = podr.fk_nadr where podr.id_pujc = vypuc.fk_pujc),
    issues.issue,
    issues.evcislo,
    volume.cis_vol,
    volume.rok_vol,
    issues.issue || '/' || volume.cis_vol,
    (select sum(castka) from platby where platby.fk_uziv_vlastnik = vypuc.fk_uziv_cten and fk_popl = 3),
    vypuc.poznamka,
    prim_kontakt.EMAIL_KOPIE,
    zak_zast.email, zak_zast.prijmeni, zak_zast.jmeno, zak_zast.trv_mi, zak_zast.trv_ul, zak_zast.trv_psc,
    zak_zast.cisop, zak_zast.datnar, ZAK_ZAST.TITUL, ZAK_ZAST.kor_MI, ZAK_ZAST.kor_UL, ZAK_ZAST.kor_PSC, ZAK_ZAST.EMAIL, ZAK_ZAST.SMS, ZAK_ZAST.TELEFON,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik,
    os.funkce, os.vzdelani,
    (select sum(zmena) from vypuc_titper where vypuc.fk_vypuc = vypuc_titper.fk_vypuc),
    os.zamestnani
from vypuc  join upominky on vypuc.fk_vypuc = upominky.fk_vypuc and vypuc.cis_upom = upominky.cis_upom
            join kat1_4 on vypuc.fk_zaz = kat1_4.id_zaz
            left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
            join ctenari ctenar on vypuc.fk_uziv_cten = ctenar.fk_uziv
            join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
            left join osoby os on os.fk_uziv = uzi.id_uziv
            left join instituce on instituce.fk_uziv = uzi.id_uziv
            join def_ctenkat on ctenar.fk_ctenkat = id_ctenkat
            join def_pujc on vypuc.fk_pujc = id_pujc
            left join issues on kat1_5.id_ex = issues.fk_ex
            left join volume on issues.fk_vol = volume.id_vol
            left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ctenar.fk_uziv = zak_zast.fk_uziv
            left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenar.fk_uziv
where upominky.dat_tisk is null
^

update def_tabcols set popis = 'Objednáno'
where tabulka = 'RezervaceGB_RezervaceGrid53' and pole = 'DAT_VYP'
^
update def_tabcols set popis = 'Objednáno'
where tabulka = 'RezervaceGB_RezervaceGrid54' and pole = 'DAT_VYP'
^
update def_tabcols set popis = 'Vyřízeno'
where tabulka = 'RezervaceGB_RezervaceGrid55' and pole = 'DAT_VYP'
^

CREATE OR ALTER VIEW VIEW_REZERVACE(
    FK_VYPUC,
    FK_UZIV_CTEN,
    OZNACENI,
    CTENAR,
    CIS_LEG,
    BAR_COD,
    TYP_TISK_REZE,
    FK_ZAZ,
    NAZEV,
    FK_EX,
    CIS_REZE,
    DAT_VYP,
    DAT_REZE,
    ZAJEM_DO,
    DAT_VR,
    FK_LOKACE,
    FK_VYPKAT,
    VYPKAT,
    FK_PUJC,
    VYP_PUJC,
    VALID_PUJC,
    REZE_EXEMP,
    CTEN_PUJC,
    TYP_PUJC,
    ISSUE,
    ROK_VOLUME,
    EMAIL,
    TELEFON,
    MOBIL,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_DATNAR,
    ZAKZAST_CISOP,
    ZAKZAST_TITUL,
    ZAKZAST_PRE_MI,
    ZAKZAST_PRE_UL,
    ZAKZAST_PRE_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMSCISLO,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE)
AS
select
    VYPUC.FK_VYPUC,
    VYPUC.FK_UZIV_CTEN,
    coalesce(VYPUC.oznac, (select first 1 signatura from kat1_5 k1 where k1.fk_zaz = vypuc.fk_zaz and k1.signatura is not null)),
    uz.zobr_jmeno,
    ct.CIS_LEG,
    ct.BAR_COD,
    case (ct.TYP_TISK_REZE)
      when 1 then 'Email'
      when 2 then 'SMS'
      when 3 then 'Email + SMS'
      else 'Tisk'
    end,
    VYPUC.FK_ZAZ,
    KAT1_4.NAZEV,
    VYPUC.FK_EX,
    VYPUC.CIS_REZE,
    VYPUC.DAT_VYP,
    VYPUC.DAT_PROL,
    VYPUC.DAT_PROL + VYPUC.dob_vyp,
    (select max(dat_vr) from vypuc2 where vypuc2.fk_ex = vypuc.fk_ex),
    VYPUC.FK_LOKACE,
    VYPUC.FK_VYPKAT,
    DEF_VYPKAT.popis,
    VYPUC.FK_PUJC,
    DP1.nazev,
    POZ_REZ.pujcovny,
    POZ_REZ.fk_ex,
    DP2.nazev,
    VYPUC.fk_typpujc,
    coalesce(ISSUES.issue, kat1_5.rozm_cisel),
    coalesce(VOLUME.rok_vol, kat1_5.rok_vol),
    prim_kontakt.email,
    prim_kontakt.telefon,
    prim_kontakt.sms,
    zak_zast.trv_MI,
    zak_zast.trv_UL,
    zak_zast.trv_PSC,
    instituce.nazev,
    zak_zast.datnar,
    zak_zast.cisop,
    zak_zast.TITUL,
    zak_zast.kor_MI,
    zak_zast.kor_UL,
    zak_zast.kor_PSC,
    zak_zast.EMAIL,
    zak_zast.SMS,
    zak_zast.TELEFON,
    instituce.ico, instituce.dic, instituce.obch_rejstrik, os.funkce
from vypuc
    join kat1_4 on id_zaz = vypuc.fk_zaz
    left join def_lokace on id_lokace = fk_lokace
    left join def_vypkat on id_vypkat = fk_vypkat
    join def_pujc dp1 on dp1.id_pujc = vypuc.fk_pujc
    join uzivatele uz on uz.id_uziv = vypuc.fk_uziv_cten
    left join osoby os on os.fk_uziv = uz.id_uziv
    left join ctenari ct on ct.fk_uziv = uz.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = uz.id_uziv
    left join instituce on instituce.fk_uziv = uz.id_uziv
    left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ct.fk_uziv = zak_zast.fk_uziv
    join def_pujc dp2 on dp2.id_pujc = ct.fk_pujc
    left join poz_rez on poz_rez.fk_vypuc = vypuc.fk_vypuc
    left join issues on issues.fk_ex = poz_rez.fk_ex
    left join volume on volume.id_vol = issues.fk_vol
    left join kat1_5 on kat1_5.id_ex = vypuc.fk_ex
where cis_reze > 0
^

INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
VALUES (NULL, 'RezervaceGB_RezervaceGrid53', 15, 'DAT_VR', 'Vráceno', 90, 1, NULL, 0)
^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
VALUES (NULL, 'RezervaceGB_RezervaceGrid54', 15, 'DAT_VR', 'Vráceno', 90, 1, NULL, 0)
^


INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA) 
  VALUES (2259, 'Odemknutí záznamu',  0, 63, 2250, 0, 3)
  ^
  
INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA) 
  VALUES (7259, 'Odemknutí autority', 0, 63, 7250, 0, 24)
^  

update def_gridedit_grid set
unikatni = 0, delka_pole = 500
where tabulka = 'DEF_ZSERVER' and pole = 'PARAMETRY'
^

INSERT INTO DEF_VYKONY (ID_VYKON, POPIS) VALUES (21, 'Odblokování editace')
^

INSERT INTO DEF_VYKONYAUT (ID_VYKON, POPIS) VALUES (21, 'Odblokování editace')
^

CREATE OR ALTER trigger trg_vykony_aut_bi0_setuser for vykony_aut
active before insert position 0
AS
begin

    if (new.fk_uziv is null or new.fk_uziv < 1 or new.datcas is null) then
        select cis_uziv, datcas from sproc_get_uziv_cas into new.fk_uziv, new.datcas;

end
^

CREATE OR ALTER trigger trg_vykony_dok_bi0_setuser for vykony_dok                                                                                                                                   0
active before insert position 0
AS
begin

    if (new.fk_uziv is null or new.fk_uziv < 1 or new.datcas is null) then
        select cis_uziv, datcas from sproc_get_uziv_cas into new.fk_uziv, new.datcas;

end
^
