CREATE OR ALTER procedure SPROC_GET_UZIV_CAS
returns (
    JMENO STRING_40,
    CIS_UZIV GENERATORY,
    DATCAS DATETIME)
as
begin

  datcas = 'NOW';
  cis_uziv = rdb$get_context('USER_SESSION', 'LOGGED_USER_ID');

  for select substring(tridjmeno from 1 for 40) from uzivatele where id_uziv = :cis_uziv
  into :jmeno
  do begin
    suspend;
    exit;
  end

  exception exc_action_forbidden;

end
^

ALTER VIEW VIEW_OBSAZENI_PC (PC_JMENO, FK_PUJC, FK_OSOBY, START_TIME, STOP_TIME, DATUM, ID_INTERNET, FK_UZIV_START, CTENAR, CIS_LEG, BAR_COD)
AS 
select
    d1.pc_jmeno,
    i1.fk_pujc,
    i1.fk_osoby,
    START_TIME,
    STOP_TIME,
    DATUM,
    ID_INTERNET,
    i1.fk_uziv_start,
    coalesce(i1.PRIJMENI || ' ' || i1.JMENO || ' - ' || i1.ADRESA, 
           os.prijmeni || ' ' || os.jmeno
    ),
    ct.cis_leg,
    ct.bar_cod
from def_int_pc d1
left join stat_internet i1 on d1.id_int_pc = i1.fk_int_pc
left join osoby os on os.fk_uziv = i1.fk_osoby
left join ctenari ct on ct.fk_uziv = os.fk_uziv
join uzivatele on uzivatele.id_uziv = ct.fk_uziv
^ 

ALTER VIEW VIEW_INTERNET (ID_INT_PC, PC_JMENO, PC_STAV, FK_PUJC, PUJCOVNA, MAXDOB, FK_OSOBY, START_TIME, DATUM, ID_INTERNET, FK_UZIV, CTEN_JMENO, CTEN_CISLEG, CTEN_BC, ACT_TIME)
AS 
select 
  id_int_pc, 
  d1.PC_JMENO, 
  d1.pc_stav, 
  d1.fk_pujc, 
  def_pujc.nazev, 
  coalesce(i1.max_doba, d1.maxdob), 
  i1.fk_OSOBY,
  START_TIME, 
  DATUM, 
  ID_internet, 
  fk_uziv_start, 
  coalesce(i1.PRIJMENI || ' ' || i1.JMENO || ' - ' || i1.ADRESA, 
           os.prijmeni || ' ' || os.jmeno, 
           trim(instituce.nazev || ' ' || os.prijmeni || ' ' || os.jmeno || ' ' || os.titul)
    ), 
  ct.cis_leg,
  ct.bar_cod,
  CURRENT_TIMESTAMP 
from def_int_pc d1 
    left join stat_internet i1 on d1.id_int_pc = i1.fk_int_pc and i1.stop_time is null and i1.datum = 'TODAY' 
    left join osoby os on os.fk_uziv = i1.fk_osoby
    join def_pujc on d1.fk_pujc = id_pujc 
    left join uzivatele on uzivatele.id_uziv = i1.fk_osoby
    left join instituce on instituce.fk_uziv = i1.fk_osoby
    left join ctenari ct on ct.fk_uziv = i1.fk_osoby
  where d1.pc_stav = 1
^

CREATE OR ALTER VIEW VIEW_OSOBY_CTENARI_KONTAKTY(
    FK_UZIV,
    JMENO,
    PRIJMENI,
    TITUL,
    TITUL_ZA,
    DAT_NAR,
    VZDELANI,
    TRIDA,
    CISOP,
    ICO,
    DIC,
    TRV_UL,
    TRV_MI,
    TRV_PSC,
    TRV_STAT,
    EMAIL,
    TEL,
    SMS,
    TRIDJMENO)
AS
select
    uz.id_uziv,
    os.jmeno, os.prijmeni, os.titul, os.titul_za, os.dat_nar,
    os.vzdelani, os.trida, os.cisop, os.ico, os.dic,
    prim_kontakt.trv_ul, prim_kontakt.trv_mi, prim_kontakt.trv_psc, prim_kontakt.trv_stat,
    prim_kontakt.email, prim_kontakt.telefon, prim_kontakt.sms,
    uz.tridjmeno
from uzivatele uz
    left join osoby os on os.fk_uziv = uz.id_uziv
    left join ctenari ct on ct.fk_uziv = uz.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = uz.id_uziv
^

ALTER TABLE DEF_PRIRCIS_RADY
ADD CISLO_SKUPINY INT_NONULL
^

update def_prircis_rady set cislo_skupiny = 0
^

update def_prircis_rady pc1 set
    cislo_skupiny = coalesce(
        (select first 1 cislo_skupiny from def_prircis_rady pc2 where pc1.prir_telo = pc2.prir_telo and pc1.prir_pref = pc2.prir_pref and pc1.prir_suff = pc2.prir_suff and pc1.prir_delka = pc2.prir_delka and pc2.cislo_skupiny > 0),
        (select max(cislo_skupiny) + 1 from def_prircis_rady pc3)
        )
where cislo_skupiny = 0
^

delete from log_uziv where login_time < '1.1.2017'
^
delete from log_uziv_kpwinsql where login_time < '1.1.2019'
^

alter table log_uziv alter client_ip type string_30
^
alter table log_uziv_kpwinsql alter client_ip type string_30
^
alter table log_uziv_opac alter client_ip type string_30
^
alter table log_uziv_opac_edit alter client_ip type string_30
^
alter table log_uziv_other alter client_ip type string_30
^
alter table log_exemp alter ip_addr type string_30
^