CREATE DOMAIN STRING_4000 AS
VARCHAR(4000) CHARACTER SET WIN1250
COLLATE WIN1250
^ 

CREATE VIEW VIEW_TISK_REJSTRIK_GEOGRAFICKY(
    FK_KOLEKCE,
    ID_AUT,
    NAZEV,
    TRIDNAZ,
    SEZNAM)
AS
select fk_kolekce, id_aut, nazev, tridnaz, cast(list(distinct poradi) as string_4000) as seznam from pom_kolekce
join kat1_7 on pom_kolekce.fk_zaz = kat1_7.fk_zaz and kat1_7.cis_fond = 45
join kataut_4 on kat1_7.fk_aut = kataut_4.id_aut
where cis_pol = 1651
group by tridnaz, id_aut, nazev, fk_kolekce
^

GRANT SELECT ON VIEW_TISK_REJSTRIK_GEOGRAFICKY TO KATALOG
^

create or alter procedure SPROC_PREVED_DO_WIN1250 (
    UTF_TEXT UTF_250)
returns (
    WIN1250_TEXT STRING_255)
as
declare variable POZICE SMALL_NOTNULL;
declare variable ZNAK_UTF char(1);
declare variable ZNAK_WIN STRING_01;
BEGIN

    win1250_text = '';
    pozice = 1;
    while (pozice <= CHAR_LENGTH(utf_text)) do
    BEGIN
    
        znak_utf = substring(utf_text from pozice for 1);
        BEGIN
            znak_win = znak_utf;
            win1250_text = win1250_text || znak_utf;
        when any do
            win1250_text = win1250_text || '?';
        end
        pozice = pozice + 1;
    
    END
    
    suspend;

END
^

GRANT EXECUTE ON PROCEDURE SPROC_PREVED_DO_WIN1250 TO KATALOG
^

ALTER PROCEDURE SPROC_PRIPRAV_RAZENI_KOLEKCE (
    RAZENI SMALL_NOTNULL)
AS
declare variable PORADI_NA_NIC INT_NULL;
declare variable CIS_ZAZ GENERATORY;
begin

    update pol_kolekce set tridici = null;
    
    if (razeni = 1) then BEGIN
    
        update POL_KOLEKCE SET
            tridici = (select (select win1250_text from sproc_preved_do_win1250(nazev)) from kat1_4 where id_zaz = pol_kolekce.FK_ZAZ);
    
    END    
    if (razeni = 2) then BEGIN
    
        for select distinct fk_zaz from pol_kolekce
            order by fk_zaz
            into :cis_zaz
        do begin
            --suspend;
            update POL_KOLEKCE SET
                tridici = (select (select win1250_text from sproc_preved_do_win1250(coalesce(substring(upper(autor) from 1 for 100) || substring(tridnaz from 1 for 100), tridnaz))) from kat1_4 where id_zaz = pol_kolekce.FK_ZAZ)
                where fk_zaz = :cis_zaz;
        end
    
    END
    if (razeni = 3) then BEGIN
    
        update POL_KOLEKCE SET
            tridici = (select lpad(rok_od, 10, '0') from kat1_4 where id_zaz = pol_kolekce.FK_ZAZ);
    
    END 
    if (razeni = 4) then BEGIN
    
        update POL_KOLEKCE SET
            tridici = lpad(fk_zaz, 10, '0');
    
    END 
    if (razeni = 5) then BEGIN
    
        update POL_KOLEKCE SET
            tridici = lpad(id_polkolekce, 10, '0');
    
    END

end^