/*
 * Decompiled with CFR 0.152.
 */
package asn1;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import asn1.BERPrimitive;

public final class ASN1BitString
extends ASN1Any {
    public static final int TAG = 3;
    private boolean[] bits;

    public ASN1BitString(boolean[] aflag) {
        this.bits = aflag;
    }

    public ASN1BitString(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1EncodingException {
        if (flag && (berencoding.tag_get() != 3 || berencoding.tag_type_get() != 0)) {
            throw new ASN1EncodingException("ASN.1 BIT STRING: bad BER: tag=" + berencoding.tag_get() + " expected 3\n");
        }
        if (berencoding instanceof BERPrimitive) {
            BERPrimitive berprimitive = (BERPrimitive)berencoding;
            int[] ai = berprimitive.peek();
            if (ai.length < 1) {
                throw new ASN1EncodingException("ASN1 BIT STRING: invalid encoding, length = " + ai.length);
            }
            int i = ai[0] & 7;
            int j = (ai.length - 1) * 8 - i;
            this.bits = new boolean[j];
            for (int k = 0; k < j; ++k) {
                int l = ai[k / 8 + 1];
                this.bits[k] = ((l <<= k % 8) & 0x80) != 0;
            }
            return;
        }
        BERConstructed _tmp = (BERConstructed)berencoding;
        throw new ASN1EncodingException("ASN.1 BIT STRING: decoding constructed NOT IMPLEMENTED YET");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 3);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = (this.bits.length + 7) / 8;
        int[] ai = new int[k + 1];
        ai[0] = k * 8 - this.bits.length;
        for (int l = 1; l <= k; ++l) {
            ai[l] = 0;
            int i1 = (l - 1) * 8;
            for (int j1 = 0; j1 < 8; ++j1) {
                int k1 = i1 + j1;
                int n = l;
                ai[n] = ai[n] << 1;
                if (k1 >= this.bits.length || !this.bits[k1]) continue;
                int n2 = l;
                ai[n2] = ai[n2] | 1;
            }
        }
        return new BERPrimitive(i, j, ai);
    }

    public ASN1BitString set(boolean[] aflag) {
        this.bits = aflag;
        return this;
    }

    public boolean[] get() {
        return this.bits;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append('\'');
        for (int i = 0; i < this.bits.length; ++i) {
            stringbuffer.append(this.bits[i] ? (char)'1' : '0');
        }
        stringbuffer.append("'B");
        return stringbuffer.toString();
    }
}

