/*
 * Decompiled with CFR 0.152.
 */
package asn1;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BEREncoding;
import asn1.BERPrimitive;

public final class ASN1Boolean
extends ASN1Any {
    public static final int TAG = 1;
    private boolean value;

    public ASN1Boolean(boolean flag) {
        this.value = flag;
    }

    public ASN1Boolean(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1EncodingException {
        if (flag && (berencoding.tag_get() != 1 || berencoding.tag_type_get() != 0)) {
            throw new ASN1EncodingException("ASN.1 BOOLEAN: bad BER: tag=" + berencoding.tag_get() + " expected TAG\n");
        }
        if (berencoding instanceof BERPrimitive) {
            BERPrimitive berprimitive = (BERPrimitive)berencoding;
            int[] ai = berprimitive.peek();
            if (ai.length != 1) {
                throw new ASN1EncodingException("ASN.1 BOOLEAN: invalid encoding, length = " + ai.length);
            }
            if (ai[0] == 0) {
                this.value = false;
                return;
            }
            this.value = true;
            return;
        }
        throw new ASN1EncodingException("ASN.1 BOOLEAN: bad BER: decoding constructed NOT IMPLEMENTED YET");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 1);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int[] ai = new int[]{this.value ? 255 : 0};
        return new BERPrimitive(i, j, ai);
    }

    public ASN1Boolean set(boolean flag) {
        this.value = flag;
        return this;
    }

    public boolean get() {
        return this.value;
    }

    public String toString() {
        if (this.value) {
            return "true";
        }
        return "false";
    }
}

