/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import cz.kpsys.portaro.commons.convert.ListToModifiedListConverter;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.ConvertingCodebook;
import cz.kpsys.portaro.commons.object.repo.FilteringCodebook;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.DepartmentAccessorImpl;
import cz.kpsys.portaro.department.DepartmentEntity;
import cz.kpsys.portaro.department.EntityToDepartmentConverter;
import cz.kpsys.portaro.department.RealRootDepartmentProvider;
import cz.kpsys.portaro.department.SpringDbDepartmentEntityLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class DepartmentBeansConfig {
    @NonNull
    private final NamedParameterJdbcOperations autoCommittingJdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;

    @Bean
    public Codebook<DepartmentEntity, Integer> departmentEntityLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbDepartmentEntityLoader(this.autoCommittingJdbcTemplate, this.queryFactory)).staticCached(Department.class.getSimpleName()).build();
    }

    @Bean
    public Codebook<Department, Integer> departmentLoader() {
        FilteringCodebook notDeletedCodebook = FilteringCodebook.filteredGetAllOnly((Codebook)this.departmentEntityLoader(), departmentEntity -> departmentEntity.getDeletionEventId() == null);
        ListToModifiedListConverter entitiesToModelsConverter = new ListToModifiedListConverter((Converter)new EntityToDepartmentConverter());
        return new ConvertingCodebook((Codebook)notDeletedCodebook, (Converter)entitiesToModelsConverter);
    }

    @Bean
    public DepartmentAccessor departmentAccessor() {
        return new DepartmentAccessorImpl(this.departmentLoader());
    }

    @Bean
    public Provider<Department> rootDepartmentProvider() {
        return this.realRootDepartmentProvider();
    }

    @Bean
    public Provider<Integer> rootDepartmentIdProvider() {
        return () -> (Integer)((Department)this.realRootDepartmentProvider().get()).getId();
    }

    @Bean
    public Provider<Department> realRootDepartmentProvider() {
        return new RealRootDepartmentProvider((AllValuesProvider)this.departmentLoader());
    }

    @ConstructorProperties(value={"autoCommittingJdbcTemplate", "queryFactory", "codebookLoaderBuilderFactory"})
    @Generated
    public DepartmentBeansConfig(@NonNull NamedParameterJdbcOperations autoCommittingJdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory) {
        Objects.requireNonNull(autoCommittingJdbcTemplate, "autoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        this.autoCommittingJdbcTemplate = autoCommittingJdbcTemplate;
        this.queryFactory = queryFactory;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
    }
}

