/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import cz.kpsys.db.file.NactiBlobExecutor;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.thumbnail.ThumbnailProvider;
import cz.kpsys.portaro.file.FileConfig;
import cz.kpsys.portaro.file.FileSettingKeys;
import cz.kpsys.portaro.file.IdentifiedData;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.index.ConditionalFileIndexingService;
import cz.kpsys.portaro.file.index.DefaultFileIndexingService;
import cz.kpsys.portaro.file.index.FileIndexerRegistry;
import cz.kpsys.portaro.file.index.FileIndexingService;
import cz.kpsys.portaro.file.text.FileTextProvider;
import cz.kpsys.portaro.file.text.FileTextProviderConfig;
import cz.kpsys.portaro.file.text.index.FileTextCachingIndexer;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.thumbnail.ThumbnailProviderConfig;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@Import(value={FileConfig.class, FileTextProviderConfig.class, ThumbnailProviderConfig.class})
public class FileBeansImplConfig {
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final ThumbnailProvider thumbnailProvider;
    @NonNull
    private final FileTextProvider fileTextProvider;
    @NonNull
    private final FileDataStreamer fileDataStreamer;
    @NonNull
    private final PageSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader;
    @NonNull
    private final FileTextProvider notCachingFileTextProvider;
    @NonNull
    private final Saver<IdentifiedData<String>> identifiedFileTextDataSaver;
    @NonNull
    private final SettingLoader settingLoader;

    @Bean
    public NactiBlobExecutor nactiBlobExecutor() {
        return new NactiBlobExecutor(this.identifiedFileLoader, this.thumbnailProvider, this.fileTextProvider, this.fileDataStreamer);
    }

    @Bean
    public FileIndexerRegistry fileIndexers() {
        return new FileIndexerRegistry().add(this.fileTextCachingIndexer());
    }

    @Bean
    public FileIndexingService fileIndexingService() {
        DefaultFileIndexingService defaultService = new DefaultFileIndexingService(this.fileSearchLoader, this.fileIndexers(), Duration.ofSeconds(2L), 10);
        return new ConditionalFileIndexingService(this.settingLoader.getOnRootProvider(FileSettingKeys.APPSERVER_INDEXING_ENABLED), (FileIndexingService)defaultService);
    }

    @Bean
    public Consumer<IdentifiedFile> fileTextCachingIndexer() {
        return new FileTextCachingIndexer(this.notCachingFileTextProvider, this.identifiedFileTextDataSaver);
    }

    @Scheduled(initialDelay=20000L, fixedDelay=120000L)
    public void indexFiles() {
        this.fileIndexingService().indexAll();
    }

    @ConstructorProperties(value={"identifiedFileLoader", "thumbnailProvider", "fileTextProvider", "fileDataStreamer", "fileSearchLoader", "notCachingFileTextProvider", "identifiedFileTextDataSaver", "settingLoader"})
    @Generated
    public FileBeansImplConfig(@NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull ThumbnailProvider thumbnailProvider, @NonNull FileTextProvider fileTextProvider, @NonNull FileDataStreamer fileDataStreamer, @NonNull PageSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader, @NonNull FileTextProvider notCachingFileTextProvider, @NonNull Saver<IdentifiedData<String>> identifiedFileTextDataSaver, @NonNull SettingLoader settingLoader) {
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(thumbnailProvider, "thumbnailProvider is marked non-null but is null");
        Objects.requireNonNull(fileTextProvider, "fileTextProvider is marked non-null but is null");
        Objects.requireNonNull(fileDataStreamer, "fileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(fileSearchLoader, "fileSearchLoader is marked non-null but is null");
        Objects.requireNonNull(notCachingFileTextProvider, "notCachingFileTextProvider is marked non-null but is null");
        Objects.requireNonNull(identifiedFileTextDataSaver, "identifiedFileTextDataSaver is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        this.identifiedFileLoader = identifiedFileLoader;
        this.thumbnailProvider = thumbnailProvider;
        this.fileTextProvider = fileTextProvider;
        this.fileDataStreamer = fileDataStreamer;
        this.fileSearchLoader = fileSearchLoader;
        this.notCachingFileTextProvider = notCachingFileTextProvider;
        this.identifiedFileTextDataSaver = identifiedFileTextDataSaver;
        this.settingLoader = settingLoader;
    }
}

