/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.as.loan.DelegatingKat15BasedSlotAvailabilityResolver;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.portaro.calendar.CalendarConfig;
import cz.kpsys.portaro.commons.date.DateRange;
import cz.kpsys.portaro.commons.date.DateRangeJsonRepository;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.IdBase64ingSingleValueRepository;
import cz.kpsys.portaro.commons.object.repo.SingleValueRepository;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.loan.LoanSlotConfig;
import cz.kpsys.portaro.loan.availability.timeslot.DefaultSlotAvailabilityResolver;
import cz.kpsys.portaro.loan.availability.timeslot.SlotAvailabilityResolver;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.user.BasicUser;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.converter.Converter;

@Configuration
@Import(value={LoanSlotConfig.class, CalendarConfig.class})
public class LoanSlotImplConfig {
    @NonNull
    private final Converter<Kat1_5, Exemplar> kat15ToExemplarMapper;
    @NonNull
    private final Converter<Kat1_4, Record> kat14ToRecordMapper;
    @NonNull
    private final ByIdLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final ObjectMapper jsonMapper;
    @NonNull
    private final DefaultSlotAvailabilityResolver slotAvailabilityResolver;

    @Bean
    public DelegatingKat15BasedSlotAvailabilityResolver kat15BasedSlotAvailabilityResolver() {
        return new DelegatingKat15BasedSlotAvailabilityResolver((SlotAvailabilityResolver)this.slotAvailabilityResolver, this.kat15ToExemplarMapper, this.kat14ToRecordMapper, this.basicUserLoader);
    }

    @Bean
    public SingleValueRepository<DateRange, String> dateRangeRepository() {
        return new IdBase64ingSingleValueRepository((SingleValueRepository)new DateRangeJsonRepository(this.jsonMapper));
    }

    @ConstructorProperties(value={"kat15ToExemplarMapper", "kat14ToRecordMapper", "basicUserLoader", "jsonMapper", "slotAvailabilityResolver"})
    @Generated
    public LoanSlotImplConfig(@NonNull Converter<Kat1_5, Exemplar> kat15ToExemplarMapper, @NonNull Converter<Kat1_4, Record> kat14ToRecordMapper, @NonNull ByIdLoadable<BasicUser, Integer> basicUserLoader, @NonNull ObjectMapper jsonMapper, @NonNull DefaultSlotAvailabilityResolver slotAvailabilityResolver) {
        Objects.requireNonNull(kat15ToExemplarMapper, "kat15ToExemplarMapper is marked non-null but is null");
        Objects.requireNonNull(kat14ToRecordMapper, "kat14ToRecordMapper is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(jsonMapper, "jsonMapper is marked non-null but is null");
        Objects.requireNonNull(slotAvailabilityResolver, "slotAvailabilityResolver is marked non-null but is null");
        this.kat15ToExemplarMapper = kat15ToExemplarMapper;
        this.kat14ToRecordMapper = kat14ToRecordMapper;
        this.basicUserLoader = basicUserLoader;
        this.jsonMapper = jsonMapper;
        this.slotAvailabilityResolver = slotAvailabilityResolver;
    }
}

