/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.as.web.ExceptionLoggingServletFilter;
import cz.kpsys.kpwin2.rest.startup.Startup;
import cz.kpsys.kpwin2.rest.startup.StartupApiController;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerToAnyConverter;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.web.log.MemoryIncreaseLoggingFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class ServletConfig {
    @NonNull
    private final Provider<Licence> licenceProvider;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final ObjectMapper xmlMapper;

    @Bean
    public StartupApiController startupApiController() {
        return new StartupApiController(this.licenceProvider, this.departmentLoader, this.rootDepartmentProvider);
    }

    @Bean
    public ServletRegistrationBean<Startup> startupServletRegistrationBean() {
        Startup startup = new Startup(this.licenceProvider, this.rootDepartmentProvider, (Converter)StringToIntegerToAnyConverter.strict((Converter)new IdToObjectConverter(this.departmentLoader)), this.xmlMapper);
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)startup, new String[]{"/oldstartup/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }

    @Bean
    public FilterRegistrationBean<ExceptionLoggingServletFilter> loggingFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new ExceptionLoggingServletFilter());
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<MemoryIncreaseLoggingFilter> memoryIncreaseLoggingFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new MemoryIncreaseLoggingFilter());
        return registrationBean;
    }

    @ConstructorProperties(value={"licenceProvider", "rootDepartmentProvider", "departmentLoader", "xmlMapper"})
    @Generated
    public ServletConfig(@NonNull Provider<Licence> licenceProvider, @NonNull Provider<Department> rootDepartmentProvider, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull ObjectMapper xmlMapper) {
        Objects.requireNonNull(licenceProvider, "licenceProvider is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(xmlMapper, "xmlMapper is marked non-null but is null");
        this.licenceProvider = licenceProvider;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.departmentLoader = departmentLoader;
        this.xmlMapper = xmlMapper;
    }
}

