/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import cz.kpsys.portaro.commons.barcode.ValidLengthBarCodeValidator;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadableByAllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.SpringDbBasicUserLoader;
import cz.kpsys.portaro.user.SpringDbUserIdSearchLoader;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class UserConfig {
    @NonNull
    private final NamedParameterJdbcOperations autoCommittingJdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;

    @Bean
    public IdAndIdsLoadable<BasicUser, Integer> basicUserLoader() {
        SpringDbBasicUserLoader databaseAllByIdsLoader = new SpringDbBasicUserLoader(this.autoCommittingJdbcTemplate, this.queryFactory);
        ChunkingAllByIdsLoader chunkingAllByIdsLoader = ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)databaseAllByIdsLoader);
        return new ByIdLoadableByAllByIdsLoadable((AllByIdsLoadable)chunkingAllByIdsLoader, BasicUser.class);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Integer> userIdSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new SpringDbUserIdSearchLoader(this.autoCommittingJdbcTemplate, this.queryFactory, () -> new ValidLengthBarCodeValidator((Provider)StaticProvider.of((Object)13))));
    }

    @ConstructorProperties(value={"autoCommittingJdbcTemplate", "queryFactory"})
    @Generated
    public UserConfig(@NonNull NamedParameterJdbcOperations autoCommittingJdbcTemplate, @NonNull QueryFactory queryFactory) {
        Objects.requireNonNull(autoCommittingJdbcTemplate, "autoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        this.autoCommittingJdbcTemplate = autoCommittingJdbcTemplate;
        this.queryFactory = queryFactory;
    }
}

