/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.web;

import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.licence.LicenceKeyUpdater;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/licence"})
@ResponseBody
public class LicenceApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenceApiController.class);
    @NonNull
    private final Provider<Licence> licenceProvider;
    @NonNull
    private final LicenceKeyUpdater licenceKeyUpdater;

    @GetMapping
    public String getLicence() {
        try {
            Licence licence = (Licence)this.licenceProvider.get();
            return licence.toString();
        }
        catch (Exception e) {
            log.error("Cannot get licence", (Throwable)e);
            return String.format("Cannot get licence: %s", e.getMessage());
        }
    }

    @GetMapping(value={"/update"})
    public String updateLicence() {
        try {
            this.licenceKeyUpdater.update();
            return String.format("Licence key updated to %s", this.licenceProvider.get());
        }
        catch (Exception e) {
            log.error("Cannot update licence key", (Throwable)e);
            return String.format("Cannot update licence key: %s", e.getMessage());
        }
    }

    @ConstructorProperties(value={"licenceProvider", "licenceKeyUpdater"})
    @Generated
    public LicenceApiController(@NonNull Provider<Licence> licenceProvider, @NonNull LicenceKeyUpdater licenceKeyUpdater) {
        Objects.requireNonNull(licenceProvider, "licenceProvider is marked non-null but is null");
        Objects.requireNonNull(licenceKeyUpdater, "licenceKeyUpdater is marked non-null but is null");
        this.licenceProvider = licenceProvider;
        this.licenceKeyUpdater = licenceKeyUpdater;
    }
}

