/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.common.IniConstants;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.marc.Record;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AbstractGeneratorKlicu {
    protected final DbCore2 core2;
    protected final Record r;

    public AbstractGeneratorKlicu(DbCore2 core2, Record r) {
        this.core2 = core2;
        this.r = r.klonuj();
    }

    protected String nahradOddelovaceMezeramaSS(String input) {
        char[] delimetersArray;
        String delimeters = DbCache2.queryINIFlag((String)IniConstants.SEKCE_KPWIN(), (String)IniConstants.KPWIN_DELIM(), null, null);
        for (char c : delimetersArray = delimeters.toCharArray()) {
            input = input.replace(c, ' ');
        }
        input = input.replace("\u00df", "ss");
        return input;
    }

    protected String odstranDuplicitniMezeryAOrez(String input) {
        Pattern pattern = Pattern.compile("\\s+");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.replaceAll(" ").trim();
        }
        return input.trim();
    }

    private String odstranMensiVetsi(String input) {
        Pattern pattern = Pattern.compile("<<.*?>>");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.replaceAll("");
        }
        return input;
    }

    protected void rozsekejMezeryASvislitka(String input, List<String> slova, List<String> slovaVeSvislitkach) {
        if ((input = input.trim()).length() == 0) {
            return;
        }
        if (input.startsWith("|") && input.length() > 1) {
            int last = input.substring(1).indexOf(124);
            if (last == -1) {
                slova.add(input.substring(1));
                return;
            }
            slovaVeSvislitkach.add(input.substring(1, last + 1));
            this.rozsekejMezeryASvislitka(input.substring(last + 2), slova, slovaVeSvislitkach);
        } else {
            int last = input.indexOf(32);
            int lastSvislistko = input.indexOf(124);
            if (lastSvislistko > -1 && lastSvislistko < last) {
                last = lastSvislistko;
            }
            if (last == -1) {
                slova.add(input);
                return;
            }
            slova.add(input.substring(0, last));
            this.rozsekejMezeryASvislitka(input.substring(last), slova, slovaVeSvislitkach);
        }
    }

    public static void odstranVyloucenaPonenechejKlicovaSlova(List<String> slova) {
        ArrayList<String> slovaKOdstraneni = new ArrayList<String>(slova.size());
        Set klicovaSlova = DbCache2.defKliSlov;
        Set vyloucenaSlova = DbCache2.defVylSlov;
        for (String slovo : slova) {
            if (!vyloucenaSlova.contains(slovo) || klicovaSlova.contains(slovo)) continue;
            slovaKOdstraneni.add(slovo);
        }
        for (String slovo : slovaKOdstraneni) {
            slova.remove(slovo);
        }
    }

    protected void odstranSlovaMeziFrUvozovkami(List<String> slova) {
        ArrayList<String> slovaKOdstraneni = new ArrayList<String>(slova.size());
        for (String slovo : slova) {
            if (!slovo.startsWith("<<") || !slovo.endsWith(">>")) continue;
            slovaKOdstraneni.add(slovo);
        }
        for (String slovo : slovaKOdstraneni) {
            slova.remove(slovo);
        }
    }
}

