/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.IniConstants;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.VypujckaExecutor;
import cz.kpsys.db.model.VracInput;
import cz.kpsys.db.model.VypucInput;
import cz.kpsys.db.model.v2.Cirkulace;
import cz.kpsys.db.model.v2.CirkulaceVazby;
import cz.kpsys.db.model.v2.GeneratorNames;
import cz.kpsys.db.model.v2.PolCirkulace;
import cz.kpsys.db.model.v2.Vypuc2;
import cz.kpsys.service.Utils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CirkulaceExecutor {
    final Logger logger = LoggerFactory.getLogger(CirkulaceExecutor.class);
    private DbCore2 core2;

    public CirkulaceExecutor(DbCore2 core2) {
        this.core2 = core2;
    }

    public static int najdiDalsiCirkulaci(List<Cirkulace> cirkulaceList) {
        int indexPosledniPujcene = -1;
        for (int i = 0; i < cirkulaceList.size(); ++i) {
            Cirkulace cirkulaceNaRade = cirkulaceList.get(i);
            if (cirkulaceNaRade.getFK_VYPUC() == null) continue;
            indexPosledniPujcene = i;
        }
        if (indexPosledniPujcene + 1 < cirkulaceList.size()) {
            return indexPosledniPujcene + 1;
        }
        return -1;
    }

    public CirkulaceVazby overJestliZaznamVCirkulaci(long fkZaz) throws SQLException {
        QueryRunnerOpened qr = this.core2.obtainQueryRunnerOpened();
        CirkulaceVazby cirkulaceVazby = (CirkulaceVazby)qr.query("SELECT * FROM CIRKULACE_VAZBY WHERE FK_ZAZ=?", (ResultSetHandler)BeanHandlers.cirkulaceVazbyHandler(), new Object[]{fkZaz});
        return cirkulaceVazby;
    }

    public Vypuc2 vyridCirkulaci(VracInput vracInput, String oznaceni) throws SQLException, AppServerStatus {
        QueryRunnerOpened qr = this.core2.obtainQueryRunnerOpened();
        long idEx = vracInput.idEx;
        List cirkulaceList = this.nactiCirkulaci(idEx);
        if (cirkulaceList.size() == 0) {
            return null;
        }
        int idNext = CirkulaceExecutor.najdiDalsiCirkulaci((List)cirkulaceList);
        if (idNext == -1) {
            String pocirkulacniKategorieVypujcky = DbCache2.queryINIFlag((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.KATALOGIZACE_ZMENAKATEGORIEPOCIRKULACI(), (Short)vracInput.pujcovna, null);
            if (StringUtils.isNotBlank((CharSequence)pocirkulacniKategorieVypujcky)) {
                qr.update("UPDATE KAT1_5 SET FK_VYPKAT=? WHERE ID_EX=?", new Object[]{pocirkulacniKategorieVypujcky, idEx});
            }
            return null;
        }
        Cirkulace staraCirkulace = (Cirkulace)cirkulaceList.get(idNext - 1);
        Cirkulace aktualniCirkulace = (Cirkulace)cirkulaceList.get(idNext);
        qr.update("UPDATE VYPUC2 SET DAT_VR=" + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + " WHERE ID_VYPUC=?", (Object)staraCirkulace.getFK_VYPUC());
        VypucInput vypucInput = new VypucInput();
        vypucInput.idCten = aktualniCirkulace.getFK_UZIV_CTEN();
        vypucInput.idEx = vracInput.idEx;
        vypucInput.pujcovna = vracInput.pujcovna;
        vypucInput.oznaceni = oznaceni;
        vypucInput.setFkUzivAkce(vracInput.getFkUzivAkce());
        vypucInput.hlasitRezervaci = false;
        vypucInput.hlasitObjednavku = false;
        vypucInput.setPrepinac("HlasitUpominky", false);
        vypucInput.setPrepinac("HlasitNereg", false);
        vypucInput.setPrepinac("HlasitPrilohy", false);
        vypucInput.setPrepinac("HlasitMaxVypCelk", false);
        vypucInput.setPrepinac("HlasitMaxVypKomb", false);
        vypucInput.setPrepinac("HlasitMinVyp", false);
        vypucInput.setPrepinac("HlasitAktVyp", false);
        vypucInput.setPrepinac("HlasitDluhy", false);
        vypucInput.setPrepinac("HlasitCiziBudovy", false);
        vypucInput.setPrepinac("HlasitCiziLokace", false);
        VypujckaExecutor vypujckaExecutor = new VypujckaExecutor(this.core2, vypucInput);
        try {
            Vypuc2 vypuc2 = vypujckaExecutor.vypuc();
            return vypuc2;
        }
        catch (AppServerStatus ss) {
            this.logger.error("vybouchlo to na vyjimce", (Throwable)ss);
            if (ss.getErrorCode() == 42) {
                qr.update("DELETE FROM CIRKULACE WHERE ID_CIRKULACE=?", (Object)aktualniCirkulace.getID_CIRKULACE());
                return this.vyridCirkulaci(vracInput, oznaceni);
            }
            AppServerStatus ase = new AppServerStatus("selhani vypujcky cirkulace", 49);
            ase.addReturnValue("ERR_VYPUC_CODE", Integer.toString(ss.getErrorCode()));
            ase.addReturnValue("ERR_VYPUC_MESSAGE", ss.getMessage());
            ase.addReturnValue("CIRK_CTEN", Integer.toString(aktualniCirkulace.getFK_UZIV_CTEN()));
            throw ase;
        }
    }

    public List<PolCirkulace> nactiVzorCirkulace(int fkHlCirk) throws SQLException {
        QueryRunnerOpened qr = this.core2.obtainQueryRunnerOpened();
        List polCirkulaceList = (List)qr.query("SELECT * FROM POL_CIRKULACE WHERE FK_HLCIRK=? ORDER BY PORADI", (ResultSetHandler)new KPSYSBeanListHandler(PolCirkulace.class), new Object[]{fkHlCirk});
        return polCirkulaceList;
    }

    public List<Cirkulace> nactiCirkulaci(long fkEx) throws SQLException {
        QueryRunnerOpened qr = this.core2.obtainQueryRunnerOpened();
        List cirkulace = (List)qr.query("SELECT * FROM CIRKULACE WHERE FK_EX=?", (ResultSetHandler)new KPSYSBeanListHandler(Cirkulace.class), new Object[]{fkEx});
        return cirkulace;
    }

    public List<Cirkulace> zalozCirkulaci(List<PolCirkulace> vzorCirkulace, long fkEx) throws SQLException {
        ArrayList<Cirkulace> cirkulaceList = new ArrayList<Cirkulace>(vzorCirkulace.size());
        QueryRunnerOpened qr = this.core2.obtainQueryRunnerOpened();
        for (PolCirkulace polCirkulace : vzorCirkulace) {
            Cirkulace cirkulace = new Cirkulace();
            cirkulace.setFK_UZIV_CTEN(polCirkulace.getFK_UZIV_CTEN());
            cirkulace.setFK_EX(fkEx);
            cirkulace.setPORADI(polCirkulace.getPORADI());
            cirkulace.setPOCET_DNU(polCirkulace.getPOCET_DNU());
            int idCirkulace = (int)this.core2.generateID(GeneratorNames.SEQ_ID_CIRKULACE);
            qr.update("INSERT INTO CIRKULACE (ID_CIRKULACE, FK_EX, FK_UZIV_CTEN, PORADI, POCET_DNU, FK_VYPUC) VALUES (?, ?, ?, ?, ?, NULL)", new Object[]{idCirkulace, fkEx, cirkulace.getFK_UZIV_CTEN(), cirkulace.getPORADI(), cirkulace.getPOCET_DNU()});
            cirkulaceList.add(cirkulace);
        }
        return cirkulaceList;
    }
}

