/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.SingleConnectionDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCore {
    private static final Logger logger = LoggerFactory.getLogger(DbCore.class);
    public int version = 0;
    protected Connection conn;

    public void setConnection(Connection conn) {
        if (this.conn != null && this.conn != conn) {
            try {
                if (!this.conn.isClosed()) {
                    this.conn.close();
                }
            }
            catch (SQLException e) {
                logger.warn("problem pri zavirani spojeni v DbCore.setConnection", (Throwable)e);
            }
        }
        this.conn = conn;
    }

    public QueryRunner obtainQueryRunner() {
        if (this.conn == null) {
            throw new IllegalArgumentException("conn==null");
        }
        QueryRunner qr = new QueryRunner((DataSource)new SingleConnectionDataSource(this.conn));
        return qr;
    }

    public QueryRunnerOpened obtainQueryRunnerOpened() {
        if (this.conn == null) {
            throw new IllegalArgumentException("conn==null");
        }
        QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(this.conn));
        return qr;
    }

    public ScalaRunnerOpened obtainScalaRunnerOpened() {
        if (this.conn == null) {
            throw new IllegalArgumentException("conn==null");
        }
        ScalaRunnerOpened qr = new ScalaRunnerOpened(this.conn);
        return qr;
    }

    public Connection getConn() {
        return this.conn;
    }
}

