/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.UnauthorizedException;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.DbConfig;
import cz.kpsys.db.DbCore;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbCore2Utils;
import cz.kpsys.db.LongListHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.SingleConnectionDataSource;
import cz.kpsys.db.TableColumnDescriptor;
import cz.kpsys.db.TableDescriptor;
import cz.kpsys.db.VracExecutor;
import cz.kpsys.db.model.RezervaceResult;
import cz.kpsys.db.model.VracInput;
import cz.kpsys.db.model.VracOutput;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefVypKat;
import cz.kpsys.db.model.v2.FDef;
import cz.kpsys.db.model.v2.FDefAut;
import cz.kpsys.db.model.v2.GeneratorNames;
import cz.kpsys.db.model.v2.Kat1_1;
import cz.kpsys.db.model.v2.Kat1_2;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.db.model.v2.Kat1_7;
import cz.kpsys.db.model.v2.Kataut_1;
import cz.kpsys.db.model.v2.Kataut_2;
import cz.kpsys.db.model.v2.Kataut_4;
import cz.kpsys.db.model.v2.LogManager;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.MarcUtils;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.SessionData;
import cz.kpsys.marc.SubField;
import cz.kpsys.portaro.record.RecordStatus;
import cz.kpsys.service.FullTextService;
import cz.kpsys.service.TaskScheduler$;
import cz.kpsys.service.Utils;
import cz.kpsys.service.cache.RecordIdCache;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Node;
import org.firebirdsql.management.FBBackupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

/*
 * Exception performing whole class analysis ignored.
 */
public class DbCore2
extends DbCore {
    private static final Logger logger = LoggerFactory.getLogger(DbCore2.class);
    private long sessionID;
    private SessionData sessionData;
    private long lastCommitTime = 0L;
    private boolean akceObnoveni = false;
    private int akceObnoveniFkCten;

    @Deprecated
    public DbCore2() {
        this.version = 2;
    }

    public DbCore2(Connection conn) {
        this.version = 2;
        this.conn = conn;
    }

    public static void backupDB(String database, String host, int port, String username, String password, String destDir) throws SQLException {
        FBBackupManager manager = new FBBackupManager();
        manager.setBackupPath(destDir);
        manager.setDatabase(database);
        manager.setPort(port);
        manager.setHost(host);
        manager.setRestoreReplace(false);
        manager.setUser(username);
        manager.setPassword(password);
        manager.setVerbose(true);
        try {
            manager.backupDatabase();
        }
        catch (SQLException se) {
            logger.error("problem pri zaloze DB", (Throwable)se);
            throw se;
        }
    }

    public static String obtainFirebirdServerVersion() throws SQLException {
        QueryRunner qr = ProxoolUtil.obtainQueryRunnerRO();
        String version = qr.query("SELECT rdb$get_context('SYSTEM', 'ENGINE_VERSION') from rdb$database", (ResultSetHandler)new ScalarHandler()).toString();
        return version;
    }

    public static String obtainPostgresServerVersion() throws SQLException {
        QueryRunner qr = ProxoolUtil.obtainQueryRunnerRO();
        String version = qr.query("SELECT version();", (ResultSetHandler)new ScalarHandler()).toString();
        return version;
    }

    public static void initDbCore(DbConfig dbConfig) throws SQLException {
        DbCore2.testConnection();
        DbCore2.initCaches();
    }

    public static void initCaches() {
        logger.info("DbCache2 init");
        try {
            DbCache2.cacheAll();
        }
        catch (Exception e) {
            logger.error("selhalo nacitani cache, koncim beh AS", (Throwable)e);
            System.exit(2);
        }
    }

    public static void relogUserCommit(int uCode, short fkPujc, Connection connection, DatabaseEngine dbe) throws SQLException {
        DbCore2.relogUser((int)uCode, (short)fkPujc, (Connection)connection, (DatabaseEngine)dbe, (boolean)true);
    }

    public static void relogUser(int uCode, short fkPujc, Connection connection, boolean commit) throws SQLException {
        DbCore2.relogUser((int)uCode, (short)fkPujc, (Connection)connection, (DatabaseEngine)ProxoolUtil.engine(), (boolean)commit);
    }

    public static void relogUser(int uCode, short fkPujc, Connection connection, DatabaseEngine dbe, boolean commit) throws SQLException {
        PreparedStatement st = null;
        if (dbe == DatabaseEngine.FIREBIRD) {
            st = connection.prepareStatement("EXECUTE PROCEDURE RELOG_USER2(?,?)");
            st.setInt(1, uCode);
            st.setShort(2, fkPujc);
        } else if (dbe != DatabaseEngine.POSTGRESQL) {
            dbe.unknownEngine();
        }
        if (st != null) {
            st.executeUpdate();
            if (commit) {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                } else {
                    logger.warn("pokus o commit spojeni, ktere je v autocommit rezimu " + connection);
                }
            }
            st.close();
        }
    }

    private static void testConnection() {
        DbConfig dbConfig = ProxoolUtil.dbConfig;
        logger.info("testuji pripojeni kpwin schema ver. " + dbConfig.dbVersion() + " db engine: " + dbConfig.dbEngine() + " - " + dbConfig.jdbcURL());
        try {
            QueryRunner qr = new QueryRunner();
            Connection conn = ProxoolUtil.obtainConnection();
            qr.query(conn, "SELECT COUNT(*) FROM FDef", arg0 -> "OK");
            conn.close();
        }
        catch (Exception e) {
            logger.error("behem testovani spojeni nastala vyjimka " + e.getMessage(), (Throwable)e);
        }
        logger.info("spojeni uspesne navazano");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean loginUser(Connection conn, String userName, int fkUziv) throws SQLException {
        PreparedStatement st = conn.prepareStatement("SELECT UROVEN FROM LOG_IN_USER20(?, ?)");
        st.setString(1, userName);
        st.setInt(2, fkUziv);
        try {
            if (!st.execute()) {
                logger.error("chyba pri prihlasovani uzivatele " + userName + ":" + fkUziv);
                boolean bl = false;
                return bl;
            }
            ResultSet rs = st.getResultSet();
            if (rs.next()) {
                logger.info("prihlasen uzivatel s urovni " + rs.getInt(1));
            }
            rs.close();
        }
        finally {
            st.close();
            conn.commit();
        }
        return true;
    }

    public static synchronized void naplanujAutomatickeUlohy() {
        logger.info("detekovana zmena v naplanovanych ulohach");
        TaskScheduler$.MODULE$.cancel();
        TaskScheduler$.MODULE$.scheduleTasks();
    }

    public static String otaznicky(int pocet) {
        switch (pocet) {
            case 0: {
                return "";
            }
            case 1: {
                return "?";
            }
        }
        return "?," + DbCore2.otaznicky((int)(pocet - 1));
    }

    public static void logManager(LogManager logManager) {
        logger.info("akce provadena s /manager: " + logManager);
        try (Connection conn = ProxoolUtil.obtainConnection();){
            QueryRunner qr = ProxoolUtil.obtainQueryRunnerOpened((Connection)conn);
            String parametryParam = StringUtils.left((String)logManager.getPARAMETRY(), (int)DbCore2Utils.MAX_LEN_LOG_MANAGER$.MODULE$.parametry());
            String statusParam = StringUtils.left((String)logManager.getSTATUS(), (int)DbCore2Utils.MAX_LEN_LOG_MANAGER$.MODULE$.status());
            qr.update("INSERT INTO LOG_MANAGER (AKCE, TYP_AKCE, PARAMETRY, STATUS) VALUES (?,?,?,?)", new Object[]{logManager.getAKCE(), logManager.getTYP_AKCE(), parametryParam, statusParam});
            conn.commit();
        }
        catch (SQLException se) {
            logger.error("P: logovani do tabulky LOG_MANAGER", (Throwable)se);
        }
    }

    public int fkUziv() {
        if (this.sessionData == null) {
            return 0;
        }
        return this.sessionData.getUcode();
    }

    public void closeConnectionRollback() {
        if (this.conn != null) {
            try {
                if (!this.conn.isClosed()) {
                    logger.info("rollback na connection " + this.conn);
                    this.conn.rollback();
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (SQLException e) {
                logger.error("selhani", (Throwable)e);
            }
        }
    }

    public void closeConnectionCommit() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.commit();
            this.conn.close();
        }
        this.conn = null;
    }

    public void reopenConnectionCommit() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.commit();
            this.conn.close();
        }
        this.conn = null;
        this.setConnection(ProxoolUtil.obtainConnection());
    }

    public void reopenConnectionCommitAfter(int limit) throws SQLException {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCommitTime > (long)(limit * 1000)) {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.commit();
                this.conn.close();
            }
            this.conn = null;
            this.setConnection(ProxoolUtil.obtainConnection());
            this.lastCommitTime = currentTime;
        }
    }

    private boolean validateSession(SessionData sessionData) {
        1 th = new /* Unavailable Anonymous Inner Class!! */;
        try {
            return (Boolean)th.process();
        }
        catch (Exception e) {
            logger.error("selhani", (Throwable)e);
            return false;
        }
    }

    public int executeUpdate(String cmd) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(cmd);
        int rows = ps.executeUpdate();
        ps.close();
        return rows;
    }

    public void relogUser(SessionData sessionData) throws SQLException {
        if (sessionData == null) {
            throw new SQLException("chybi udaje o uzivatelske session");
        }
        this.sessionData = sessionData;
        DbCore2.relogUserCommit((int)sessionData.getUcode(), (short)sessionData.pujcovna, (Connection)this.conn, (DatabaseEngine)ProxoolUtil.engine());
    }

    public List<Kataut_1> poleKZaznamuAutority(long recId) throws SQLException {
        ArrayList<Kataut_1> retList = new ArrayList<Kataut_1>(50);
        PreparedStatement ps = this.conn.prepareStatement("select FK_AUT, CIS_POL, PORADI_POLE, INDIK, OBSAH, DATCAS, FK_UZIV from KATAUT_1 where FK_AUT=? order by CIS_POL,PORADI_POLE");
        ps.setLong(1, recId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Kataut_1 kat1_1 = new Kataut_1();
            kat1_1.FK_AUT = rs.getLong(1);
            kat1_1.CIS_POL = rs.getShort(2);
            kat1_1.PORADI_POLE = rs.getShort(3);
            kat1_1.INDIK = rs.getString(4);
            kat1_1.OBSAH = rs.getString(5);
            kat1_1.DATCAS = rs.getTimestamp(6);
            kat1_1.FK_UZIV = rs.getInt(7);
            retList.add(kat1_1);
        }
        ps.close();
        return retList;
    }

    @Deprecated
    public List<Kat1_1> poleKZaznamu(long recId) throws SQLException {
        ArrayList<Kat1_1> retList = new ArrayList<Kat1_1>(50);
        PreparedStatement ps = this.conn.prepareStatement("select FK_ZAZ, CIS_POL, PORADI_POLE, INDIK, OBSAH, DATCAS, FK_UZIV from Kat1_1 where FK_ZAZ=? order by CIS_POL,PORADI_POLE");
        ps.setLong(1, recId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Kat1_1 kat1_1 = new Kat1_1();
            kat1_1.FK_ZAZ = rs.getLong(1);
            kat1_1.CIS_POL = rs.getShort(2);
            kat1_1.PORADI_POLE = rs.getShort(3);
            kat1_1.INDIK = rs.getString(4);
            kat1_1.OBSAH = rs.getString(5);
            kat1_1.DATCAS = rs.getTimestamp(6);
            kat1_1.FK_UZIV = rs.getInt(7);
            retList.add(kat1_1);
        }
        ps.close();
        return retList;
    }

    @Deprecated
    public boolean deleteRecord(Record r) {
        return this.deleteRecord(r.getId(), r.getFond());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean deleteRecord(long recId, short fond) {
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        try {
            if (DbCache2.jeDokFond((short)fond)) {
                qr.update("DELETE FROM KAT1_1 WHERE FK_ZAZ=?", (Object)recId);
                qr.update("DELETE FROM KAT1_4 WHERE ID_ZAZ=?", (Object)recId);
            } else {
                qr.update("DELETE FROM KATAUT_1 WHERE FK_AUT=?", (Object)recId);
                qr.update("DELETE FROM KATAUT_4 WHERE ID_AUT=?", (Object)recId);
            }
        }
        catch (SQLException he) {
            logger.error("selhani", (Throwable)he);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public boolean validateSessionData(SessionData sessionData) throws SQLException {
        if (sessionData == null || sessionData.getTypSession() != 2 && sessionData.getuSess() == null && sessionData.getTypSession() != 3) {
            logger.error("session data: " + sessionData);
            throw new UnauthorizedException("neplatna session data, nelze pokracovat neprihlaseny");
        }
        if (sessionData.getTypSession() == 0) {
            boolean loginKPWIN = KPWINServiceApplication.configuration.loginKPWIN();
            if (loginKPWIN) {
                return true;
            }
            String table = "LOG_UZIV";
            st.setLong(1, sessionData.getuSess());
            try (PreparedStatement st = this.conn.prepareStatement("SELECT FK_UZIV FROM LOG_UZIV WHERE ID=? AND LOGOFF_TIME IS NULL");){
                if (st.execute() && st.getResultSet().next()) {
                    boolean bl = true;
                    return bl;
                }
                logger.error("session data invalid, not found in LOG_UZIV");
                boolean bl = false;
                return bl;
            }
        }
        if (sessionData.getTypSession() == 1) {
            st.setLong(1, sessionData.getuSess());
            try (PreparedStatement st = this.conn.prepareStatement("SELECT CLIENT_IP FROM LOG_UZIV_OPAC WHERE ID=? AND LOGOFF_TIME IS NULL");){
                if (st.execute() && st.getResultSet().next()) {
                    boolean table = true;
                    return table;
                }
                logger.error("session data invalid, not found in LOG_UZIV_OPAC");
                boolean table = false;
                return table;
            }
        }
        if (sessionData.getTypSession() == 2) {
            int idUziv = sessionData.getUcode();
            short idPujc = sessionData.getPujcovna();
            try {
                PreparedStatement st = this.conn.prepareStatement("SELECT * FROM DEF_UZIV WHERE FK_UZIV=?");
                st.setInt(1, idUziv);
                if (st.execute()) {
                    ResultSet rs;
                    ResultSet rsLogin = st.getResultSet();
                    if (!rsLogin.next()) {
                        return false;
                    }
                    st.close();
                    PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM DEF_PUJC WHERE FK_BUDOVA=? ORDER BY ID_PUJC");
                    ps.setInt(1, idPujc);
                    if (ps.execute() && (rs = ps.getResultSet()).next()) {
                        sessionData.setPujcovna(Short.valueOf(rs.getShort("ID_PUJC")));
                        ps.close();
                        return true;
                    }
                    ps.close();
                    return true;
                }
                st.close();
                return false;
            }
            catch (SQLException e) {
                logger.error("selhani", (Throwable)e);
                throw e;
            }
        }
        return sessionData.getTypSession() == 3;
    }

    public Tuple2<Long, Long> saveOrUpdateKat1_4(Record r, Kat1_4 kat1_4) throws SQLException {
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        if (r.getRecordStatus() != RecordStatus.DELETED.getId().intValue()) {
            long idZaz;
            if (kat1_4.ID_ZAZ == 0L) {
                kat1_4.ID_ZAZ = this.generateID(GeneratorNames.SEQ_ID_ZAZ);
            }
            if (kat1_4.FK_ZAZ == 0L) {
                kat1_4.FK_ZAZ = kat1_4.ID_ZAZ;
            }
            if (kat1_4.NAZEV == null) {
                kat1_4.NAZEV = " ";
            }
            if (kat1_4.TRIDNAZ == null) {
                kat1_4.TRIDNAZ = " ";
            }
            if (kat1_4.FLATNAZ == null) {
                kat1_4.FLATNAZ = " ";
            }
            if (kat1_4.getSTATUS4() < 0) {
                throw new IllegalStateException(kat1_4 + " neplatny status: " + kat1_4.getSTATUS4());
            }
            String autor = StringUtils.left((String)kat1_4.AUTOR, (int)DbCore2Utils.MAX_LEN_DOK_AUTOR());
            String nakladatel = StringUtils.left((String)kat1_4.NAKL, (int)DbCore2Utils.MAX_LEN_DOK_NAKLADATEL());
            String tridNaz = StringUtils.left((String)kat1_4.TRIDNAZ, (int)DbCore2Utils.MAX_LEN_DOK_TRIDNAZ());
            String tridNazKlic = StringUtils.left((String)kat1_4.TRIDNAZ_KLIC, (int)DbCore2Utils.MAX_LEN_AUT_TRIDNAZKLIC());
            kat1_4.ID_ZAZ = idZaz = ((Long)qr.query("UPDATE OR INSERT INTO KAT1_4 (NAZEV, ID_ZAZ, FK_ZAZ,AUTOR,NAKL,ISBN,ISBN_CORE,ROK_OD,ROK_DO,STATUS4,FK_DOKFOND,TRIDNAZ,TRIDNAZ_KLIC,FLATNAZ,FK_UZIV,DATCAS,RECORD_ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) RETURNING ID_ZAZ", (ResultSetHandler)BeanHandlers.LONG_HANDLER(), new Object[]{kat1_4.NAZEV, kat1_4.ID_ZAZ, kat1_4.FK_ZAZ, autor, nakladatel, kat1_4.ISBN, kat1_4.getISBN_CORE(), kat1_4.ROK_OD, kat1_4.ROK_DO, kat1_4.STATUS4, kat1_4.FK_DOKFOND, tridNaz, tridNazKlic, kat1_4.FLATNAZ, kat1_4.FK_UZIV, kat1_4.DATCAS, kat1_4.RECORD_ID})).longValue();
            RecordIdCache.remember((Kat1_4)kat1_4);
        } else {
            if (kat1_4.getID_ZAZ() == 0L) {
                throw new IllegalArgumentException("nelze smazat zaznam 0");
            }
            qr.update("UPDATE KAT1_4 SET STATUS4=? WHERE ID_ZAZ=?", new Object[]{kat1_4.getSTATUS4(), kat1_4.getID_ZAZ()});
        }
        qr.update("UPDATE RECORD SET RECORD_STATUS_ID=?, SORTING_KEY=? WHERE ID=?", new Object[]{r.getRecordStatus(), kat1_4.getTRIDNAZ_KLIC(), r.recordId});
        DbCore2Utils utils = new DbCore2Utils(this);
        long fkFullTextSkup = utils.zapisFullTextSkupinu(this.obtainScalaRunnerOpened(), (Either)Left.apply((Object)kat1_4));
        return Tuple2.apply((Object)kat1_4.getID_ZAZ(), (Object)fkFullTextSkup);
    }

    public Long saveOrUpdateKataut_1(Kataut_1 kataut_1) throws SQLException {
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        String obsah = kataut_1.OBSAH;
        if (kataut_1.FK_AUT == 0L) {
            logger.error("FK_AUT=0");
        }
        Long idAut = (Long)qr.query("UPDATE OR INSERT INTO KATAUT_1 (FK_AUT, CIS_POL, PORADI_POLE, INDIK, OBSAH, DATCAS, FK_UZIV) VALUES (?,?,?,?,?,?,?) MATCHING (FK_AUT, CIS_POL, PORADI_POLE) RETURNING FK_AUT", (ResultSetHandler)BeanHandlers.LONG_HANDLER(), new Object[]{kataut_1.FK_AUT, kataut_1.CIS_POL, kataut_1.PORADI_POLE, kataut_1.INDIK, obsah, kataut_1.DATCAS, kataut_1.FK_UZIV});
        return idAut;
    }

    public Tuple2<Long, Long> saveOrUpdateKataut_4(Record r, Kataut_4 kataut_4) throws SQLException {
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        if (r.getRecordStatus() != RecordStatus.DELETED.getId().intValue()) {
            long idAut;
            if (kataut_4.ID_AUT == 0L) {
                kataut_4.ID_AUT = this.generateID(GeneratorNames.SEQ_ID_AUT);
            }
            if (kataut_4.FK_AUT == 0L) {
                kataut_4.FK_AUT = kataut_4.ID_AUT;
            }
            if (kataut_4.NAZEV == null) {
                kataut_4.NAZEV = " ";
            }
            if (kataut_4.TRIDNAZ == null) {
                kataut_4.TRIDNAZ = " ";
            }
            if (kataut_4.FLATNAZ == null) {
                kataut_4.FLATNAZ = " ";
            }
            if (kataut_4.getSTATUS4() < 0) {
                throw new IllegalStateException(kataut_4 + " neplatny status: " + kataut_4.getSTATUS4());
            }
            String nazev = StringUtils.left((String)kataut_4.getNAZEV(), (int)DbCore2Utils.MAX_LEN_AUT_NAZEV());
            String tridNaz = StringUtils.left((String)kataut_4.getTRIDNAZ(), (int)DbCore2Utils.MAX_LEN_AUT_TRIDNAZ());
            String tridNazKlic = StringUtils.left((String)kataut_4.getTRIDNAZ_KLIC(), (int)DbCore2Utils.MAX_LEN_AUT_TRIDNAZKLIC());
            String flatNaz = StringUtils.left((String)kataut_4.getFLATNAZ(), (int)DbCore2Utils.MAX_LEN_AUT_FLATNAZ());
            String cisNarAut = StringUtils.left((String)kataut_4.getCIS_NAR_AUT(), (int)DbCore2Utils.MAX_LEN_AUT_CISNARAUT());
            kataut_4.ID_AUT = idAut = ((Long)qr.query("UPDATE OR INSERT INTO KATAUT_4 (NAZEV, ID_AUT, CIS_NAR_AUT,STATUS4,FK_AUTFOND,TRIDNAZ,TRIDNAZ_KLIC,FLATNAZ,STATAUT,FK_AUT,FK_UZIV,DATCAS,RECORD_ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?) RETURNING ID_AUT", (ResultSetHandler)BeanHandlers.LONG_HANDLER(), new Object[]{nazev, kataut_4.ID_AUT, cisNarAut, kataut_4.getSTATUS4(), kataut_4.FK_AUTFOND, tridNaz, tridNazKlic, flatNaz, kataut_4.STATAUT, kataut_4.FK_AUT, kataut_4.FK_UZIV, kataut_4.DATCAS, kataut_4.RECORD_ID})).longValue();
            RecordIdCache.remember((Kataut_4)kataut_4);
        } else {
            if (kataut_4.getID_AUT() == 0L) {
                throw new IllegalArgumentException("nelze smazat zaznam 0");
            }
            qr.update("UPDATE KATAUT_4 SET STATUS4=? WHERE ID_AUT=?", new Object[]{kataut_4.getSTATUS4(), kataut_4.getID_AUT()});
        }
        qr.update("UPDATE RECORD SET RECORD_STATUS_ID=?, SORTING_KEY=? WHERE ID=?", new Object[]{r.getRecordStatus(), kataut_4.getTRIDNAZ_KLIC(), r.recordId});
        DbCore2Utils utils = new DbCore2Utils(this);
        long fullTextSkupId = utils.zapisFullTextSkupinu(this.obtainScalaRunnerOpened(), (Either)Right.apply((Object)kataut_4));
        return Tuple2.apply((Object)kataut_4.getID_AUT(), (Object)fullTextSkupId);
    }

    public Short zjistiCisloFonduAutority(Record r, Field f, SubField sf) {
        if (r.isAuthority()) {
            FDefAut fDefAut = DbCache2.najdiFDefAut((int)f.getNumber(), (String)sf.getPrefix());
            if (fDefAut != null) {
                return fDefAut.FONDEXT;
            }
            return null;
        }
        FDef fDef = DbCache2.najdiFDef((int)f.getNumber(), (String)sf.getPrefix());
        if (fDef != null) {
            return fDef.FONDEXT;
        }
        return null;
    }

    public Short zjistiTypAutority(Record r, Field f, SubField sf) {
        if (r.isAuthority()) {
            FDefAut fDefAut = DbCache2.najdiFDefAut((int)f.getNumber(), (String)sf.getPrefix());
            if (fDefAut != null) {
                return fDefAut.AUTTYP;
            }
            return null;
        }
        FDef fDef = DbCache2.najdiFDef((int)f.getNumber(), (String)sf.getPrefix());
        if (fDef != null) {
            return fDef.AUTTYP;
        }
        return null;
    }

    public void processSubFieldsForAuthorities(Record r, Field f) {
        for (int i = 0; i < f.getSubfields().size(); ++i) {
            SubField sf = (SubField)f.getSubfields().get(i);
            if (sf.getAuthLink() <= 0L) continue;
            Short fond = this.zjistiCisloFonduAutority(r, f, sf);
            Short typ = this.zjistiTypAutority(r, f, sf);
            if (fond == null) {
                logger.error("v zaznamu " + r + " poli " + f + " predan odkaz na neexistujici autoritu " + sf.getAuthLink());
                continue;
            }
            sf.setContent(MarcUtils.formatAuthorityLink((short)typ, (short)fond, (long)sf.getAuthLink()));
        }
    }

    public String lineContent(Record r, Field f) {
        if (f.getNumber() < 10) {
            return f.getContent();
        }
        StringBuilder sb = new StringBuilder();
        for (SubField sf : f.getSubfields()) {
            sb.append("^" + sf.getPrefix() + sf.getContent());
        }
        return sb.toString();
    }

    public SessionData getUserSessionID(String username, String password) throws Exception {
        SessionData sessionData = null;
        PreparedStatement ps = this.conn.prepareStatement("SELECT FK_UZIV FROM DEF_UZIV WHERE JMENO=? AND HESLO=?");
        ps.setString(1, username);
        ps.setString(2, password);
        ResultSet rs = ps.executeQuery();
        rs.next();
        int fkUziv = rs.getInt(1);
        ps.close();
        ps = this.conn.prepareStatement("SELECT * FROM LOG_IN_USER20(?, ?);");
        ps.setString(1, username);
        ps.setInt(2, fkUziv);
        if (ps.execute() && (rs = ps.getResultSet()).next()) {
            long sessionID = rs.getLong("ROW_ID");
            this.conn.commit();
            sessionData = new SessionData();
            sessionData.setUcode(fkUziv);
            sessionData.setuSess(Long.valueOf(sessionID));
            rs.close();
            ps.close();
        }
        return sessionData;
    }

    public String posunRezervace(Long idEx, Optional<Short> fkPujc, int fkUziv) throws SQLException, AppServerStatus {
        String retString = null;
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        Kat1_5 kat1_5 = this.nactiKat1_5(idEx.longValue());
        if (kat1_5 == null) {
            return null;
        }
        if (kat1_5.getFK_PUJC() == null) {
            return null;
        }
        Kat1_4 kat1_4 = this.nactiKat1_4(kat1_5.getRECORD_ID());
        if (kat1_4 == null) {
            return null;
        }
        DefVypKat vypkatVraceny = (DefVypKat)((Map)DbCache2NG.vypKatMap().get()).get(kat1_5.getFK_VYPKAT());
        VracInput vracInput = new VracInput();
        vracInput.setFkUzivAkce(fkUziv);
        vracInput.pujcovna = !fkPujc.isPresent() ? DbCache2.prvniPujcovnaNaHlavniBudove().getID_PUJC() : fkPujc.get().shortValue();
        if (vracInput.pujcovna == 0) {
            vracInput.pujcovna = 1;
        }
        VracExecutor vracExecutor = new VracExecutor(this, vracInput);
        vracExecutor.pripravaZapisQueryDoKat1_5(kat1_4, kat1_5);
        VracOutput najdiARezervujOutput = new VracOutput();
        RezervaceResult rezervaceResult = vracExecutor.najdiARezervuj(najdiARezervujOutput, false, vypkatVraceny);
        if (rezervaceResult != null) {
            retString = "VYPUC.FK_VYPUC=" + rezervaceResult.fkVypuc();
        }
        return retString;
    }

    @Deprecated
    protected void writeField(int index, PreparedStatement ps, Node node, TableDescriptor tableDescriptor) throws SQLException {
        this.writeField(index, ps, node.getName(), node.getText(), tableDescriptor);
    }

    private void checkStringLength(String text, TableColumnDescriptor tdc) {
        if (ProxoolUtil.engine() == DatabaseEngine.FIREBIRD && text.length() > tdc.columnLength) {
            throw new IllegalArgumentException("hodnota pro sloupecek " + tdc.columnName + " je delsi nez maximalni povolena delka pole");
        }
    }

    @Deprecated
    public void writeField(int index, PreparedStatement ps, String columnName, String columnValue, TableDescriptor tableDescriptor) throws SQLException {
        TableColumnDescriptor columnDescriptor = (TableColumnDescriptor)tableDescriptor.tableColumns.get(columnName.toUpperCase());
        if (columnDescriptor == null) {
            throw new SQLException("sloupec/parametr " + columnName + " neexistuje");
        }
        if (ProxoolUtil.engine() == DatabaseEngine.FIREBIRD) {
            String columnType = columnDescriptor.columnType;
            if (logger.isDebugEnabled()) {
                logger.debug("sloupec: " + columnName + " typ: " + columnType);
            }
            switch (columnType) {
                case "SHORT": {
                    String text = columnValue;
                    if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("ano")) {
                        text = "1";
                    } else if (text.equalsIgnoreCase("false") || text.equalsIgnoreCase("ne")) {
                        text = "0";
                    }
                    ps.setShort(index, Short.parseShort(text));
                    break;
                }
                case "INT64": {
                    ps.setLong(index, Long.parseLong(columnValue));
                    break;
                }
                case "VARYING": 
                case "TEXT": {
                    ps.setString(index, columnValue);
                    break;
                }
                case "TIMESTAMP": {
                    ps.setTimestamp(index, Timestamp.valueOf(columnValue));
                    break;
                }
                case "SMALLINT": 
                case "BIGINT": 
                case "INTEGER": {
                    ps.setInt(index, Integer.parseInt(columnValue));
                }
            }
        }
    }

    public long generateID(GeneratorNames generatorName) throws SQLException {
        long id = 0L;
        if (ProxoolUtil.engine() == DatabaseEngine.FIREBIRD) {
            ResultSet rs;
            PreparedStatement st = this.conn.prepareStatement("SELECT GEN_ID(" + generatorName.name() + ", 1) FROM RDB$DATABASE");
            if (st.execute() && (rs = st.getResultSet()).next()) {
                id = rs.getLong(1);
                rs.close();
                st.close();
            }
        } else {
            ResultSet rs;
            PreparedStatement st = this.conn.prepareStatement("SELECT " + generatorName.name() + ".nextval FROM DUAL");
            if (st.execute() && (rs = st.getResultSet()).next()) {
                id = rs.getLong(1);
                rs.close();
                st.close();
            }
        }
        return id;
    }

    public void vymazVazbuKlice(QueryRunner qr, long fkZaz) throws SQLException {
        qr.update("DELETE FROM KAT1_3 WHERE FK_ZAZ=?", (Object)fkZaz);
    }

    public void zapisKlice(Record r, List<Kat1_2> seznamKlicuKZapisu) throws SQLException {
        this.zapisKlice(r.getFkZaz(), seznamKlicuKZapisu, true);
    }

    public void zapisKlice(long fkZaz, List<Kat1_2> seznamKlicuKZapisu, boolean smazStare) throws SQLException {
        DbCore2Utils utils = new DbCore2Utils(this);
        utils.zapisKlice(fkZaz, seznamKlicuKZapisu, smazStare);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public long orizniFondZOdkazuAutority(long id) {
        if (id < 101L) {
            return 0L;
        }
        return Long.parseLong(Long.toString(id).substring(2));
    }

    public void zapisKliceAut(long fkZaz, List<Kataut_2> seznamKlicuKZapisu) throws SQLException {
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        qr.update("DELETE FROM KATAUT_3 WHERE FK_AUT=?", (Object)fkZaz);
        for (Kataut_2 kataut_2 : seznamKlicuKZapisu) {
            String utfKlic = StringUtils.left((String)kataut_2.UTF_KLIC, (int)30);
            String flatKlic = StringUtils.left((String)kataut_2.FLAT_KLIC, (int)30);
            Long klic = (Long)qr.query("SELECT ID_KLIC FROM KATAUT_2 WHERE FK_AUTFOND=? AND CIS_POL=? AND UTF_KLIC=? AND FLAT_KLIC=?", (ResultSetHandler)BeanHandlers.LONG_HANDLER(), new Object[]{kataut_2.FK_AUTFOND, kataut_2.CIS_POL, utfKlic, flatKlic});
            if (ProxoolUtil.engine() == DatabaseEngine.FIREBIRD) {
                if (klic == null) {
                    klic = (Long)qr.query("INSERT INTO KATAUT_2 (FK_AUTFOND, CIS_POL, UTF_KLIC, FLAT_KLIC) VALUES (?, ?, ?, ?) RETURNING ID_KLIC", (ResultSetHandler)BeanHandlers.LONG_HANDLER(), new Object[]{kataut_2.FK_AUTFOND, kataut_2.CIS_POL, utfKlic, flatKlic});
                }
                kataut_2.ID_KLIC = klic;
            } else if (klic == null) {
                kataut_2.ID_KLIC = this.generateID(GeneratorNames.SEQ_ID_KLICAUT);
                qr.update("INSERT INTO KATAUT_2 (ID_KLIC, FK_AUTFOND, CIS_POL, UTF_KLIC, FLAT_KLIC) VALUES (?, ?, ?, ?, ?) ", new Object[]{kataut_2.ID_KLIC, kataut_2.getFK_AUTFOND(), kataut_2.getCIS_POL(), utfKlic, flatKlic});
            } else {
                kataut_2.setID_KLIC(klic.longValue());
            }
            qr.update("INSERT INTO KATAUT_3 (FK_AUT, FK_KLIC) VALUES (?, ?)", new Object[]{fkZaz, kataut_2.ID_KLIC});
        }
    }

    public void zapisVazbyNaAutority(Record r) throws SQLException {
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        qr.update("DELETE FROM KAT1_7 WHERE FK_ZAZ=? AND CIS_FOND IN (" + DbCache2.seznamAutFond + ")", (Object)r.getFkZaz());
        qr.update("DELETE FROM KAT1_7 WHERE SOURCE_RECORD_ID=? AND CIS_FOND IN (" + DbCache2.seznamAutFond + ")", (Object)r.recordId);
        if (r.jeSmazanyNeboOdstraneny()) {
            return;
        }
        for (Kat1_7 kat1_7 : r.seznamAutoritnichVazeb) {
            this.writeKat1_7(kat1_7, (QueryRunner)qr);
        }
    }

    public void writeKat1_7(Kat1_7 kat1_7, QueryRunner qr) throws SQLException {
        qr.update("INSERT INTO KAT1_7 (CIS_FOND, FK_AUT, FK_ZAZ, CIS_POL, SOURCE_RECORD_ID, TARGET_RECORD_ID) VALUES (?, ?, ?, ?, ?, ?) ", new Object[]{kat1_7.CIS_FOND, kat1_7.FK_AUT, kat1_7.FK_ZAZ, kat1_7.CIS_POL, kat1_7.SOURCE_RECORD_ID, kat1_7.TARGET_RECORD_ID});
    }

    public List<Record> readLineMarcFromFile(String fileName, int expectedRecordsCount, boolean zdvojeneStringy) {
        int MARC_FIELD_START_POSITION = 7;
        Record r = null;
        Field f = null;
        SubField sf = null;
        ArrayList<Record> records = new ArrayList<Record>(expectedRecordsCount);
        try {
            LineIterator it = FileUtils.lineIterator((File)new File(fileName));
            while (it.hasNext()) {
                String line = (String)it.next();
                if (zdvojeneStringy) {
                    line = line.replace("$$", "$");
                }
                String lineLC = line.toLowerCase();
                if (line.startsWith("##") || lineLC.startsWith("FMT")) continue;
                if (lineLC.startsWith("lab") || line.toLowerCase().startsWith("ldr")) {
                    if (r != null) {
                        records.add(r);
                    }
                    r = new Record();
                    r.setLeader(line.substring(7));
                    continue;
                }
                f = new Field();
                f.setNumber(Short.parseShort(line.substring(0, 3)));
                try {
                    short number = f.getNumber();
                    if (number < 10) {
                        f.setContent(line.substring(7));
                    } else {
                        f.setIndicators(line.substring(4, 6));
                        StringTokenizer st = new StringTokenizer(line.substring(7), "$");
                        while (st.hasMoreTokens()) {
                            String podpole = st.nextToken();
                            sf = new SubField();
                            sf.setPrefix(podpole.substring(0, 1));
                            sf.setContent(podpole.substring(1));
                            f.addSubfield(sf);
                        }
                    }
                    r.addField(f);
                }
                catch (Exception e) {
                    logger.error("selhani", (Throwable)e);
                }
            }
            records.add(r);
            logger.info("na\u010dteno " + records.size() + " z\u00e1znam\u016f");
        }
        catch (IOException e) {
            logger.error("Chyba p\u0159i otev\u00edr\u00e1n\u00ed " + fileName, (Throwable)e);
            e.printStackTrace();
        }
        return records;
    }

    public void commit() throws SQLException {
        logger.debug("core2 commit " + this.conn);
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        logger.info("core2 rollback " + this.conn);
        this.conn.rollback();
    }

    public SessionData getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(SessionData sessionData) {
        this.sessionData = sessionData;
    }

    @Deprecated
    public String todayString() {
        return Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine());
    }

    public String prvniSignatura(Record record) {
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        try {
            List exemplare = (List)qr.query("SELECT * FROM KAT1_5 WHERE RECORD_ID=? ORDER BY DATUM", (ResultSetHandler)BeanHandlers.kat1_5BLH(), new Object[]{record.recordId});
            for (Kat1_5 kat1_5 : exemplare) {
                String signa = kat1_5.getSIGNATURA();
                if (!StringUtils.isNotBlank((CharSequence)signa)) continue;
                return signa;
            }
        }
        catch (SQLException e) {
            logger.warn("nelze najit signaturu pro doplneni do 910b");
        }
        return null;
    }

    public void smazFullTextKZaznamu(Long fkFullTextSkupinyRoot) throws SQLException {
        if (fkFullTextSkupinyRoot != null) {
            FullTextService.smazFullTextKZaznamu((DbCore2)this, (long)fkFullTextSkupinyRoot, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kontrolaIndexuNadLokalizaci() {
        if (KPWINServiceApplication.dbConfig.dbEngine() != DatabaseEngine.FIREBIRD) {
            return;
        }
        Connection conn = null;
        try {
            logger.info("kontrola indexu nad lokalizaci");
            String zjistiIndexyStatement = "SELECT RDB$INDEX_NAME FROM RDB$INDICES WHERE RDB$RELATION_NAME='LOKALIZACE' AND RDB$FOREIGN_KEY IS NULL";
            conn = ProxoolUtil.obtainConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT RDB$INDEX_NAME FROM RDB$INDICES WHERE RDB$RELATION_NAME='LOKALIZACE' AND RDB$FOREIGN_KEY IS NULL");
            ResultSet rs = ps.executeQuery();
            HashSet<String> pritomneIndexy = new HashSet<String>();
            while (rs.next()) {
                pritomneIndexy.add(rs.getString(1).trim());
            }
            ps.close();
            if (pritomneIndexy.contains("PK_LOKALIZACE") || pritomneIndexy.contains("UNQ_LOKALIZACE") || pritomneIndexy.contains("IDX_LOKALIZACE")) {
                return;
            }
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            try {
                qr.update("ALTER TABLE LOKALIZACE ADD CONSTRAINT PK_LOKALIZACE PRIMARY KEY (ID_LOKALIZACE)");
            }
            catch (SQLException se) {
                try {
                    qr.update("CREATE UNIQUE INDEX UNQ_LOKALIZACE ON LOKALIZACE (ID_LOKALIZACE)");
                }
                catch (SQLException se1) {
                    try {
                        qr.update("CREATE INDEX IDX_LOKALIZACE ON LOKALIZACE (ID_LOKALIZACE)");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (SQLException se) {
            logger.warn("doslo k problemu behem kontroly indexu nad lokalizaci", (Throwable)se);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error("selhani", (Throwable)e);
                }
            }
        }
    }

    public void logujUdalostManager(String text, int code) throws SQLException {
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        qr.update("INSERT INTO BLABLABLA () VALUES (?,?)", new Object[]{text, code});
    }

    public String nowString() {
        if (ProxoolUtil.engine() == DatabaseEngine.FIREBIRD) {
            return "'NOW'";
        }
        return "SYSDATE";
    }

    public Kat1_4 nactiKat1_4(long idZaz) throws SQLException {
        Kat1_4 kat1_4 = null;
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        kat1_4 = (Kat1_4)qr.query("SELECT * FROM KAT1_4 WHERE ID_ZAZ=?", (ResultSetHandler)BeanHandlers.kat1_4BH(), new Object[]{idZaz});
        if (kat1_4 != null && kat1_4.getID_ZAZ() != kat1_4.getFK_ZAZ()) {
            return this.nactiKat1_4(kat1_4.getFK_ZAZ());
        }
        return kat1_4;
    }

    public Kat1_4 nactiKat1_4(String recordId) throws SQLException {
        Kat1_4 kat1_4 = null;
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        kat1_4 = (Kat1_4)qr.query("SELECT * FROM KAT1_4 WHERE RECORD_ID=?", (ResultSetHandler)BeanHandlers.kat1_4BH(), new Object[]{recordId});
        if (kat1_4 != null && kat1_4.getID_ZAZ() != kat1_4.getFK_ZAZ()) {
            return this.nactiKat1_4(kat1_4.getFK_ZAZ());
        }
        return kat1_4;
    }

    public Kat1_5 nactiKat1_5(long idEx) throws SQLException {
        Kat1_5 kat1_5 = null;
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        kat1_5 = (Kat1_5)qr.query("SELECT * FROM KAT1_5 WHERE ID_EX=?", (ResultSetHandler)BeanHandlers.kat1_5BH(), new Object[]{idEx});
        return kat1_5;
    }

    public Kataut_4 nactiKataut_4(long idAut) throws SQLException {
        Kataut_4 kataut_4 = null;
        QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
        kataut_4 = (Kataut_4)qr.query("SELECT * FROM KATAUT_4 WHERE ID_AUT=?", (ResultSetHandler)BeanHandlers.kataut_4BH(), new Object[]{idAut});
        if (kataut_4 != null && kataut_4.getID_AUT() != kataut_4.getFK_AUT()) {
            return this.nactiKataut_4(kataut_4.getFK_AUT());
        }
        return kataut_4;
    }

    public void kontrolaChybneNavazanychAutorit(QueryRunner qr, long idAut, List<Long> idVizTvaru, String message) throws SQLException {
        if (idVizTvaru == null) {
            idVizTvaru = (List)qr.query("SELECT ID_AUT FROM KATAUT_4 WHERE ID_AUT!=FK_AUT AND FK_AUT=? AND STATUS4<99", (ResultSetHandler)new LongListHandler(), new Object[]{idAut});
        }
        if (idVizTvaru.size() > 0) {
            String seznamVizTvaru = StringUtils.join(idVizTvaru, (String)",");
            qr.update("UPDATE KATAUT_1 SET FK_AUT=? WHERE FK_AUT IN (" + seznamVizTvaru + ")", (Object)idAut);
            qr.update("UPDATE AUT_VAZBY SET FK_AUTNAD=? WHERE FK_AUTNAD IN (" + seznamVizTvaru + ")", (Object)idAut);
            qr.update("UPDATE AUT_VAZBY SET FK_AUTPOD=? WHERE FK_AUTPOD IN (" + seznamVizTvaru + ")", (Object)idAut);
            qr.update("UPDATE KATAUT_3 SET FK_AUT=? WHERE FK_AUT IN (" + seznamVizTvaru + ")", (Object)idAut);
            qr.update("UPDATE KAT1_7 SET FK_AUT=? WHERE FK_AUT IN (" + seznamVizTvaru + ") AND CIS_FOND IN (" + DbCache2.seznamAutFond + ")", (Object)idAut);
        }
    }

    public static String dbEngineVersion(DatabaseEngine dbEngine) throws SQLException {
        return switch (2.$SwitchMap$cz$kpsys$db$DatabaseEngine[dbEngine.ordinal()]) {
            case 1 -> DbCore2.obtainFirebirdServerVersion();
            case 2 -> DbCore2.obtainPostgresServerVersion();
            default -> throw new IllegalArgumentException("neznamy db engine, nelze zjistit verzi DB enginu " + dbEngine);
        };
    }

    public void loginAsSU() throws SQLException {
        DbCore2.relogUserCommit((int)DbCache2.superUserID, (short)((Short)DbCache.rootPujcovna().get()), (Connection)this.conn, (DatabaseEngine)ProxoolUtil.engine());
    }

    public void loginAsAS() throws SQLException {
        DbCore2.relogUserCommit((int)DbCache2.appServerUserID, (short)((Short)DbCache.rootPujcovna().get()), (Connection)this.conn, (DatabaseEngine)ProxoolUtil.engine());
    }

    @Deprecated
    public void loginAsOPAC() throws SQLException {
        DbCore2.relogUserCommit((int)DbCache2.opacUserID, (short)((Short)DbCache.rootPujcovna().get()), (Connection)this.conn, (DatabaseEngine)ProxoolUtil.engine());
    }

    public void loginAsOPAC(short fkPujc) throws SQLException {
        DbCore2.relogUser((int)DbCache2.opacUserID, (short)fkPujc, (Connection)this.conn, (DatabaseEngine)ProxoolUtil.engine(), (boolean)false);
    }

    public void loginAsUziv(int fkUziv, short fkPujc) throws SQLException {
        DbCore2.relogUser((int)fkUziv, (short)fkPujc, (Connection)this.conn, (DatabaseEngine)ProxoolUtil.engine(), (boolean)false);
    }

    public void kontrolaDataObnoveni(Ctenari cten, short fkPujcZmena) throws SQLException {
        Date today = Utils.today();
        if (cten != null && cten.getKON_REG() != null && !today.after(cten.getKON_REG())) {
            Calendar cal = Calendar.getInstance();
            int letosniRok = cal.get(1);
            cal.set(letosniRok, 0, 1, 0, 0, 0);
            Date prvnihoLedna = cal.getTime();
            if (cten.getDAT_OBNOV() == null || cten.getDAT_OBNOV().before(prvnihoLedna)) {
                cten.setDAT_OBNOV((Date)Utils.util2sqlDate((Date)Utils.today()));
                logger.info("obnovuji ctenare " + cten);
                QueryRunnerOpened qr = this.obtainQueryRunnerOpened();
                qr.update("UPDATE CTENARI SET DAT_OBNOV=?, FK_PUJC_ZMENA=? WHERE FK_UZIV=?", new Object[]{cten.getDAT_OBNOV(), fkPujcZmena, cten.getFK_UZIV()});
            }
        }
    }

    public void closeConnectionCommitSilently() {
        try {
            this.closeConnectionCommit();
        }
        catch (SQLException se) {
            logger.error("P: zavirani spojeni", (Throwable)se);
        }
    }
}

