/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.portaro.CoreConstants;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.commons.dbutils.ResultSetHandler;

public class LocalDateTimeHandler
implements ResultSetHandler<LocalDateTime> {
    private final LocalDateTime defaultValue;

    public LocalDateTimeHandler(LocalDateTime defaultValue) {
        this.defaultValue = defaultValue;
    }

    public LocalDateTime handle(ResultSet rs) throws SQLException {
        if (rs.next()) {
            Timestamp value = rs.getTimestamp(1);
            if (value == null) {
                return this.defaultValue;
            }
            return value.toInstant().atZone(CoreConstants.CZECH_TIME_ZONE_ID).toLocalDateTime();
        }
        return this.defaultValue;
    }
}

