/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbCore2Utils;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.VracExecutor;
import cz.kpsys.db.model.RezervaceResult;
import cz.kpsys.db.model.SmazRezeInput;
import cz.kpsys.db.model.SmazRezeOutput;
import cz.kpsys.db.model.VracInput;
import cz.kpsys.db.model.VracOutput;
import cz.kpsys.db.model.v2.DefVypKat;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.db.model.v2.Vypuc;
import cz.kpsys.kpwin2.services.VerbisBoxService;
import cz.kpsys.marc.SessionData;
import cz.kpsys.service.Utils;
import cz.kpsys.service.cache.RecordIdCache;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SmazRezeExecutor
extends GenericExecutor {
    private static final int ERR5_NELZE_ZRUSIT_VE_VERBISBOXU = 5;
    private static final int ERR4_NELZE_MAZAT_VYPUJCKY = 4;
    private static final int ERR3_NELZE_MAZAT_MVS = 3;
    private static final int ERR2_NELZE_MAZAT_PRIPRAVENE = 2;
    private static final int ERR1_NEEXISTUJE_ZAZNAM_DLE_VYPUC = 1;
    private static final Logger logger = LoggerFactory.getLogger(SmazRezeExecutor.class);
    private final SmazRezeInput input;

    public SmazRezeExecutor(DbCore2 core2, SmazRezeInput input) {
        this.core2 = core2;
        this.input = input;
    }

    public static SmazRezeInput parseSmazRezeInput(Document doc, SessionData sessionData) throws AppServerStatus {
        Element rootNode = doc.getRootElement();
        SmazRezeInput smazRezeInput = new SmazRezeInput();
        smazRezeInput.setIdVypuc((long)Integer.parseInt(SmazRezeExecutor.parseTag((Document)doc, (String)"//collection/smaz_reze/ID_VYPUC", (String)"0")));
        smazRezeInput.setFkUzivAkce(sessionData.getUcode());
        if (smazRezeInput.getIdVypuc() == 0L) {
            throw new AppServerStatus("chybny vstup, ID_VYPUC==0", 666);
        }
        smazRezeInput.setPujcovna(Short.parseShort(SmazRezeExecutor.parseTag((Document)doc, (String)"//collection/pujcovna", (String)"0")));
        smazRezeInput.setSmazMVS(SmazRezeExecutor.tagHasTrueValue((String)SmazRezeExecutor.parseTag((Document)doc, (String)"//collection/smaz_reze/SMAZ_MVS", (String)"NE")));
        smazRezeInput.setSmazPripravene(SmazRezeExecutor.tagHasTrueValue((String)SmazRezeExecutor.parseTag((Document)doc, (String)"//collection/smaz_reze/SMAZ_PRIPRAVENE", (String)"NE")));
        smazRezeInput.setSmazNevyrizeneObj(SmazRezeExecutor.tagHasTrueValue((String)SmazRezeExecutor.parseTag((Document)doc, (String)"//collection/smaz_reze/SMAZ_NEVYRIZENE_OBJ", (String)"NE")));
        return smazRezeInput;
    }

    public SmazRezeOutput smazReze() throws SQLException, AppServerStatus {
        SmazRezeOutput output = new SmazRezeOutput();
        this.qr = this.core2.obtainQueryRunnerOpened();
        Vypuc vypuc = DbCore2Utils.nactiVypuc((long)this.input.getIdVypuc(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
        if (vypuc == null) {
            throw new AppServerStatus("neexistuje z\u00e1znam dle ID_VYPUC=" + this.input.getIdVypuc(), 1);
        }
        HashSet<Short> povoleneCisReze = new HashSet<Short>();
        if (this.input.smazNevyrizeneObj) {
            povoleneCisReze.add((short)53);
        }
        if (this.input.smazPripravene) {
            povoleneCisReze.add((short)53);
            povoleneCisReze.add((short)51);
            povoleneCisReze.add((short)54);
            povoleneCisReze.add((short)52);
        }
        if (vypuc.getCIS_REZE() >= 51 && !povoleneCisReze.contains(vypuc.getCIS_REZE())) {
            throw new AppServerStatus("nelze mazat p\u0159ipraven\u00e9 rezervace / objednavky", 2);
        }
        if (vypuc.getCIS_REZE() == 0) {
            throw new AppServerStatus("nelze mazat vypuj\u010dky", 4);
        }
        if (!this.input.smazMVS && vypuc.getCIS_REZE() == 55) {
            throw new AppServerStatus("nelze mazat MVS", 3);
        }
        String shipmentItemId = vypuc.getSHIPMENT_ITEM_ID();
        if (StringUtils.isNotBlank((CharSequence)shipmentItemId)) {
            try {
                logger.info("mazu shipmentItemId " + shipmentItemId);
                VerbisBoxService.smazShipmentItemId((int)vypuc.getFK_PUJC(), (int)this.input.getFkUzivAkce(), (UUID)UUID.fromString(shipmentItemId), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
            }
            catch (Exception e) {
                logger.error("selhani volani verbisbox cancelItem", (Throwable)e);
                throw new AppServerStatus("Nastal problem s rusenim polozky zasilky ve verbisboxu: " + e.getMessage(), 5, (Throwable)e);
            }
        }
        this.qr.update("UPDATE VYPUC2 SET DAT_VR=" + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + " WHERE ID_VYPUC=?", (Object)this.input.idVypuc);
        this.prepisUdajeZRezervace(output, vypuc);
        Vypuc vypucPrvniRezervace = this.sklepejRezervaceExemplar(vypuc.getFK_EX());
        if (vypucPrvniRezervace == null) {
            vypucPrvniRezervace = this.sklepejRezervaceTitul(RecordIdCache.recId2fkZaz((String)vypuc.getRECORD_ID()));
        }
        if (vypucPrvniRezervace != null && output.rezeCis > 50) {
            try {
                if (vypuc.getFK_EX() != null) {
                    this.posunRezervaciNaNeodeslanou(output, vypucPrvniRezervace, vypuc.getFK_EX().longValue(), vypuc.getFK_PUJC(), this.input.getFkUzivAkce());
                }
            }
            catch (AppServerStatus ase) {
                logger.warn("nepodarilo se presunout predrezervaci na neodeslanou rezervaci", (Throwable)ase);
            }
        }
        return output;
    }

    private void posunRezervaciNaNeodeslanou(SmazRezeOutput output, Vypuc vypucPrvniRezervace, long idEx, short fk_pujc, int fkUziv) throws SQLException, AppServerStatus {
        VracInput vracInput = new VracInput();
        vracInput.pujcovna = fk_pujc;
        vracInput.setFkUzivAkce(fkUziv);
        VracExecutor vracExecutor = new VracExecutor(this.core2, vracInput);
        Kat1_4 kat1_4 = this.core2.nactiKat1_4(vypucPrvniRezervace.getRECORD_ID());
        Kat1_5 kat1_5 = this.core2.nactiKat1_5(idEx);
        vracExecutor.kat1_4 = kat1_4;
        vracExecutor.kat1_5 = kat1_5;
        DefVypKat vypKat = (DefVypKat)((Map)DbCache2NG.vypKatMap().get()).get(kat1_5.getFK_VYPKAT());
        VracOutput najdiARezervujOutput = new VracOutput();
        RezervaceResult rezervaceResult = vracExecutor.najdiARezervuj(najdiARezervujOutput, false, vypKat);
        if (rezervaceResult != null) {
            output.fkVypuc = rezervaceResult.fkVypuc();
        }
    }

    protected void prepisUdajeZRezervace(SmazRezeOutput output, Vypuc vypuc) {
        output.rezeCis = vypuc.getCIS_REZE().shortValue();
        output.rezeCten = vypuc.getFK_UZIV_CTEN();
        output.rezeDat = vypuc.getDAT_VYP();
        output.rezeDob = vypuc.getDOB_VYP().shortValue();
        output.ok = true;
    }
}

