/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbConfig;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.HledExecutor;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.kpwin2.rest.Configuration;
import cz.kpsys.kpwin2.rest.ConfigurationUtils;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.service.SUtils;
import cz.kpsys.service.TaskQueueManager;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.DatabaseConfiguration;
import org.apache.commons.configuration2.EnvironmentConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    public static boolean indexingServiceEnabled = true;
    public static boolean centralIndexServiceEnabled = true;
    public static boolean internal_watchdog = false;
    public static boolean spoustetNaplanovaneUlohy = false;
    public static int sshPort = 0;
    public static String dbSchema = "SQLKPWIN";
    private static boolean generovatRejstriky = true;
    private final Map<String, String> URLServeruPodlePujcoven = new HashMap();
    public static boolean obalkyKnihService = true;
    public static boolean extZdrojePujc = true;
    public static THUMBNAIL_GENERATOR thumbnailGenerator = THUMBNAIL_GENERATOR.INTERNAL;
    public static boolean forcedUpdates = true;
    public static boolean luceneReadonly = false;
    public static boolean luceneDebug = false;
    public static String httpProxy = null;
    public boolean marc21strict = true;
    public boolean monitor = false;
    public boolean provisioning = false;
    public final org.apache.commons.configuration2.Configuration machineConfiguration;
    public final org.apache.commons.configuration2.Configuration config;
    public String externCacheDir = null;
    private boolean errorReporting = false;
    private String portString;
    private String reportingUrl = null;
    private String remote = null;
    private boolean stahovatAutority = true;
    final EnvironmentConfiguration envConfig = new EnvironmentConfiguration();
    public boolean masterMode = false;
    final File workspaceDir = new File("/workspace");
    private final File blobsDir = new File("/blobs");
    final File dockerEnv = new File("/.dockerenv");

    public Configuration(org.apache.commons.configuration2.Configuration machineConfig, org.apache.commons.configuration2.Configuration appserverConfig) {
        this.machineConfiguration = machineConfig;
        this.config = appserverConfig;
        this.loadAppserverConfig();
    }

    public static boolean isGenerovatRejstriky() {
        return generovatRejstriky;
    }

    public static String iniFile() {
        return System.getProperty("kpsys.appsini", "kpwin.ini");
    }

    public String getDataDir() {
        return this.config.getString("data_dir", System.getProperty("java.io.tmpdir"));
    }

    public String getPortString() {
        return this.portString;
    }

    public Map<String, String> getURLServeruPodlePujcoven() {
        return this.URLServeruPodlePujcoven;
    }

    public boolean loginKPWIN() {
        return this.config.getBoolean("login_kpwin", false);
    }

    public String dbDir() {
        return this.config.getString("db_dir", "/");
    }

    public boolean isDocker() {
        return this.dockerEnv.exists();
    }

    public String utilDir() {
        return this.config.getString("util_dir", SUtils.firstExistingDir((boolean)this.isDocker(), (String)"/util", (String[])new String[]{this.workspaceDir + "/util", "util"}));
    }

    public String workDir() {
        return this.config.getString("work_dir", SUtils.firstExistingDir((boolean)this.isDocker(), (String)"/work", (String[])new String[]{this.workspaceDir + "/work", "work"}));
    }

    public String indexDir() {
        return this.config.getString("index_dir", SUtils.firstExistingDir((boolean)this.isDocker(), (String)"/index", (String[])new String[]{this.workspaceDir + "/index", "index"}));
    }

    public String blobDir() {
        if (this.blobsDir.exists()) {
            return this.config.getString("blob_dir", "/blobs");
        }
        return this.config.getString("blob_dir", null);
    }

    public int hledLimit() {
        return this.config.getInt("hled_limit", Integer.MAX_VALUE);
    }

    public boolean updateDb() {
        return this.config.getBoolean("update_db", this.envConfig.getBoolean("APPSERVER_UPDATE_DB", true));
    }

    public String urlExternTul() {
        return this.config.getString("url_extern_tul", null);
    }

    private void initLuceneDir(String luceneDir) {
        File dir = new File(luceneDir);
        if (!dir.canRead()) {
            logger.info("lucene index adresar neexistuje, zakladam prazdny index");
            dir.mkdirs();
        }
        KPWINServiceApplication.luceneIndexDir = luceneDir;
    }

    public boolean isExceptionReportingEnabled() {
        return this.errorReporting;
    }

    public boolean isStahovatAutority() {
        return this.stahovatAutority;
    }

    public void setStahovatAutority(boolean stahovatAutority) {
        this.stahovatAutority = stahovatAutority;
    }

    private void loadAppserverConfig() {
        try {
            String stahovatAutorityString;
            String externSizeLimitString;
            String proxyConfigParam;
            String sshPortString;
            logger.info("nacitam hodnoty konfigurace");
            KPWINServiceApplication.dbConfig = new DbConfig();
            String dbVersion = this.config.getString("dbversion", "2");
            logger.info(" dbVersion=" + dbVersion);
            KPWINServiceApplication.dbConfig.dbVersion_$eq(Integer.parseInt(dbVersion));
            String jdbcUrl = this.config.getString("url", this.envConfig.getString("DATABASE_URL", null));
            if (jdbcUrl == null) {
                throw new AppServerStatus("neni zadano db url", 610);
            }
            logger.info(" jdbcUrl=" + jdbcUrl);
            KPWINServiceApplication.dbConfig.jdbcURL_$eq(jdbcUrl);
            int detectedDbEngine = jdbcUrl.startsWith("jdbc:firebirdsql:") ? 0 : (jdbcUrl.startsWith("jdbc:oracle:") ? 1 : (jdbcUrl.startsWith("jdbc:postgresql:") ? 2 : 0));
            int dbServer = Integer.parseInt(this.config.getString("dbserver", String.valueOf(detectedDbEngine)));
            logger.info(" dbServer=" + dbServer);
            if (dbServer == 0) {
                KPWINServiceApplication.dbConfig.dbEngine_$eq(DatabaseEngine.FIREBIRD);
            } else if (dbServer == 1) {
                KPWINServiceApplication.dbConfig.dbEngine_$eq(DatabaseEngine.ORACLE);
            } else if (dbServer == 2) {
                KPWINServiceApplication.dbConfig.dbEngine_$eq(DatabaseEngine.POSTGRESQL);
            }
            this.portString = this.config.getString("port", this.envConfig.getString("APPSERVER_PORT", "8182"));
            if (this.portString != null) {
                logger.info("port=" + this.portString + " => nastaveno do property server.port");
                System.setProperty("server.port", this.portString);
            }
            if ((sshPortString = this.config.getString("ssh_port", null)) != null) {
                logger.info("ssh_port=" + sshPortString);
                try {
                    int sshPortTemp = Integer.parseInt(sshPortString);
                    if (sshPortTemp < 0 || sshPortTemp > 65535) {
                        throw new IllegalArgumentException("hodnota portu je mimo platny rozsah " + sshPortTemp);
                    }
                    sshPort = sshPortTemp;
                }
                catch (Exception e) {
                    logger.error("parametr ssh_port neobsahuje platnou hodnotu", (Throwable)e);
                }
            }
            logger.info("blob_dir=" + this.blobDir());
            dbSchema = this.config.getString("db_schema", "SQLKPWIN");
            if (dbSchema != null) {
                logger.info("dbSchema=" + dbSchema);
            }
            this.externCacheDir = this.config.getString("ext_cache", "ext_cache");
            if (this.externCacheDir != null) {
                logger.info("ext_cache=" + this.externCacheDir);
            }
            if ("false".equals(this.config.getString("cache_tables"))) {
                logger.info("vypnuto cachovani tabulek pro recons a indexaci zaznamu");
                DbCache2.setNotInitCache((boolean)true);
            }
            if ("false".equals(this.config.getString("marc21strict", this.envConfig.getString("APPSERVER_MARC21_STRICT")))) {
                logger.info("vypnuto striktni lpeni na pravidlech marc21");
                this.marc21strict = false;
            }
            if ("true".equals(this.config.getString("internal_watchdog"))) {
                logger.info("zapnut interni watchdog na webservice");
                internal_watchdog = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(proxyConfigParam = this.config.getString("http_proxy", this.envConfig.getString("http_proxy"))))) {
                logger.info("pro http spojeni bude pouzita proxy: " + proxyConfigParam);
                httpProxy = proxyConfigParam;
            }
            if (StringUtils.isNotBlank((CharSequence)this.config.getString("master"))) {
                logger.warn("v kpwin.ini zjistena volba `master` ale je ignorovana, platny je INI klic CENTRAL_INDEX");
            }
            if ("true".equals(this.config.getString("monitor"))) {
                logger.info("zapnut monitoring");
                this.monitor = true;
            }
            this.remote = this.config.getString("remote", this.envConfig.getString("APPSERVER_REMOTE"));
            if (StringUtils.isNotBlank((CharSequence)this.remote)) {
                logger.info("poznamenavam remote " + this.remote);
            }
            if ("false".equals(this.config.getString("indexing_service", this.envConfig.getString("APPSERVER_INDEXING_ENABLED", "true")))) {
                indexingServiceEnabled = false;
                logger.info("indexacni sluzba vypnuta");
                TaskQueueManager.disableService();
            }
            if ("false".equals(this.config.getString("central_index_service", this.envConfig.getString("APPSERVER_CENTRAL_INDEX_SERVICE_ENABLED", "true")))) {
                centralIndexServiceEnabled = false;
                logger.info("sluzba zpracovani centralniho indexu vypnuta");
            }
            if ("false".equals(this.config.getString("obalkyknih_service", this.envConfig.getString("APPSERVER_OBALKYKNIH_ENABLED", "true")))) {
                obalkyKnihService = false;
                logger.info("sluzba obalkyknih.cz vypnuta");
            }
            if ("false".equals(this.config.getString("forced_updates", this.envConfig.getString("APPSERVER_FORCED_UPDATES_ENABLED", "true")))) {
                forcedUpdates = false;
                logger.info("vynucene aktualizace AS vypnute");
            }
            if ("false".equals(this.config.getString("ext_zdroje_pujc"))) {
                extZdrojePujc = false;
                logger.info("realne pujcovani z externich zdroju vypnuto");
            }
            if ("false".equals(this.config.getString("generovat_rejstriky"))) {
                logger.info("generovani rejstriku (kat1_3) vypnuto");
                generovatRejstriky = false;
            }
            if (GenericExecutor.tagHasTrueValue((String)this.config.getString("lucene_readonly"))) {
                logger.info("lucene v rezimu READONLY");
                luceneReadonly = true;
            }
            if (GenericExecutor.tagHasTrueValue((String)this.config.getString("lucene_debug"))) {
                logger.info("lucene debug hlasky zapnuty");
                luceneDebug = true;
            }
            if (!"false".equals(this.config.getString("naplanovane_ulohy", this.envConfig.getString("APPSERVER_SCHEDULED_TASKS_ENABLED", "true")))) {
                spoustetNaplanovaneUlohy = true;
            } else {
                logger.info("spousteni naplanovanych uloh vypnuto");
                spoustetNaplanovaneUlohy = false;
            }
            if ("true".equals(this.config.getString("error_reporting"))) {
                this.errorReporting = true;
                this.reportingUrl = this.config.getString("error_reporting_url", null);
                if (this.reportingUrl == null) {
                    logger.warn("chybi URL serveru pro posilani error logu (error_reporting_url), vzdalene hlaseni chyb vypnuto");
                } else {
                    logger.info("zapnuto vzdalene hlaseni chyb");
                }
            }
            if ("false".equals(this.config.getString("provisioning_service"))) {
                this.provisioning = false;
                logger.info("provisioning zakazan");
            } else {
                logger.info("provisioning povolen");
            }
            String luceneDir = this.config.getString("index_dir", "index");
            if (luceneDir == null) {
                logger.warn("lucene index vypnut, nezadan adresar s indexem (index_dir)");
            } else {
                logger.info(" index_dir=" + luceneDir);
                this.initLuceneDir(luceneDir);
            }
            String thumbnailGeneratorString = this.config.getString("thumbnail_generator", "internal");
            thumbnailGenerator = "internal".equals(thumbnailGeneratorString.toLowerCase()) ? THUMBNAIL_GENERATOR.INTERNAL : ("external".equals(thumbnailGeneratorString.toLowerCase()) ? THUMBNAIL_GENERATOR.EXTERNAL : ("off".equals(thumbnailGeneratorString.toLowerCase()) ? THUMBNAIL_GENERATOR.OFF : THUMBNAIL_GENERATOR.INTERNAL));
            logger.info(" thumbnail_generator=" + thumbnailGenerator);
            this.initLuceneDir(luceneDir);
            String externDir = this.config.getString("extern_dir", null);
            if (StringUtils.isNotBlank((CharSequence)externDir)) {
                logger.info(" extern_dir=" + externDir);
                KPWINServiceApplication.externDir = externDir;
            }
            if (StringUtils.isNotBlank((CharSequence)(externSizeLimitString = this.config.getString("extern_size_limit", null)))) {
                try {
                    KPWINServiceApplication.externSizeLimit = Integer.parseInt(externSizeLimitString) * 1024;
                    logger.info(" extern_size_limit=" + KPWINServiceApplication.externSizeLimit + " # (v bajtech)");
                }
                catch (NumberFormatException nfe) {
                    logger.error("neplatna velikost pro limit souboru k zapsani do externiho uloziste");
                }
            }
            if ("true".equalsIgnoreCase(stahovatAutorityString = this.config.getString("stahovat_autority", null))) {
                this.stahovatAutority = true;
            } else if (stahovatAutorityString != null) {
                this.stahovatAutority = false;
            }
            Iterator it = this.config.getKeys("host");
            while (it.hasNext()) {
                String key = (String)it.next();
                this.URLServeruPodlePujcoven.put(key, this.config.getString(key));
            }
            boolean logSQL = this.config.getBoolean("log_sql", false);
            logger.info(" logSql=" + logSQL);
            KPWINServiceApplication.dbConfig.logSQL_$eq(logSQL);
            int pocetSoubeznychHledani = this.config.getInt("pocet_soubeznych_hledani", 2);
            HledExecutor.nastavSemafor((int)pocetSoubeznychHledani);
        }
        catch (Exception e) {
            System.err.println("problem pri nacitani konfigurace " + e.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)e));
            logger.error("selhani", (Throwable)e);
            System.exit(2);
        }
    }

    public int parseBuildNumber(String versionBanner) {
        try {
            String number = versionBanner.substring(7);
            return Integer.parseInt(number.substring(0, number.indexOf(32)));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void startupDb() throws SQLException {
        KPWINServiceApplication.dbConfig.initDbCore();
        logger.info("nacitam konfiguraci z AS_INI");
        DatabaseConfiguration dbConfig = ConfigurationUtils.createDatabaseConfiguration((DataSource)ProxoolUtil.dataSource(), (String)"VIEW_INI_AS", (String)"KLIC", (String)"HODNOTA");
        ((CompositeConfiguration)this.config).addConfiguration((org.apache.commons.configuration2.Configuration)dbConfig);
    }

    public String getTemporaryDir() {
        String tmpDir = this.config.getString("tmp_dir");
        if (StringUtils.isBlank((CharSequence)tmpDir)) {
            tmpDir = System.getProperty("java.io.tmpdir");
        }
        return tmpDir;
    }

    public String getRemote() {
        return this.remote;
    }
}

