/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.executors;

import cz.kpsys.db.DbCore2;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.NumberHandler;
import cz.kpsys.db.model.v2.Platby;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatbyExecutor {
    final Logger logger = LoggerFactory.getLogger(PlatbyExecutor.class);
    private DbCore2 core2;
    private int idCten;
    private QueryRunner qr;

    public PlatbyExecutor(DbCore2 core2, int idCten) {
        this.core2 = core2;
        this.idCten = idCten;
        this.qr = core2.obtainQueryRunnerOpened();
    }

    public Map<String, List<Platby>> seznamNeuhrazenychPlateb(Integer fkPopl) throws SQLException {
        String key;
        boolean vklad;
        boolean rozlisovatPujcovny = false;
        List vsechnyPlatby = fkPopl == null ? (List)this.qr.query("SELECT * FROM PLATBY WHERE FK_UZIV_VLASTNIK=?  AND VRACENO IS NULL ORDER BY DATUM", (ResultSetHandler)new KPSYSBeanListHandler(Platby.class), new Object[]{this.idCten}) : (List)this.qr.query("SELECT * FROM PLATBY WHERE FK_UZIV_VLASTNIK=?  AND VRACENO IS NULL AND FK_POPL=? ORDER BY DATUM", (ResultSetHandler)new KPSYSBeanListHandler(Platby.class), new Object[]{this.idCten, fkPopl});
        HashMap prubezneSoucty = new HashMap();
        HashMap<String, List<Platby>> nezaplacenePlatby = new HashMap<String, List<Platby>>();
        for (Platby platba : vsechnyPlatby) {
            vklad = this.vetsiNezNula(platba.getCASTKA());
            if (!vklad) continue;
            key = rozlisovatPujcovny ? platba.getFK_POPL() + "#" + platba.getSERVIS() : "" + platba.getFK_POPL();
            this.prictiCastku(prubezneSoucty, key, platba.getCASTKA());
        }
        for (Platby platba : vsechnyPlatby) {
            vklad = this.vetsiNezNula(platba.getCASTKA());
            if (vklad) continue;
            key = rozlisovatPujcovny ? platba.getFK_POPL() + "#" + platba.getFK_PUJC() : "" + platba.getFK_POPL();
            this.prictiCastku(prubezneSoucty, key, platba.getCASTKA());
            if (((BigDecimal)prubezneSoucty.get(key)).compareTo(BigDecimal.ZERO) >= 0) continue;
            if (!nezaplacenePlatby.containsKey(key)) {
                nezaplacenePlatby.put(key, new LinkedList());
            }
            ((List)nezaplacenePlatby.get(key)).add(platba);
        }
        this.debugPrint(nezaplacenePlatby);
        return nezaplacenePlatby;
    }

    private void debugPrint(Map<String, List<Platby>> nezaplacenePlatby) {
        this.logger.info("nezaplacene platby: ");
        for (Platby platba : this.flatten(nezaplacenePlatby)) {
            this.logger.info(platba.toString());
        }
    }

    private boolean vetsiNezNula(BigDecimal castka) {
        return castka.compareTo(BigDecimal.ZERO) > 0;
    }

    private void prictiCastku(Map<String, BigDecimal> map, String key, BigDecimal amount) {
        if (map.containsKey(key)) {
            map.put(key, map.get(key).add(amount));
        } else {
            map.put(key, amount);
        }
    }

    public boolean platbaPatriCtenari(long idPlatby) throws SQLException {
        int pocet = ((Number)this.qr.query("SELECT COUNT(*) FROM PLATBY WHERE ID_PLATBY=? AND FK_UZIV_VLASTNIK=?", (ResultSetHandler)new NumberHandler((Number)0), new Object[]{idPlatby, this.idCten})).intValue();
        return pocet > 0;
    }

    public List<Platby> flatten(Map<String, List<Platby>> map) {
        ArrayList<Platby> seznam = new ArrayList<Platby>();
        for (List<Platby> platby : map.values()) {
            seznam.addAll(platby);
        }
        return seznam;
    }
}

