/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.startup;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCore2;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.rest.action.API_THREAD_ID;
import cz.kpsys.kpwin2.rest.action.StartupScala;
import cz.kpsys.kpwin2.rest.startup.LicenceResponse;
import cz.kpsys.kpwin2.rest.startup.ModuleResponse;
import cz.kpsys.kpwin2.rest.startup.StartupCollectionRequest;
import cz.kpsys.kpwin2.rest.startup.StartupResponse;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.licence.Module;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * Exception performing whole class analysis ignored.
 */
@RequestMapping(value={"/startup"})
@ResponseBody
public class StartupApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartupApiController.class);
    @NonNull
    private final Provider<Licence> licenceProvider;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;

    @GetMapping
    public StartupResponse getStartup(@RequestParam(value="department", required=false) Integer departmentId) {
        Department department = Optional.ofNullable(departmentId).map(arg_0 -> ((ByIdLoadable)this.departmentLoader).getById(arg_0)).orElseGet((Supplier<Department>)this.rootDepartmentProvider);
        return this.postHandler(department);
    }

    @PostMapping
    public StartupResponse postStartup(@RequestBody StartupCollectionRequest request) {
        Department department = Optional.ofNullable(request.getDepartment()).map(arg_0 -> ((ByIdLoadable)this.departmentLoader).getById(arg_0)).orElseGet((Supplier<Department>)this.rootDepartmentProvider);
        return this.postHandler(department);
    }

    private StartupResponse postHandler(Department department) throws AppServerStatus {
        Thread.currentThread().setName(API_THREAD_ID.STARTUP.name());
        Licence licence = (Licence)this.licenceProvider.get();
        String dbUrl = StartupApiController.convertToNativeURL((String)KPWINServiceApplication.dbConfig.jdbcURL());
        String remote = KPWINServiceApplication.getConfiguration().getRemote();
        String remoteUrl = null;
        if (StringUtils.isNotBlank((CharSequence)remote)) {
            remoteUrl = this.poskladejURL(remote, dbUrl);
        }
        String URLDlePujcovny = this.najdiURLDlePujcovny(((Integer)department.getId()).intValue());
        dbUrl = this.poskladejURL(URLDlePujcovny, dbUrl);
        DatabaseEngine dbEngine = KPWINServiceApplication.dbConfig.dbEngine();
        String dbEngineVersion = DbCore2.dbEngineVersion((DatabaseEngine)dbEngine);
        return new StartupResponse(dbUrl, remoteUrl, dbEngine.name().toUpperCase(Locale.ROOT), dbEngineVersion, KPWINServiceApplication.versionString, Integer.valueOf(StartupScala.requiredVerbisVersion()), licence.getLicenceVersion().getValue(), new LicenceResponse(licence.getLicenceVersion().getValue(), licence.getEditorLimit(), licence.getDocumentLimit(), licence.getMaintenanceExpirationDate(), licence.isTesting(), (Collection)Arrays.stream(Module.values()).filter(arg_0 -> ((Licence)licence).isEnabled(arg_0)).map(Module::getName).map(ModuleResponse::new).collect(Collectors.toList())));
    }

    private String najdiURLDlePujcovny(int pujcovna) {
        String url = (String)KPWINServiceApplication.getConfiguration().getURLServeruPodlePujcoven().get("host." + pujcovna);
        if (StringUtils.isBlank((CharSequence)url)) {
            Short nadrazenaPujcovna = DbCache.nejblizsiNadrazenaPujcovna((Short)((short)pujcovna));
            if (nadrazenaPujcovna != null) {
                return this.najdiURLDlePujcovny(nadrazenaPujcovna.intValue());
            }
            return null;
        }
        return url;
    }

    public static String convertToNativeURL(String jdbcURL) {
        String hostPart;
        String[] castiUrl = jdbcURL.split(":");
        if (jdbcURL.contains("oracle:thin")) {
            return jdbcURL;
        }
        if (castiUrl.length == 3) {
            castiUrl = StartupApiController.osetriVariantuBezPortu((String[])castiUrl);
        }
        String result = (hostPart = castiUrl[2]).startsWith("//") ? hostPart.replace("//", "") + "/" + castiUrl[3].replace("/", ":").replace("?lc_ctype=UTF8", "") : castiUrl[2].replace(":", "/") + ":" + castiUrl[3].replace("?lc_ctype=UTF8", "");
        return result;
    }

    private static String[] osetriVariantuBezPortu(String[] castiUrl) {
        String[] ret = new String[4];
        ret[0] = castiUrl[0];
        ret[1] = castiUrl[1];
        String val = castiUrl[2];
        int index = val.indexOf("/", 2);
        ret[2] = val.substring(2, index);
        ret[3] = val.substring(index + 1);
        return ret;
    }

    public String poskladejURL(String alternativniIP, String dbUrl) {
        String[] parts;
        if (StringUtils.isNotBlank((CharSequence)alternativniIP)) {
            parts = ((String)dbUrl).split(":");
            if (((String)dbUrl).contains("oracle:thin")) {
                String[] ipPortAlternativni = alternativniIP.split(":");
                if (ipPortAlternativni.length == 2) {
                    parts[4] = ipPortAlternativni[1];
                }
            } else {
                dbUrl = alternativniIP + ":" + parts[1];
            }
        }
        if (((String)dbUrl).contains("oracle:thin")) {
            parts = ((String)dbUrl).split(":");
            dbUrl = parts[3].replace("@", "") + ":" + parts[4] + "/" + parts[5];
        }
        return dbUrl;
    }

    @ConstructorProperties(value={"licenceProvider", "departmentLoader", "rootDepartmentProvider"})
    @Generated
    public StartupApiController(@NonNull Provider<Licence> licenceProvider, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull Provider<Department> rootDepartmentProvider) {
        Objects.requireNonNull(licenceProvider, "licenceProvider is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        this.licenceProvider = licenceProvider;
        this.departmentLoader = departmentLoader;
        this.rootDepartmentProvider = rootDepartmentProvider;
    }
}

