/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.services;

import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class BatchProcessor<E> {
    private List<E> col;
    private int limit;

    public BatchProcessor(List<E> col, int limit) {
        this.col = col;
        this.limit = limit;
    }

    public void process() {
        int size = this.col.size();
        int count = size / this.limit;
        for (int i = 0; i < count; ++i) {
            this.processSegment(this.col.subList(i * this.limit, (i + 1) * this.limit));
        }
        if (size > count * this.limit) {
            this.processSegment(this.col.subList(count * this.limit, size));
        }
    }

    public abstract void processSegment(List<E> var1);

    protected String repeatQuestionmark(int size) {
        if (size == 1) {
            return "?";
        }
        return StringUtils.repeat((String)"?, ", (int)(size - 1)) + "?";
    }
}

