/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.services;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.GenericExecutorScala;
import cz.kpsys.portaro.commons.io.FileStreamReader;
import cz.kpsys.portaro.commons.io.RemoteFileDataStreamer;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.util.ObjectUtil;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.service.OkHttpClientFactory;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class OkHttpWebFileDataStreamer
implements RemoteFileDataStreamer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OkHttpWebFileDataStreamer.class);
    private final @NonNull Provider<@NullableNotBlank String> nullableSiglaProvider;

    public void streamData(@NonNull Long id, @NonNull String url, @NonNull FileStreamReader reader, @Nullable String forcedFilename) {
        Objects.requireNonNull(id, "id is marked non-null but is null");
        Objects.requireNonNull(url, "url is marked non-null but is null");
        Objects.requireNonNull(reader, "reader is marked non-null but is null");
        try {
            Response response;
            OkHttpClient client = OkHttpClientFactory.client();
            Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Connection", "close").addHeader("Referer", "http://portaro.eu").addHeader("Referrer", "http://portaro.eu").addHeader("Accept-Encoding", "*").addHeader("X-Library-Client", GenericExecutorScala.HTTP_CLIENT_VERBIS_HEADER());
            String sigla = (String)this.nullableSiglaProvider.get();
            if (sigla != null) {
                requestBuilder.addHeader("X-Library-Code", sigla);
            }
            if ((response = client.newCall(requestBuilder.build()).execute()).code() != 200) {
                throw new IOException("odpoved nebyla 200/OK, ale %s - odpoved: %s".formatted(response.code(), response.body().string()));
            }
            String filename = (String)ObjectUtil.firstNotNull((Object[])new String[]{forcedFilename, "unknown-file-%s.dat".formatted(id)});
            InputStream responseInputStream = response.body().byteStream();
            long responseContentLength = response.body().contentLength();
            reader.read(filename, Long.valueOf(responseContentLength), responseInputStream);
        }
        catch (IOException ioex) {
            log.error("stahovani BLOB URL " + url, (Throwable)ioex);
            throw new AppServerStatus("nepodarilo se stahnout soubor z odkazu URL " + url, 4).addReturnValue("URL", url).addReturnValue("CHYBA", ioex.getMessage());
        }
    }

    @ConstructorProperties(value={"nullableSiglaProvider"})
    @Generated
    public OkHttpWebFileDataStreamer(@NonNull Provider<@NullableNotBlank String> nullableSiglaProvider) {
        Objects.requireNonNull(nullableSiglaProvider, "nullableSiglaProvider is marked non-null but is null");
        this.nullableSiglaProvider = nullableSiglaProvider;
    }
}

