/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.tasks;

import cz.kpsys.common.AutomatLogger;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.NumberHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.SingleConnectionDataSource;
import cz.kpsys.db.model.v2.DefAutomat;
import cz.kpsys.db.model.v2.LogAutomat;
import cz.kpsys.kpwin2.tasks.ScheduledTask;
import cz.kpsys.service.DateConversions;
import cz.kpsys.service.TaskScheduler;
import cz.kpsys.service.Utils;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppServerTimerTask {
    private static final int YEARLY = 4;
    private static final int MONTHLY = 3;
    private static final int WEEKLY = 2;
    private static final int EVERY_DAY = 1;
    private static final int MAX_30_LET = 10950;
    private static final Logger logger = LoggerFactory.getLogger(AppServerTimerTask.class);
    private static final int LO_VYSLEDEK_FS = 512;
    protected final DefAutomat defAutomat;

    public AppServerTimerTask(DefAutomat defAutomat) {
        this.defAutomat = defAutomat;
    }

    public static Map<String, String> parsujParametry(String parametry) {
        HashMap<String, String> mapa = new HashMap<String, String>();
        if (parametry != null) {
            StringTokenizer st = new StringTokenizer(parametry, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains("=")) {
                    int index = token.indexOf("=");
                    String key = token.substring(0, index).toUpperCase();
                    String value = token.substring(index + 1);
                    mapa.put(key, value);
                    continue;
                }
                mapa.put(token, "");
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNoScheduleNextRun(Semaphore semaphore) {
        Connection conn = null;
        AutomatLogger automatLogger = new AutomatLogger();
        try {
            conn = ProxoolUtil.obtainConnectionBackground();
            this.zapisCasSpusteni(conn);
            conn.commit();
            DbCore2 core2 = new DbCore2(conn);
            QueryRunnerOpened qr = core2.obtainQueryRunnerOpened();
            if (semaphore != null) {
                semaphore.release();
            }
            Thread.currentThread().setName("automat " + this.defAutomat.getID_AUTOMAT());
            this.doJob(conn, core2, (QueryRunner)qr, automatLogger);
            this.zapisUspech(conn, automatLogger);
        }
        catch (Exception e) {
            logger.error("uloha nedobehla v poradku " + this.defAutomat, (Throwable)e);
            automatLogger.log("selhani ulohy " + this.defAutomat, (Throwable)e);
            this.zapisStavUlohy("KO - " + e.toString(), conn, automatLogger);
            this.kontrolaChybovaniUlohy();
        }
        finally {
            if (conn != null) {
                try {
                    conn.commit();
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error("problem pri zavirani spojeni", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kontrolaChybovaniUlohy() {
        DbCore2 core2 = null;
        try {
            core2 = new DbCore2(ProxoolUtil.obtainConnection());
            QueryRunnerOpened qr = core2.obtainQueryRunnerOpened();
            List vysledkySpusteni = (List)qr.query("SELECT * FROM LOG_AUTOMAT WHERE FK_AUTOMAT=? AND AKCE=? ORDER BY DATCAS DESC", (ResultSetHandler)new KPSYSBeanListHandler(LogAutomat.class), new Object[]{this.defAutomat.getID_AUTOMAT(), 6});
            if (this.plneSelhani(5, vysledkySpusteni) && !this.plneSelhani(6, vysledkySpusteni)) {
                String message = "Uloha vykazuje nadmernou cetnost selhani, prosime zkontrolujte nastaveni parametru ulohy, pripadne kontaktujte podporu.";
                this.posliUpozornovaciEmail(this.defAutomat, "Uloha vykazuje nadmernou cetnost selhani, prosime zkontrolujte nastaveni parametru ulohy, pripadne kontaktujte podporu.", core2.getConn());
            } else if (this.plneSelhani(10, vysledkySpusteni)) {
                String message = "Uloha vykazovala nadmernou cetnost selhani a byla proto DEAKTIVOVANA.";
                this.posliUpozornovaciEmail(this.defAutomat, "Uloha vykazovala nadmernou cetnost selhani a byla proto DEAKTIVOVANA.", core2.getConn());
                core2.loginAsAS();
                qr.update("UPDATE DEF_AUTOMAT SET JE_AKTIVNI=0 WHERE ID_AUTOMAT=?", (Object)this.defAutomat.getID_AUTOMAT());
                DbCore2.naplanujAutomatickeUlohy();
            }
            core2.closeConnectionCommit();
        }
        catch (SQLException e) {
            logger.error("nepodarilo se proverit nadmernou chybovost ulohy");
        }
        finally {
            if (core2 != null) {
                core2.closeConnectionCommitSilently();
            }
        }
    }

    private boolean plneSelhani(int nPrvnichRadku, List<LogAutomat> vysledkySpusteni) {
        if (vysledkySpusteni.size() < nPrvnichRadku) {
            return false;
        }
        for (int i = 0; i < nPrvnichRadku; ++i) {
            String vysledek = vysledkySpusteni.get(i).getVYSLEDEK();
            if (!StringUtils.isNotBlank((CharSequence)vysledek) || vysledek.startsWith("KO - ")) continue;
            return false;
        }
        return true;
    }

    public void run() {
        this.runNoScheduleNextRun(null);
        this.scheduleNextRun(TaskScheduler.getThreadPool());
    }

    private void zapisStavUlohy(String message, Connection conn, AutomatLogger automatLogger) {
        try {
            QueryRunnerOpened qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
            String log = automatLogger == null ? null : automatLogger.toString();
            DbCore2.relogUserCommit((int)this.defAutomat.getFK_UZIV_ZAL(), (short)((Short)DbCache.rootPujcovna().get()), (Connection)conn, (DatabaseEngine)ProxoolUtil.engine());
            qr.update("UPDATE DEF_AUTOMAT SET DATCAS_SPUSTENI=" + Utils.todayNowString((int)2, (DatabaseEngine)ProxoolUtil.engine()) + ", POSL_VYSLEDEK=? WHERE ID_AUTOMAT=?", new Object[]{StringUtils.left((String)message, (int)512), this.defAutomat.getID_AUTOMAT()});
            if (log != null) {
                logger.error("vysledek zpracovani ulohy " + this.defAutomat + "\n" + log);
                long idLogAutomat = ((Number)qr.query("SELECT MAX(ID_LOG_AUTOMAT) FROM LOG_AUTOMAT WHERE FK_AUTOMAT=?", (ResultSetHandler)new NumberHandler((Number)0), new Object[]{this.defAutomat.getID_AUTOMAT()})).longValue();
                if (idLogAutomat > 0L) {
                    qr.update("UPDATE LOG_AUTOMAT SET LOG=? WHERE ID_LOG_AUTOMAT=?", new Object[]{log, idLogAutomat});
                }
            }
            conn.commit();
            this.posliUpozornovaciEmail(this.defAutomat, message, conn);
        }
        catch (SQLException e) {
            logger.error("problem pri zapisu stavu ulohy " + message + " - " + this.toString(), (Throwable)e);
        }
    }

    private void posliUpozornovaciEmail(DefAutomat defAutomat, String message, Connection conn) {
        if ("KO".equals(message) || "OK".equals(message)) {
            return;
        }
    }

    private String prepareUlohaInfo(DefAutomat defAutomat) {
        if (defAutomat == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("typ ulohy: ").append(this.oznaceniTypuUlohy()).append("\n");
        sb.append("nazev ulohy: ").append(defAutomat.getNAZEV()).append("\n");
        sb.append("parametry ulohy: ").append(defAutomat.getPARAMETRY()).append("\n");
        sb.append("id ulohy: ").append(defAutomat.getID_AUTOMAT()).append("\n");
        return sb.toString();
    }

    private void zapisUspech(Connection conn, AutomatLogger automatLogger) {
        this.zapisStavUlohy("OK", conn, automatLogger);
    }

    public abstract void doJob(Connection var1, DbCore2 var2, QueryRunner var3, AutomatLogger var4) throws Exception;

    public abstract String oznaceniTypuUlohy();

    private void zapisCasSpusteni(Connection conn) {
        this.zapisStavUlohy("KO", conn, null);
    }

    public void scheduleNextRun(ScheduledExecutorService threadPool) {
        LocalDateTime now = LocalDateTime.now();
        if (this.defAutomat == null) {
            logger.error("nelze naplanovat ulohu, chybi potrebna data");
            return;
        }
        Timestamp casSpusteni = this.defAutomat.getCAS_SPUSTENI();
        short perioda = this.defAutomat.getFK_PERIODA();
        short denVPeriode = this.defAutomat.getDEN_V_PERIODE();
        if (perioda > 0) {
            if (now.isBefore(DateConversions.utilDate2localDateTime((Date)casSpusteni))) {
                this.naplanuj((Date)casSpusteni, threadPool);
            } else {
                LocalDateTime ldt = DateConversions.utilDate2localDateTime((Date)casSpusteni);
                if (perioda == 1) {
                    for (safeCounter = 0; ldt.isBefore(now) && safeCounter < 10950; ++safeCounter) {
                        ldt = ldt.plusDays(1L);
                    }
                    this.naplanuj(DateConversions.localDateTime2utilDate((LocalDateTime)ldt), threadPool);
                } else {
                    switch (perioda) {
                        case 2: {
                            ldt = ldt.with(TemporalAdjusters.next(DayOfWeek.of(denVPeriode)));
                            while (ldt.isBefore(now) && safeCounter < 1564) {
                                ldt = ldt.plusDays(7L);
                                ++safeCounter;
                            }
                            break;
                        }
                        case 3: {
                            ldt = ldt.withDayOfMonth(denVPeriode);
                            while (ldt.isBefore(now) && safeCounter < 365) {
                                ldt = ldt.plusMonths(1L);
                                ++safeCounter;
                            }
                            break;
                        }
                        case 4: {
                            ldt = ldt.withDayOfYear(denVPeriode);
                            while (ldt.isBefore(now) && safeCounter < 30) {
                                ldt = ldt.plusYears(1L);
                                ++safeCounter;
                            }
                            break;
                        }
                    }
                    this.naplanuj(DateConversions.localDateTime2utilDate((LocalDateTime)ldt), threadPool);
                }
            }
        } else if (perioda == 0 && now.isBefore(DateConversions.utilDate2localDateTime((Date)casSpusteni))) {
            this.naplanuj((Date)casSpusteni, threadPool);
        }
    }

    private void naplanuj(Date casSpusteni, ScheduledExecutorService threadPool) {
        long delay = casSpusteni.getTime() - Utils.now().getTime();
        if (delay < 0L) {
            throw new IllegalArgumentException("zadan cas spusteni ulohy, ktery je v minulosti " + casSpusteni);
        }
        ScheduledTask st = new ScheduledTask(this);
        threadPool.schedule((Runnable)st, delay, TimeUnit.MILLISECONDS);
        logger.info("naplanovano spusteni ulohy " + this.defAutomat.getID_AUTOMAT() + " na datum " + Utils.sdfSQLDateTime().format(casSpusteni) + " - " + this.toString());
    }

    public static String poskladejParametry(Map<String, String> mapaParametru) {
        ArrayList<CallSite> polozky = new ArrayList<CallSite>(mapaParametru.size());
        for (String klic : mapaParametru.keySet()) {
            polozky.add((CallSite)((Object)(klic.toUpperCase() + "=" + mapaParametru.get(klic))));
        }
        return StringUtils.join(polozky, (String)";");
    }

    public static void zapisInfoDoLogAuto(ScalaRunnerOpened qr, String zkratkaUlohyOK) {
        try {
            qr.update("INSERT INTO LOG_AUTO (ID, NAZEV, LAST_DATE) VALUES (?, ?, ?)", new Object[]{1, zkratkaUlohyOK, Utils.util2sqlDate((Date)Utils.today())});
        }
        catch (SQLException e) {
            logger.warn("nepodarilo se zapsat info o dokonceni ulohy typ " + zkratkaUlohyOK, (Throwable)e);
        }
    }

    public String toString() {
        return this.oznaceniTypuUlohy();
    }
}

