/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.vsb;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.ZjistiPokutyExecutor;
import cz.kpsys.db.model.ZjistiPokutyInput;
import cz.kpsys.db.model.ZjistiPokutyOutput;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.Platby;
import cz.kpsys.db.model.v2.Vypuc;
import cz.kpsys.kpwin2.rest.executors.PlatbyExecutor;
import cz.kpsys.kpwin2.vsb.FindPersonCommitments;
import cz.kpsys.kpwin2.vsb.FindPersonCommitmentsResponse;
import cz.kpsys.kpwin2.vsb.LoanBookInfo;
import cz.kpsys.kpwin2.vsb.PersonCommitmentsOutput;
import cz.kpsys.kpwin2.vsb.SoapKPSYSException;
import cz.kpsys.service.DateConversions;
import cz.kpsys.service.Utils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.RequestPayload;
import org.springframework.ws.server.endpoint.annotation.ResponsePayload;

@Endpoint
public class FindPersonCommitmentsImpl {
    static final Logger logger = LoggerFactory.getLogger(FindPersonCommitmentsImpl.class);

    @PayloadRoot(namespace="http://vsb.kpwin2.kpsys.cz/", localPart="findPersonCommitments")
    @ResponsePayload
    public FindPersonCommitmentsResponse findPersonCommitments(@RequestPayload FindPersonCommitments findPersonCommitments) throws SoapKPSYSException {
        FindPersonCommitmentsResponse response = new FindPersonCommitmentsResponse();
        DbCore2 core2 = new DbCore2();
        String netId = findPersonCommitments.getArg0();
        logger.warn("findPersonCommitments: " + netId);
        try {
            core2.setConnection(ProxoolUtil.obtainConnection());
            QueryRunnerOpened qr = core2.obtainQueryRunnerOpened();
            Ctenari ctenar = (Ctenari)qr.query("SELECT * FROM CTENARI WHERE FK_UZIV=(SELECT FK_UZIV FROM OSOBY WHERE LOWER(NET_ID)=?)", (ResultSetHandler)BeanHandlers.ctenariHandler(), new Object[]{netId});
            if (ctenar != null) {
                PersonCommitmentsOutput output = new PersonCommitmentsOutput();
                output.dluh = this.spoctiDluhCtenare(core2, ctenar, null);
                output.pokuty = this.spoctiPokutyCtenare(core2, ctenar);
                PersonCommitmentsOutput.Vypujcky vypujcky = new PersonCommitmentsOutput.Vypujcky();
                vypujcky.vypujcka.addAll(this.seznamPujcenychKnih(core2, (QueryRunner)qr, ctenar));
                output.setVypujcky(vypujcky);
                core2.closeConnectionCommit();
                logger.warn("findPersonCommitments output: " + output);
                response.setReturn(output);
                return response;
            }
            core2.closeConnectionCommit();
            throw new SoapKPSYSException("1", "predane NETID se nepodarilo nalezt v databazi");
        }
        catch (SQLException se) {
            logger.error("P: behem WS metody findPersonPayments", (Throwable)se);
            core2.closeConnectionRollback();
            throw new SoapKPSYSException("2", "doslo k blize neurcene chybe, vice v logu");
        }
    }

    private Collection<? extends LoanBookInfo> seznamPujcenychKnih(DbCore2 core2, QueryRunner qr, Ctenari ctenar) throws SQLException {
        ArrayList<LoanBookInfo> seznam = new ArrayList<LoanBookInfo>();
        List vypujcky = (List)qr.query("SELECT * FROM VYPUC WHERE FK_UZIV_CTEN=? AND CIS_REZE=0 ORDER BY DAT_VYP", (ResultSetHandler)new KPSYSBeanListHandler(Vypuc.class), new Object[]{ctenar.getFK_UZIV()});
        for (Vypuc vypuc : vypujcky) {
            LoanBookInfo info = new LoanBookInfo();
            Kat1_4 kat1_4 = core2.nactiKat1_4(vypuc.getRECORD_ID());
            info.setNazevPublikace(kat1_4.getNAZEV());
            info.setDocId(Long.toString(kat1_4.getID_ZAZ()));
            info.setDatumVypujcky(DateConversions.utilDate2xmlGregorianCalendar((Date)vypuc.getDAT_VYP()));
            Date datumVraceni = GenericExecutor.addDays((Date)vypuc.getDAT_PROL(), (int)vypuc.getDOB_VYP().shortValue());
            info.setDatumVraceni(DateConversions.utilDate2xmlGregorianCalendar((Date)datumVraceni));
            seznam.add(info);
        }
        return seznam;
    }

    private BigDecimal spoctiPokutyCtenare(DbCore2 core2, Ctenari ctenar) {
        ZjistiPokutyOutput output;
        ZjistiPokutyInput input = new ZjistiPokutyInput();
        input.datumGen = Utils.today();
        input.idCten = ctenar.getFK_UZIV();
        ZjistiPokutyExecutor pokutyExecutor = new ZjistiPokutyExecutor(core2, input);
        try {
            output = pokutyExecutor.zjistiPokuty();
        }
        catch (AppServerStatus | SQLException e) {
            return BigDecimal.ZERO.subtract(BigDecimal.ONE);
        }
        return output.celkovaCastka;
    }

    private BigDecimal spoctiDluhCtenare(DbCore2 core2, Ctenari ctenar, Integer fkPopl) throws SQLException {
        PlatbyExecutor platbyExecutor = new PlatbyExecutor(core2, ctenar.getFK_UZIV());
        Map seznamPlateb = platbyExecutor.seznamNeuhrazenychPlateb(fkPopl);
        BigDecimal soucet = BigDecimal.ZERO;
        for (Platby platba : platbyExecutor.flatten(seznamPlateb)) {
            soucet = soucet.add(platba.getCASTKA());
        }
        return BigDecimal.ZERO.subtract(soucet);
    }
}

