/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwinsql.z3950.model;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZServerDatabaseConfig {
    private static final Logger logger = LoggerFactory.getLogger(ZServerDatabaseConfig.class);
    String databaseName;
    String encoding;
    Map<String, int[]> semanticMapping = new HashMap();
    private final BitSet enabledStatuses = new BitSet();

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public Map<String, int[]> getSemanticMapping() {
        return this.semanticMapping;
    }

    public ZServerDatabaseConfig() {
        this.semanticMapping.put("12", new int[]{1, 35, -9000});
        this.semanticMapping.put("1060", new int[]{-1060});
        this.semanticMapping.put("1062", new int[]{-1062});
        this.semanticMapping.put("1063", new int[]{-1063});
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZServerDatabaseConfig other = (ZServerDatabaseConfig)obj;
        return !(this.databaseName == null ? other.databaseName != null : !this.databaseName.equals(other.databaseName));
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void parseStatus(String s) {
        this.enabledStatuses.clear();
        s = s.replace(" ", "");
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf("-");
            try {
                if (index == -1) {
                    int n = Integer.parseInt(token);
                    this.enabledStatuses.set(n);
                    continue;
                }
                int n1 = Integer.parseInt(token.substring(0, index));
                int n2 = Integer.parseInt(token.substring(index + 1));
                for (int i = n1; i <= n2; ++i) {
                    this.enabledStatuses.set(i);
                }
            }
            catch (NumberFormatException nfe) {
                logger.warn("problem pri parsovani status v INI: " + s, (Throwable)nfe);
            }
        }
    }

    public BitSet getEnabledStatuses() {
        return this.enabledStatuses;
    }
}

