/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwinsql.z3950.server;

import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.RecordReconstructor2;
import cz.kpsys.kpwinsql.z3950.model.ConstraintModel;
import cz.kpsys.kpwinsql.z3950.model.OutputFormatsEnum;
import cz.kpsys.kpwinsql.z3950.model.SearchResult;
import cz.kpsys.kpwinsql.z3950.model.ZServerConfig;
import cz.kpsys.kpwinsql.z3950.model.ZServerDatabaseConfig;
import cz.kpsys.kpwinsql.z3950.server.KPWINSQLBeanUtils;
import cz.kpsys.kpwinsql.z3950.server.SpecialCaseException;
import cz.kpsys.kpwinsql.z3950.services.ZServerConfigService;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.RecordExporter;
import cz.kpsys.marc.SubField;
import cz.kpsys.service.LuceneManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.jafer.exception.JaferException;
import org.jafer.interfaces.Databean;
import org.jafer.interfaces.Present;
import org.jafer.interfaces.Search;
import org.jafer.interfaces.Z3950Connection;
import org.jafer.record.Field;
import org.jafer.util.xml.DOMFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import scala.collection.Seq;

public class KPWINSQLBean
extends Databean
implements Z3950Connection,
Present,
Search {
    private static final Logger logger = LoggerFactory.getLogger(KPWINSQLBean.class);
    private static final int ALL_FONDS = 0;
    private Hashtable recordSchemas;
    private String recordSchema;
    private Document recordTemplate;
    private Document configDocument;
    private String defaultRecordSchema;
    private String[] databases;
    private String searchProfile;
    private List<SearchResult> records;
    private int recordCursor;
    private static final int ID_POLE_SIGNATURA_TITUL = -1060;
    private static final int ID_POLE_PRIRUSTKOVE_CISLO = -1062;
    private static final int ID_POLE_SIGNATURA_BARCODE = -1063;
    private static final int ID_POLE_ID = -9000;
    DbCore2 core2 = new DbCore2();
    private final int recordsChunk = 25;
    private final Map<String, String> authorityMap = new HashMap();
    private final Map<String, String> recordsMap = new HashMap();
    private final ZServerConfig config = ZServerConfigService.getServerConfig();

    public KPWINSQLBean() throws SQLException {
        this.init();
    }

    private void init() throws SQLException {
        this.recordSchemas = new Hashtable();
        String schema = "http://www.openarchives.org/OAI/oai_marc";
        String location = "/org/jafer/conf/jdbcConfig/OAITemplate.xml";
        this.recordSchemas.put(schema, location);
        this.defaultRecordSchema = schema;
        this.configure(schema);
    }

    public String getHost() {
        return null;
    }

    public int getPort() {
        return 0;
    }

    public void setHost(String host) {
    }

    public void setPort(int port) {
    }

    public void setSearchedDatabase(String db) {
        this.databases = new String[]{db};
    }

    public String getCurrentDatabase() throws JaferException {
        return "default";
    }

    public Field getCurrentRecord() throws JaferException {
        int[] fonds = KPWINSQLBeanUtils.getFondIDs((String[])this.databases);
        ZServerDatabaseConfig dbConfig = this.getDatabaseConfig();
        if (this.recordCursor > 0 && this.recordCursor <= this.records.size()) {
            if (logger.isDebugEnabled()) {
                logger.info("ziskavam zaznam v poradi c. " + this.recordCursor);
            }
            SearchResult sr = (SearchResult)this.records.get(this.recordCursor - 1);
            if (sr.status4 == 1000 && sr.nazev.equals("#KPSYS#VERSION#")) {
                String verze = ZServerConfigService.serverVersionString((ClassLoader)this.getClass().getClassLoader());
                String dobaBehu = ZServerConfigService.dobaBehu();
                Record r = new Record();
                r.getOrCreateField(100).getOrCreateSubfield("a").setContent("KPSYS s.r.o., \u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00ed\u00e9");
                r.getOrCreateField(245).getOrCreateSubfield("a").setContent(verze);
                r.getOrCreateField(260).getOrCreateSubfield("c").setContent(dobaBehu);
                return this.createRecord(r, dbConfig.getEncoding(), OutputFormatsEnum.ISO2709);
            }
            Long recordNumber = sr.id;
            int fondNumber = sr.fond;
            logger.info("ZServer zaznam " + recordNumber + " fond " + fondNumber);
            Record record = null;
            Connection conn = null;
            try {
                conn = ProxoolUtil.obtainConnection();
                this.core2 = new DbCore2(conn);
                RecordReconstructor2 rc2 = new RecordReconstructor2(this.core2);
                rc2.setGenerujPrirustky(this.config.isPrirustky());
                record = rc2.reconstructRecord(recordNumber.longValue(), DbCache2.jeAutFond((short)((short)fondNumber)));
                List fields = RecordExporter.sortFields((List)record.getFields());
                record.getFields().clear();
                record.getFields().addAll(fields);
                KPWINSQLBeanUtils.filterDok((Record)record, (Seq)this.config.getFilterDok());
                this.core2.closeConnectionCommit();
            }
            catch (Exception e) {
                logger.error("chyba pri rekonstrukci zaznamu c. " + recordNumber + "\n" + e.getMessage());
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e1) {
                        logger.warn("selhani", (Throwable)e1);
                    }
                }
                return this.createRecord(new Record(), dbConfig.getEncoding(), OutputFormatsEnum.ISO2709);
            }
            return this.createRecord(record, dbConfig.getEncoding(), OutputFormatsEnum.ISO2709);
        }
        return this.createRecord(new Record(), dbConfig.getEncoding(), OutputFormatsEnum.ISO2709);
    }

    public String getElementSpec() {
        return null;
    }

    public int getRecordCursor() {
        return this.recordCursor;
    }

    public String getRecordSchema() {
        return this.recordSchema;
    }

    public boolean isCheckRecordFormat() {
        return false;
    }

    public void setCheckRecordFormat(boolean checkRecordFormat) {
    }

    public void setElementSpec(String elementSpec) {
    }

    public void setRecordCursor(int nRecord) throws JaferException {
        this.recordCursor = nRecord;
    }

    public void setRecordSchema(String schema) {
        if (this.recordSchemas.containsKey(schema)) {
            this.recordSchema = schema;
            this.configure(this.getRecordSchema());
        }
    }

    private void configure(String schema) {
        this.setRecordTemplate(schema);
    }

    private void setRecordTemplate(String schema) {
        String filePath = (String)this.recordSchemas.get(schema);
        InputStream templateIS = this.getClass().getResourceAsStream(filePath);
        try {
            this.recordTemplate = DOMFactory.parse((InputStream)templateIS);
        }
        catch (JaferException ex) {
            logger.error("selhani", (Throwable)ex);
        }
    }

    public String[] getDatabases() {
        return null;
    }

    public int getNumberOfResults() {
        return 0;
    }

    public Node getQuery() {
        return null;
    }

    public String getResultSetName() {
        return null;
    }

    public String getSearchProfile() {
        return null;
    }

    public boolean isParseQuery() {
        return false;
    }

    public void saveQuery(String file) throws JaferException {
    }

    public void setDatabases(String database) {
    }

    public void setDatabases(String[] databases) {
        this.databases = databases;
    }

    public void setParseQuery(boolean parseQuery) {
    }

    public void setResultSetName(String resultSetName) {
    }

    public void setSearchProfile(String searchProfile) {
        this.searchProfile = searchProfile;
    }

    private String getStringForBranch(Node branchRoot) throws JaferException {
        if (branchRoot.getNodeName().equals("and")) {
            Node firstBranch = branchRoot.getFirstChild();
            Node secondBranch = firstBranch.getNextSibling();
            return " ((" + this.getStringForBranch(firstBranch) + ") and (" + this.getStringForBranch(secondBranch) + ")) ";
        }
        if (branchRoot.getNodeName().equals("or")) {
            Node firstBranch = branchRoot.getFirstChild();
            Node secondBranch = firstBranch.getNextSibling();
            return " ((" + this.getStringForBranch(firstBranch) + ") or (" + this.getStringForBranch(secondBranch) + ")) ";
        }
        if (branchRoot.getNodeName().equals("constraintModel")) {
            Node constraintNode = branchRoot.getFirstChild();
            String modelValue = constraintNode.getNextSibling().getFirstChild().getNodeValue();
            ConstraintModel constraintModel = this.decodeConstraintModel(constraintNode);
            int[] pole = this.mapSemanticToFieldNumbers(constraintModel.getSemantic());
            String modelQueryPart = constraintModel.getCompletion() == 1 ? " ( xklic containing '" + modelValue.toUpperCase() : (constraintModel.getTruncation() == 1 ? " ( xklic starts with '" + modelValue.toUpperCase() : " ( xklic='" + modelValue.toUpperCase());
            String retval = modelQueryPart + "' and XCIS_PO IN (";
            for (int i = 0; i < pole.length; ++i) {
                retval = retval + (i > 0 ? "," : "") + pole[i];
            }
            retval = retval + "))";
        }
        return null;
    }

    private ZServerDatabaseConfig getDatabaseConfig() {
        return (ZServerDatabaseConfig)ZServerConfigService.getServerConfig().getDatabases().get(this.databases[0].toUpperCase());
    }

    private int[] mapSemanticToFieldNumbers(int semantic) throws JaferException {
        ZServerDatabaseConfig databaseConfig = this.getDatabaseConfig();
        if (databaseConfig == null) {
            String errorMsg = "request for search in invalid database: " + this.databases[0];
            logger.error(errorMsg);
            throw new JaferException(errorMsg);
        }
        int[] ret = (int[])databaseConfig.getSemanticMapping().get(Integer.toString(semantic));
        return ret;
    }

    private ConstraintModel decodeConstraintModel(Node constraintNode) {
        ConstraintModel constraintModel = new ConstraintModel();
        Node nextNode = constraintNode.getFirstChild();
        do {
            if (nextNode.getNodeName().equals("semantic")) {
                constraintModel.setSemantic(Integer.valueOf(nextNode.getFirstChild().getNodeValue()).intValue());
                continue;
            }
            if (nextNode.getNodeName().equals("relation")) {
                constraintModel.setRelation(Integer.valueOf(nextNode.getFirstChild().getNodeValue()).intValue());
                continue;
            }
            if (nextNode.getNodeName().equals("position")) {
                constraintModel.setPosition(Integer.valueOf(nextNode.getFirstChild().getNodeValue()).intValue());
                continue;
            }
            if (nextNode.getNodeName().equals("structure")) {
                constraintModel.setStructure(Integer.valueOf(nextNode.getFirstChild().getNodeValue()).intValue());
                continue;
            }
            if (nextNode.getNodeName().equals("truncation")) {
                constraintModel.setTruncation(Integer.valueOf(nextNode.getFirstChild().getNodeValue()).intValue());
                continue;
            }
            if (!nextNode.getNodeName().equals("completion")) continue;
            constraintModel.setCompletion(Integer.valueOf(nextNode.getFirstChild().getNodeValue()).intValue());
        } while ((nextNode = nextNode.getNextSibling()) != null);
        return constraintModel;
    }

    public Query processConstraintModel(Node branchRoot) throws SpecialCaseException, JaferException {
        Node firstBranch;
        try {
            Node newNode = this.fixJIBISBSN(branchRoot);
            if (newNode != null) {
                branchRoot = newNode.getFirstChild();
            }
        }
        catch (Exception e) {
            logger.warn("problem v detekci ISBN/ISSN", (Throwable)e);
        }
        if (branchRoot.getNodeName().equals("and")) {
            firstBranch = branchRoot.getFirstChild();
            Node secondBranch = firstBranch.getNextSibling();
            Query q1 = this.processConstraintModel(firstBranch);
            Query q2 = this.processConstraintModel(secondBranch);
            BooleanQuery resultQuery = new BooleanQuery.Builder().add(q1, BooleanClause.Occur.MUST).add(q2, BooleanClause.Occur.MUST).build();
            return resultQuery;
        }
        if (branchRoot.getNodeName().equals("or")) {
            firstBranch = branchRoot.getFirstChild();
            Node secondBranch = firstBranch.getNextSibling();
            Query q1 = this.processConstraintModel(firstBranch);
            Query q2 = this.processConstraintModel(secondBranch);
            BooleanQuery resultQuery = new BooleanQuery.Builder().add(q1, BooleanClause.Occur.SHOULD).add(q2, BooleanClause.Occur.SHOULD).build();
            return resultQuery;
        }
        if (branchRoot.getNodeName().equals("not")) {
            firstBranch = branchRoot.getFirstChild();
            Query q1 = this.processConstraintModel(firstBranch);
            BooleanQuery resultQuery = new BooleanQuery.Builder().add(q1, BooleanClause.Occur.MUST_NOT).build();
            return resultQuery;
        }
        if (branchRoot.getNodeName().equals("constraintModel")) {
            int minWordLen = ZServerConfigService.getServerConfig().getMinWordLength();
            Node constraintNode = branchRoot.getFirstChild();
            String modelValueOrig = constraintNode.getNextSibling().getFirstChild().getNodeValue();
            ConstraintModel constraintModel = this.decodeConstraintModel(constraintNode);
            int[] pole = this.mapSemanticToFieldNumbers(constraintModel.getSemantic());
            if (pole == null) {
                throw new JaferException("pozadovano hledani v polich, ktera tento Zserver nepodporuje");
            }
            boolean singleTokenProcessing = this.singleTokenProcessing(pole);
            StringTokenizer tokenizer = singleTokenProcessing ? new StringTokenizer(modelValueOrig, "") : new StringTokenizer(modelValueOrig.replace("  ", " "), " ");
            boolean tokenID = false;
            int[] fonds = KPWINSQLBeanUtils.getFondIDs((String[])this.databases);
            HashSet recs = new HashSet();
            Query fondsQueryPart = this.pripravFondy(fonds);
            BooleanQuery.Builder termsQueryPartBuilder = new BooleanQuery.Builder();
            while (tokenizer.hasMoreTokens()) {
                boolean semantic12;
                String token = tokenizer.nextToken();
                if (token.equals("#KPSYS#VERSION#")) {
                    throw new SpecialCaseException("#KPSYS#VERSION#");
                }
                boolean bl = semantic12 = constraintModel.getSemantic() == 12;
                if (!semantic12 && !singleTokenProcessing && !DbCache2.defKliSlov.contains(token) && (DbCache2.defVylSlov.contains(token) || minWordLen > 0 && token.length() < minWordLen)) continue;
                String modelValue = token.toLowerCase();
                BooleanQuery.Builder fieldsQueryPartBuilder = new BooleanQuery.Builder();
                for (int p : pole) {
                    TermQuery termPole;
                    if (p > 0) {
                        termPole = new TermQuery(new Term("P" + p, modelValue));
                        fieldsQueryPartBuilder.add((Query)termPole, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    termPole = null;
                    switch (p) {
                        case -1060: {
                            termPole = new TermQuery(new Term("PSIGNATURA", modelValue));
                            break;
                        }
                        case -1062: {
                            termPole = new TermQuery(new Term("PPRIRCISLO", modelValue));
                            break;
                        }
                        case -1063: {
                            termPole = new TermQuery(new Term("PSIGNATURA", modelValue));
                            fieldsQueryPartBuilder.add((Query)termPole, BooleanClause.Occur.SHOULD);
                            termPole = new TermQuery(new Term("PBARCOD", modelValue));
                            break;
                        }
                        case -9000: {
                            termPole = new TermQuery(new Term("RECORD_ID", modelValue));
                        }
                    }
                    if (termPole == null) continue;
                    fieldsQueryPartBuilder.add((Query)termPole, BooleanClause.Occur.SHOULD);
                }
                termsQueryPartBuilder.add((Query)fieldsQueryPartBuilder.build(), BooleanClause.Occur.MUST);
            }
            ZServerDatabaseConfig config = this.getDatabaseConfig();
            BooleanQuery.Builder completeTermPartBuilder = new BooleanQuery.Builder();
            BitSet statuses = config.getEnabledStatuses();
            if (!statuses.isEmpty()) {
                BooleanQuery.Builder statusQueryPartBuilder = new BooleanQuery.Builder();
                int status = statuses.nextSetBit(0);
                while (status >= 0) {
                    Query termStatus = IntPoint.newExactQuery((String)"STATUS", (int)status);
                    statusQueryPartBuilder.add(termStatus, BooleanClause.Occur.SHOULD);
                    status = statuses.nextSetBit(status + 1);
                }
                completeTermPartBuilder.add((Query)statusQueryPartBuilder.build(), BooleanClause.Occur.MUST);
            }
            completeTermPartBuilder.add(fondsQueryPart, BooleanClause.Occur.MUST);
            completeTermPartBuilder.add((Query)termsQueryPartBuilder.build(), BooleanClause.Occur.MUST);
            BooleanQuery termQuery = completeTermPartBuilder.build();
            return termQuery;
        }
        return null;
    }

    private boolean singleTokenProcessing(int[] pole) {
        return pole.length == 1 && (pole[0] == -1060 || pole[0] == -1062 || pole[0] == -1063);
    }

    private Query pripravFondy(int[] fonds) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        return IntPoint.newSetQuery((String)"REZS_FOND", (int[])fonds);
    }

    public boolean isValidIsbnIssn(String isbsn) {
        isbsn = isbsn.replaceAll("[- ]", "");
        try {
            int suma = 0;
            switch (isbsn.length()) {
                case 8: {
                    int mul = 8;
                    for (int i = 0; i < 7; ++i) {
                        int n = isbsn.charAt(i) - 48;
                        suma += n * mul;
                        --mul;
                    }
                    char controlChar = isbsn.charAt(7);
                    int kontrolniSoucet = 11 - suma % 11;
                    if (kontrolniSoucet == 10) {
                        return controlChar == 'X' || controlChar == 'x';
                    }
                    int checkSum = controlChar - 48;
                    return kontrolniSoucet == checkSum;
                }
                case 10: {
                    int mul = 10;
                    for (int i = 0; i < 9; ++i) {
                        int n = isbsn.charAt(i) - 48;
                        suma += n * mul;
                        --mul;
                    }
                    char controlChar = isbsn.charAt(9);
                    suma = controlChar == 'X' || controlChar == 'x' ? (suma += 10) : (suma += controlChar - 48);
                    return suma % 11 == 0;
                }
                case 13: {
                    if (!isbsn.startsWith("97")) {
                        return false;
                    }
                    for (int i = 0; i < 13; ++i) {
                        int n = isbsn.charAt(i) - 48;
                        suma += n * (i % 2 == 0 ? 1 : 3);
                    }
                    return suma % 10 == 0;
                }
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return false;
    }

    public Node fixJIBISBSN(Node branchRoot) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        if (branchRoot.getNodeName().equals("and")) {
            StringBuilder sb = new StringBuilder();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile("*//model/text()");
            Object result = expr.evaluate(branchRoot, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            int semantic = 1016;
            int structure = 2;
            int completion = 1;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (i == 0) {
                    expr = xpath.compile("*//constraint/*");
                    result = expr.evaluate(n.getParentNode(), XPathConstants.NODESET);
                    NodeList nodesConditions = (NodeList)result;
                    for (int q = 0; q < nodesConditions.getLength(); ++q) {
                        Node nc = nodesConditions.item(q);
                        if (nc.getNodeName().equals("semantic")) {
                            semantic = Integer.parseInt(nc.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (nc.getNodeName().equals("structure")) {
                            structure = Integer.parseInt(nc.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (!nc.getNodeName().equals("completion")) continue;
                        completion = Integer.parseInt(nc.getFirstChild().getNodeValue());
                    }
                }
                String modelValue = n.getNodeValue();
                sb.append(modelValue);
            }
            String isbsn = sb.toString();
            if (this.isValidIsbnIssn(isbsn)) {
                String template = "<constraintModel><constraint><semantic>%d</semantic><structure>%d</structure><completion>%d</completion></constraint><model>%s</model></constraintModel>";
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(String.format("<constraintModel><constraint><semantic>%d</semantic><structure>%d</structure><completion>%d</completion></constraint><model>%s</model></constraintModel>", semantic, structure, completion, isbsn)));
                Document doc = db.parse(is);
                return doc;
            }
        }
        return null;
    }

    private void concatTerms(Node branchRoot, StringBuilder sb) {
        if (branchRoot.getNodeName().equals("and") || branchRoot.getNodeName().equals("or")) {
            Node firstBranch = branchRoot.getFirstChild();
            Node secondBranch = firstBranch.getNextSibling();
            this.concatTerms(firstBranch, sb);
            this.concatTerms(secondBranch, sb);
        }
        if (branchRoot.getNodeName().equals("constraintModel")) {
            String model = branchRoot.getFirstChild().getNextSibling().getNextSibling().getNextSibling().getFirstChild().getNodeValue().trim();
            sb.append(model);
        }
    }

    private String createSQLStatement(boolean isAuthority, String modelValue, ConstraintModel constraintModel, int[] pole, int fond) {
        int truncationOrig = constraintModel.getTruncation();
        if (modelValue.endsWith("*")) {
            constraintModel.setTruncation(1);
            if (modelValue.length() > 0) {
                modelValue = modelValue.substring(0, modelValue.length() - 1);
            }
        }
        Object sqlStatement = String.format("select CIS_ZAZ4, XFOND from " + (isAuthority ? "HLEDAUT" : "HLEDDOC") + "('%s', %d, %d, ", modelValue.toUpperCase(), fond, constraintModel.getTruncation() == 1 ? 0 : 1);
        for (int i = 0; i < 10; ++i) {
            sqlStatement = i >= pole.length ? (String)sqlStatement + ", 0" : (String)sqlStatement + (i > 0 ? "," : "") + pole[i];
        }
        sqlStatement = (String)sqlStatement + ")";
        constraintModel.setTruncation(truncationOrig);
        return sqlStatement;
    }

    public int submitQuery(Node query) throws JaferException {
        Query q;
        boolean queryDebug = ZServerConfigService.getServerConfig().isQueryDebug();
        if (queryDebug) {
            logger.info("Z39.50 dotaz: " + this.debugPrintXML(query));
        }
        try {
            q = this.processConstraintModel(query);
        }
        catch (SpecialCaseException e) {
            if (e.getCause().toString().equals("#KPSYS#VERSION#")) {
                return this.vysledekHledaniStatusInfo();
            }
            return 0;
        }
        try {
            DirectoryReader reader = DirectoryReader.open((IndexWriter)LuceneManager.indexWriterDia);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)reader);
            if (queryDebug) {
                logger.info("souvisejici Lucene query: " + q.toString());
            }
            TopDocs docs = indexSearcher.search(q, 1000);
            int count = docs.scoreDocs.length;
            this.records = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                ScoreDoc scoreDoc = docs.scoreDocs[i];
                org.apache.lucene.document.Document doc = indexSearcher.doc(scoreDoc.doc);
                SearchResult searchResult = new SearchResult();
                searchResult.fond = Integer.parseInt(this.fieldValue(doc, "REZS_FOND", "0"));
                String idField = this.fieldValue(doc, "ID", "0");
                String pkField = this.fieldValue(doc, "PK", "0");
                long id = StringUtils.isNotBlank((CharSequence)pkField) ? Long.parseLong(pkField.substring(1)) : Long.parseLong(idField);
                searchResult.id = id;
                searchResult.nazev = this.fieldValue(doc, "REZS_NAZEV", "-");
                searchResult.status4 = Integer.parseInt(this.fieldValue(doc, "STATUS", "0"));
                searchResult.tridnaz = null;
                this.records.add(searchResult);
            }
        }
        catch (Exception e) {
            logger.error("chyba pri hledani Z server", (Throwable)e);
            return 0;
        }
        return this.records.size();
    }

    private int vysledekHledaniStatusInfo() {
        this.records.clear();
        SearchResult searchResult = new SearchResult();
        searchResult.nazev = "#KPSYS#VERSION#";
        searchResult.status4 = 1000;
        this.records.add(searchResult);
        return 1;
    }

    private String fieldValue(org.apache.lucene.document.Document doc, String fieldName, String defaultValue) {
        String value = doc.get(fieldName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private String debugPrintXML(Node node) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(3));
            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.toString());
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            return xmlString;
        }
        catch (Exception e) {
            logger.debug("selhani", (Throwable)e);
            return null;
        }
    }

    private Field createRecord(Record dbStringRecord, String encoding, OutputFormatsEnum outputFormat) throws JaferException {
        Field field = null;
        boolean pole910 = false;
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("selhani", (Throwable)e);
        }
        Document doc = builder.newDocument();
        Element root = doc.createElement("record");
        String dbName = null;
        dbName = this.getDatabases() == null ? "default" : (this.getDatabases()[0] == null ? "default" : this.getDatabases()[0]);
        root.setAttribute("dbName", dbName == null ? "default" : dbName);
        root.setAttribute("number", Integer.toString(this.recordCursor));
        root.setAttribute("schema", "http://www.openarchives.org/OAI/oai_marc");
        root.setAttribute("syntax", "1.2.840.10003.5.10");
        root.setAttribute("encoding", encoding);
        root.setAttribute("outputFormat", outputFormat.toString());
        doc.appendChild(root);
        Element elementMarc = doc.createElement("oai_marc");
        elementMarc.setAttribute("charEnc", "a");
        elementMarc.setAttribute("encLvl", "1");
        elementMarc.setAttribute("level", "m");
        elementMarc.setAttribute("status", "n");
        elementMarc.setAttribute("type", "a");
        elementMarc.setAttribute("status4", Integer.toString(dbStringRecord.getStatus4()));
        for (cz.kpsys.marc.Field f : dbStringRecord.getFields()) {
            Element xmlField;
            short cisloPole = f.getNumber();
            if (cisloPole >= 1000 || cisloPole <= 0) continue;
            if (cisloPole < 10) {
                xmlField = doc.createElement("fixfield");
                String content = cisloPole == 8 ? f.getContent() : f.getContent().replace("|", "");
                xmlField.appendChild(doc.createTextNode(content));
            } else {
                xmlField = doc.createElement("varfield");
                xmlField.setAttribute("i1", f.getIndString1ZServer());
                xmlField.setAttribute("i2", f.getIndString2ZServer());
                for (SubField sf : f.getSubfields()) {
                    Element subField = doc.createElement("subfield");
                    subField.setAttribute("label", sf.getPrefix());
                    subField.appendChild(doc.createTextNode(sf.getContent().replace("|", "")));
                    xmlField.appendChild(subField);
                    if (cisloPole != 910) continue;
                    pole910 = true;
                }
            }
            xmlField.setAttribute("id", Integer.toString(cisloPole));
            elementMarc.appendChild(xmlField);
        }
        if (!pole910) {
            elementMarc.appendChild(this.pridejSiglu(doc));
        }
        root.appendChild(elementMarc);
        field = new Field((Node)root, root.getFirstChild());
        return field;
    }

    private Element pridejSiglu(Document doc) {
        Element xmlField = doc.createElement("varfield");
        xmlField.setAttribute("id", "910");
        xmlField.setAttribute("i1", " ");
        xmlField.setAttribute("i2", " ");
        Element subField = doc.createElement("subfield");
        subField.setAttribute("label", "a");
        subField.appendChild(doc.createTextNode(ZServerConfigService.getServerConfig().getSigla()));
        xmlField.appendChild(subField);
        return xmlField;
    }

    private String processAuthority(String substring) {
        if (substring.startsWith("\u0002") || substring.startsWith("\u0003")) {
            Pattern p = Pattern.compile(".*?(\\d*).*?");
            Matcher m = p.matcher(substring.substring(1));
            if (m.matches()) {
                String authId = m.group(1);
                String authority = (String)this.authorityMap.get(authId);
                if (authority == null) {
                    System.err.println("chyba");
                } else {
                    authority = m.replaceFirst(authority);
                }
                return authority;
            }
            return substring;
        }
        return substring;
    }

    private Node getNewTemplate() {
        return this.recordTemplate.getDocumentElement().cloneNode(true);
    }
}

