/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.service;

public class CommitCounter {
    private final long limitMs;
    private final int limitCount;
    private final int limitEval;
    long lastCommit;
    int counter;
    long[] tickTimes;
    int tickCounter;
    private long lastTime;
    private long currentTime;

    public CommitCounter(long limitMs, int limitCount, int limitEval, boolean shouldCommitOnStart) {
        this.limitMs = limitMs;
        this.limitCount = limitCount;
        this.lastCommit = shouldCommitOnStart ? 0L : System.currentTimeMillis();
        this.limitEval = limitEval;
        this.tickTimes = new long[limitEval];
    }

    public void reset() {
        this.counter = 0;
        this.lastCommit = System.currentTimeMillis();
    }

    public double pocetZaSekundu() {
        if (this.currentTime == 0L || this.lastTime == 0L) {
            return 0.0;
        }
        return (double)this.limitEval / ((double)(this.currentTime - this.lastTime) / 1000.0);
    }

    public boolean shouldCommit() {
        ++this.counter;
        this.lastTime = this.tickTimes[this.tickCounter];
        this.tickTimes[this.tickCounter] = this.currentTime = System.currentTimeMillis();
        ++this.tickCounter;
        if (this.tickCounter >= this.limitEval) {
            this.tickCounter = 0;
        }
        if (this.limitCount > 0 && this.counter > this.limitCount) {
            this.reset();
            return true;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastCommit + this.limitMs < currentTime) {
            this.reset();
            return true;
        }
        return false;
    }
}

