/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.service;

public class PerformanceCounter {
    private final long start;
    private long stop;
    private int interval;
    private int fromLastPrint;
    private int counter;
    private static final long minLimit = 2000L;
    private static final long maxLimit = 6000L;
    private static final long step = 1000L;
    private long lastTickTime;

    public PerformanceCounter() {
        this.fromLastPrint = this.interval = 32;
        this.counter = 0;
        this.lastTickTime = 0L;
        this.lastTickTime = this.start = System.currentTimeMillis();
    }

    public void tick() {
        ++this.fromLastPrint;
        ++this.counter;
    }

    public boolean shouldUpdateView() {
        return this.fromLastPrint > this.interval;
    }

    public double countOpsPerSecond() {
        long curr = System.currentTimeMillis();
        long diff = curr - this.lastTickTime;
        double result = (double)this.interval / (double)diff * 1000.0;
        if (diff > 6000L) {
            this.interval -= this.interval / 4;
        } else if (diff < 2000L) {
            this.interval += this.interval;
        }
        this.lastTickTime = curr;
        this.fromLastPrint = 0;
        return result;
    }

    public void stop() {
        this.stop = System.currentTimeMillis();
        System.err.println("celkem: " + this.counter + " pocet/s: " + (double)((long)this.counter / (this.stop - this.start)) / 1000.0);
    }
}

