/*
 * Decompiled with CFR 0.152.
 */
package marc;

import java.util.Hashtable;
import marc.MARCException;

/*
 * Exception performing whole class analysis ignored.
 */
public class USmarcField {
    public static final byte FIELD_TERMINATOR = 30;
    public static final byte SUBFIELD_TERMINATOR = 31;
    public String tag;
    public byte indicator1;
    public byte indicator2;
    public byte[] subfield_code;
    public String[] subfield_data;
    private static Hashtable tag_names;

    public USmarcField(String tag_str, int length, byte[] encoding, int offset) throws MARCException {
        if (length < 2) {
            throw new MARCException("Field encoding too short");
        }
        if (encoding.length < offset + length) {
            throw new MARCException("Field encoding truncated");
        }
        int num_subfields = 0;
        for (int n = 2; n < length; ++n) {
            if (encoding[offset + n] != 31) continue;
            ++num_subfields;
        }
        this.tag = tag_str;
        this.indicator1 = encoding[offset];
        this.indicator2 = encoding[offset + 1];
        if (num_subfields == 0) {
            this.subfield_code = new byte[1];
            this.subfield_code[0] = 0;
            this.subfield_data = new String[1];
            this.subfield_data[0] = new String(encoding, 0, offset + 2, length - 2 - 1);
        } else {
            this.subfield_code = new byte[num_subfields];
            this.subfield_data = new String[num_subfields];
            int starting = offset + 2;
            for (int n = 0; n < num_subfields; ++n) {
                this.subfield_code[n] = encoding[starting + 1];
                int ending = starting += 2;
                while (encoding[ending] != 31 && encoding[ending] != 30) {
                    ++ending;
                }
                this.subfield_data[n] = new String(encoding, 0, starting, ending - starting);
                starting = ending;
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(USmarcField.tag2name((String)this.tag));
        buf.append(":");
        for (int n = 0; n < this.subfield_data.length; ++n) {
            buf.append("\n  ");
            buf.append(this.subfield_data[n]);
        }
        return new String(buf);
    }

    private static void initialise() {
        tag_names = new Hashtable();
        tag_names.put("001", "Control Number (Nr)");
        tag_names.put("003", "Control Number Indentifier (Nr)");
        tag_names.put("005", "Date And Time Of Latest Transaction (Nr)");
        tag_names.put("006", "Fixed-Length Data Elements--Additional Material");
        tag_names.put("007", "Physical Description Fixed Field--General Information (R)");
        tag_names.put("008", "Fixed-Length Data Elements--General Information (Nr)");
        tag_names.put("010", "Library Of Congress Control Number (Nr)");
        tag_names.put("013", "Patent Control Information");
        tag_names.put("015", "National Bibliography Number (Nr)");
        tag_names.put("017", "Copyright Registration Number (R)");
        tag_names.put("018", "Copyright Article-Fee Code (Nr)");
        tag_names.put("020", "International Standard Book Number (R)");
        tag_names.put("022", "International Standard Serial Number (R)");
        tag_names.put("024", "Other Standard Identifier (R)");
        tag_names.put("025", "Overseas Acquisition Number (R)");
        tag_names.put("027", "Standard Technical Report Number (R)");
        tag_names.put("028", "Publisher Number For Music (R)");
        tag_names.put("030", "Coden Designation (R)");
        tag_names.put("032", "Postal Registration Number (R)");
        tag_names.put("033", "Date/Time And Place Of An Event (R)");
        tag_names.put("034", "Coded Cartographic Mathematical Data (R)");
        tag_names.put("035", "System Control Number (R)");
        tag_names.put("036", "Original Study Number For Computer Data Files (Nr)");
        tag_names.put("037", "Source Of Acquisition (R)");
        tag_names.put("040", "Cataloging Source (Nr)");
        tag_names.put("041", "Language Code (Nr)");
        tag_names.put("042", "Authentication Code (Nr)");
        tag_names.put("043", "Geographic Area Code (Nr)");
        tag_names.put("044", "Country Of Publishing/Producing Entity Code (Nr)");
        tag_names.put("045", "Time Period Of Content (Nr)");
        tag_names.put("046", "Type Of Date Code, Date 1, Date 2 (B.C. Dates) (Nr)");
        tag_names.put("047", "Form Of Musical Composition Code (Nr)");
        tag_names.put("048", "Number Of Musical Instruments Or Voices Code (R)");
        tag_names.put("050", "Library Of Congress Call Number (R)");
        tag_names.put("051", "Library Of Congress Copy, Issue, Offprint Statement (R)");
        tag_names.put("052", "Geographic Classification Code (R)");
        tag_names.put("055", "Call Numbers/Class Numbers Assigned In Canada (R)");
        tag_names.put("060", "National Library Of Medicine Call Number (R)");
        tag_names.put("061", "National Library Of Medicine Copy Statement (R)");
        tag_names.put("066", "Character Sets Present (Nr)");
        tag_names.put("070", "National Agricultural Library Call Number (R)");
        tag_names.put("071", "National Agricultural Library Copy Statement (R)");
        tag_names.put("072", "Subject Category Code (R)");
        tag_names.put("074", "Gpo Item Number (R)");
        tag_names.put("080", "Universal Decimal Classification Number (Nr)");
        tag_names.put("082", "Dewey Decimal Call Number (R)");
        tag_names.put("084", "Other Classification Number (R)");
        tag_names.put("086", "Government Document Call Number (R)");
        tag_names.put("088", "Report Number (R)");
        tag_names.put("100", "Main Entry--Personal Name (Nr)");
        tag_names.put("110", "Main Entry--Corporate Name (Nr)");
        tag_names.put("111", "Main Entry--Meeting Name (Nr)");
        tag_names.put("130", "Main Entry--Uniform Title (Nr)");
        tag_names.put("210", "Abbreviated Key Title (Nr)");
        tag_names.put("222", "Key Title (R)");
        tag_names.put("240", "Uniform Title (Nr)");
        tag_names.put("242", "Translation Of Title By Cataloging Agency (R)");
        tag_names.put("243", "Collective Uniform Title (Nr)");
        tag_names.put("245", "Title Statement (Nr)");
        tag_names.put("246", "Varying Form Of Title (R)");
        tag_names.put("247", "Former Title Or Title Variations (R)");
        tag_names.put("250", "Edition Statement (Nr)");
        tag_names.put("254", "Musical Presentation Statement (Nr)");
        tag_names.put("255", "Cartographic Mathematical Data (R)");
        tag_names.put("256", "Computer File Characteristics (Nr)");
        tag_names.put("257", "Country Of Producing Entity For Archival Films (Nr)");
        tag_names.put("260", "Publication, Distribution, Etc. (Imprint) (Nr)");
        tag_names.put("261", "Imprint Statement For Films (Pre-Aacr 1 Revised) (Nr)");
        tag_names.put("262", "Imprint Statement For Sound Recordings (Pre-Aacr 2) (Nr)");
        tag_names.put("263", "Projected Publication Date (Nr)");
        tag_names.put("270", "Address (R)");
        tag_names.put("300", "Physical Description (R)");
        tag_names.put("306", "Playing Time (Nr)");
        tag_names.put("307", "Hours, Etc. (Nr)");
        tag_names.put("310", "Current Publication Frequency (Nr)");
        tag_names.put("321", "Former Publication Frequency (R)");
        tag_names.put("340", "Physical Medium (R)");
        tag_names.put("342", "Geospatial Reference Data (R) [Provisional]");
        tag_names.put("343", "Planar Coordinate Data (R) [Provisional]");
        tag_names.put("351", "Organization And Arrangement Of Materials (R)");
        tag_names.put("352", "Digital Graphic Representation (R) [Provisional]");
        tag_names.put("355", "Security Classification Control (R)");
        tag_names.put("357", "Originator Dissemination Control (Nr)");
        tag_names.put("362", "Dates Of Publication And/Or Volume Designation (R)");
        tag_names.put("400", "Series Statement/Added Entry--Personal Name (R)");
        tag_names.put("410", "Series Statement/Added Entry--Corporate Name (R)");
        tag_names.put("411", "Series Statement/Added Entry--Meeting Name (R)");
        tag_names.put("440", "Series Statement/Added Entry--Title (R)");
        tag_names.put("490", "Series Statement (R)");
        tag_names.put("500", "General Note (R)");
        tag_names.put("501", "With Note (R)");
        tag_names.put("502", "Dissertation Note (R)");
        tag_names.put("504", "Bibliography, Etc. Note (R)");
        tag_names.put("505", "Formatted Contents Note (Nr)");
        tag_names.put("506", "Restrictions On Access Note (R)");
        tag_names.put("507", "Scale Note For Graphic Material (Nr)");
        tag_names.put("508", "Creation/Production Credits Note (Nr)");
        tag_names.put("510", "Citation/References Note (R)");
        tag_names.put("511", "Participant Or Performer Note (R)");
        tag_names.put("513", "Type Of Report And Period Covered Note (R)");
        tag_names.put("514", "Data Quality Note (Nr) [Provisional]");
        tag_names.put("515", "Numbering Peculiarities Note (R)");
        tag_names.put("516", "Type Of Computer File Or Data Note (R)");
        tag_names.put("518", "Date/Time And Place Of An Event Note (R)");
        tag_names.put("520", "Summary, Etc. Note (R)");
        tag_names.put("521", "Target Audience Note (R)");
        tag_names.put("522", "Geographic Coverage Note (Nr)");
        tag_names.put("524", "Preferred Citation Of Described Materials Note (Nr)");
        tag_names.put("525", "Supplement Note (R)");
        tag_names.put("530", "Additional Physical Form Available Note (R)");
        tag_names.put("533", "Reproduction Note (R)");
        tag_names.put("534", "Original Version Note (R)");
        tag_names.put("535", "Location Of Originals/Duplicates Note (R)");
        tag_names.put("536", "Funding Information Note (R)");
        tag_names.put("538", "System Details Note (R)");
        tag_names.put("540", "Terms Governing Use And Reproduction Note (R)");
        tag_names.put("541", "Immediate Source Of Acquisition Note (R)");
        tag_names.put("544", "Location Of Associated Archival Materials Note (R)");
        tag_names.put("545", "Biographical Or Historical Note (R)");
        tag_names.put("546", "Language Note (R)");
        tag_names.put("547", "Former Title Complexity Note (R)");
        tag_names.put("550", "Issuing Body Note (R)");
        tag_names.put("551", "Entity And Attribute Information Note (R) [Provisional]");
        tag_names.put("555", "Cumulative Index/Finding Aids Note (R)");
        tag_names.put("556", "Information About Documentation Note (R)");
        tag_names.put("561", "Provenance Note (R)");
        tag_names.put("562", "Copy And Version Identification Note (R)");
        tag_names.put("565", "Case File Characteristics Note (R)");
        tag_names.put("567", "Methodology Note (R)");
        tag_names.put("580", "Linking Entry Complexity Note (R)");
        tag_names.put("581", "Publications About Described Materials Note (R)");
        tag_names.put("583", "Action Note (R)");
        tag_names.put("584", "Accumulation And Frequency Of Use Note (R)");
        tag_names.put("585", "Exhibitions Note (R)");
        tag_names.put("586", "Awards Note (R)");
        tag_names.put("59X", "Local Notes");
        tag_names.put("600", "Subject Added Entry--Personal Name (R)");
        tag_names.put("610", "Subject Added Entry--Corporate Name (R)");
        tag_names.put("611", "Subject Added Entry--Meeting Name (R)");
        tag_names.put("630", "Subject Added Entry--Uniform Title (R)");
        tag_names.put("650", "Subject Added Entry--Topical Term (R)");
        tag_names.put("651", "Subject Added Entry--Geographic Name (R)");
        tag_names.put("653", "Index Term--Uncontrolled (R)");
        tag_names.put("654", "Subject Added Entry--Faceted Topical Terms (R)");
        tag_names.put("655", "Index Term--Genre/Form (R)");
        tag_names.put("656", "Index Term--Occupation (R)");
        tag_names.put("657", "Index Term--Function (R)");
        tag_names.put("658", "Index Term--Curriculum Objective (R)");
        tag_names.put("700", "Added Entry--Personal Name (R)");
        tag_names.put("710", "Added Entry--Corporate Name (R)");
        tag_names.put("711", "Added Entry--Meeting Name (R)");
        tag_names.put("720", "Added Entry--Uncontrolled Name (R)");
        tag_names.put("730", "Added Entry--Uniform Title (R)");
        tag_names.put("740", "Added Entry--Uncontrolled Related/Analytical Title (R)");
        tag_names.put("752", "Added Entry--Hierarchical Place Name (R)");
        tag_names.put("753", "System Details Access To Computer Files (R)");
        tag_names.put("754", "Added Entry--Taxonomic Identification (R)");
        tag_names.put("800", "Series Added Entry--Personal Name (R)");
        tag_names.put("810", "Series Added Entry--Corporate Name (R)");
        tag_names.put("811", "Series Added Entry--Meeting Name (R)");
        tag_names.put("830", "Series Added Entry--Uniform Title (R)");
        tag_names.put("841", "Holdings Coded Data Values (Nr)");
        tag_names.put("843", "Reproduction Note (R)");
        tag_names.put("845", "Terms Governing Use And Reproduction Note (R)");
        tag_names.put("850", "Holding Institution (R)");
        tag_names.put("852", "Location/Call Number (R)");
        tag_names.put("853", "Captions And Pattern--Basic Bibliographic Unit (R)");
        tag_names.put("854", "Captions And Pattern--Supplementary Material (R)");
        tag_names.put("855", "Captions And Pattern--Indexes (R)");
        tag_names.put("856", "Electronic Location And Access (R)");
        tag_names.put("863", "Enumeration And Chronology--Basic Bibliographic Unit (R)");
        tag_names.put("864", "Enumeration And Chronology--Supplementary Material (R)");
        tag_names.put("865", "Enumeration And Chronology--Indexes (R)");
        tag_names.put("866", "Textual Holdings--Basic Bibliographic Unit (R)");
        tag_names.put("867", "Textual Holdings--Supplementary Material (R)");
        tag_names.put("868", "Textual Holdings--Indexes (R)");
        tag_names.put("876", "Item Information--Basic Bibliographic Unit (R)");
        tag_names.put("877", "Item Information--Supplementary Material (R)");
        tag_names.put("878", "Item Information--Indexes (R)");
        tag_names.put("880", "Alternate Graphic Representation (R)");
        tag_names.put("886", "Foreign MARC Information Field (R)");
    }

    public static String tag2name(String tag) {
        Object name;
        if (tag_names == null) {
            USmarcField.initialise();
        }
        if ((name = (String)tag_names.get(tag)) == null) {
            name = "Unknown tag " + tag;
        }
        return name;
    }
}

