/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.conf;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.CachedXPathAPI;
import org.jafer.exception.JaferException;
import org.jafer.util.xml.DOMFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class Config {
    public static final String RECORD_DESCRIPTOR_FILE = "org/jafer/conf/recordDescriptor.xml";
    public static final String BIB1_ATTRIBUTES_FILE = "org/jafer/conf/bib1Attributes.xml";
    public static final String BIB1_DIAGNOSTICS_FILE = "org/jafer/conf/bib1Diagnostics.xml";
    public static final String SEARCH_PROFILES_FILE = "org/jafer/conf/searchProfiles.xml";
    public static final String CHARACTER_SETS_FILE = "org/jafer/conf/characterSets/characterSets.xml";
    public static final String SERVER_CONFIG_FILE = "org/jafer/conf/server.xml";
    public static final String SERVER_DECODE_FILE = "org/jafer/xsl/Server/server-decode.xsl";
    public static final String SERVER_ENCODE_FILE = "org/jafer/xsl/Server/server-encode.xsl";
    private static Document recordTransformDocument;
    private static Hashtable recordName;
    private static Hashtable recordSyntax;
    private static Hashtable recordSerializer;
    private static Hashtable recordSerializerTargetSchema;
    private static Hashtable recordTransformations;
    private static Hashtable attributeSets;
    private static Hashtable attributeTypeName;
    private static Hashtable attributeTypeValue;
    private static Hashtable searchProfileSyntax;
    private static Hashtable searchProfileName;
    private static Hashtable bib1Diagnostic;
    private static String attributeSetName;
    private static String attributeSetSyntax;
    private static CachedXPathAPI xPathAPI;
    private static Config config;

    public static InputStream getResourceAsStream(String path) {
        return new Config().getClass().getClassLoader().getResourceAsStream(path);
    }

    private static void buildRecordConfig(String recordDescriptorFile) throws JaferException {
        recordName = new Hashtable();
        recordSyntax = new Hashtable();
        recordSerializer = new Hashtable();
        recordSerializerTargetSchema = new Hashtable();
        recordTransformations = new Hashtable();
        Document recordDescriptorDocument = config.parseDocument(recordDescriptorFile);
        recordTransformDocument = DOMFactory.newDocument();
        Element transformRoot = recordTransformDocument.createElement("transformRoot");
        recordTransformDocument.appendChild(transformRoot);
        NodeList oidNodes = Config.selectNodeList((Node)recordDescriptorDocument, (String)"recordDescriptor/oid");
        for (int i = 0; i < oidNodes.getLength(); ++i) {
            Node oidNode = oidNodes.item(i);
            String oidName = Config.getValue((Node)Config.selectSingleNode((Node)oidNode, (String)"@name"));
            String syntax = Config.getValue((Node)Config.selectSingleNode((Node)oidNode, (String)"@syntax"));
            String priority = Config.getValue((Node)Config.selectSingleNode((Node)oidNode, (String)"@priority"));
            Node serializerNode = Config.selectSingleNode((Node)oidNode, (String)"serializer");
            recordName.put(syntax, oidName);
            recordSyntax.put(oidName, syntax);
            if (serializerNode == null) continue;
            String serializer = Config.getValue((Node)serializerNode);
            String schema = Config.getValue((Node)Config.selectSingleNode((Node)serializerNode, (String)"@targetSchema"));
            Node transformNode = recordTransformDocument.importNode(serializerNode, false);
            ((Element)transformNode).setAttribute("priority", priority);
            ((Element)transformNode).setAttribute("syntax", syntax);
            transformRoot.appendChild(transformNode);
            Hashtable transformNodes = new Hashtable();
            transformNodes.put("fromSerializer", new Hashtable());
            transformNodes.put("toSerializer", new Hashtable());
            ((Hashtable)transformNodes.get("fromSerializer")).put(schema, transformNode);
            ((Hashtable)transformNodes.get("toSerializer")).put(schema, transformNode);
            Config.buildTransformNodes((Node)oidNode, (Node)transformNode, new Vector(), new Hashtable(), transformNodes, (String)schema, (boolean)true);
            Config.buildTransformNodes((Node)oidNode, (Node)transformNode, new Vector(), new Hashtable(), transformNodes, (String)schema, (boolean)false);
            recordTransformations.put(syntax, transformNodes);
            recordSerializerTargetSchema.put(syntax, schema);
            recordSerializer.put(syntax, serializer);
        }
    }

    private static void buildTransformNodes(Node oidNode, Node transformNode, Vector path, Hashtable schemaDepth, Hashtable schemaNodes, String fromSchema, boolean fromSerializer) throws JaferException {
        NodeList nodes;
        Hashtable transformNodes;
        if (path.contains(fromSchema)) {
            return;
        }
        path = new Vector<String>(path);
        path.add(fromSchema);
        if (fromSerializer) {
            transformNodes = (Hashtable)schemaNodes.get("fromSerializer");
            nodes = Config.selectNodeList((Node)oidNode, (String)("transform[@sourceSchema='" + fromSchema + "']"));
        } else {
            transformNodes = (Hashtable)schemaNodes.get("toSerializer");
            nodes = Config.selectNodeList((Node)oidNode, (String)("transform[@targetSchema='" + fromSchema + "']"));
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child;
            String toSchema = fromSerializer ? Config.getValue((Node)Config.selectSingleNode((Node)nodes.item(i), (String)"@targetSchema")) : Config.getValue((Node)Config.selectSingleNode((Node)nodes.item(i), (String)"@sourceSchema"));
            if (path.contains(toSchema)) continue;
            if (transformNodes.containsKey(toSchema) && path.size() < (Integer)schemaDepth.get(toSchema)) {
                child = (Node)transformNodes.get(toSchema);
                Node parent = child.getParentNode();
                parent.removeChild(child);
                transformNodes.remove(toSchema);
                schemaDepth.remove(toSchema);
            }
            if (transformNodes.containsKey(toSchema)) continue;
            child = recordTransformDocument.importNode(nodes.item(i), true);
            transformNode.appendChild(child);
            schemaDepth.put(toSchema, new Integer(path.size()));
            transformNodes.put(toSchema, child);
            Config.buildTransformNodes((Node)oidNode, (Node)child, path, (Hashtable)schemaDepth, (Hashtable)schemaNodes, (String)toSchema, (boolean)fromSerializer);
        }
    }

    public static Document getRecordTransformDocument() {
        return recordTransformDocument;
    }

    public static String getRecordSerializer(String syntax) throws JaferException {
        if (recordSerializer.containsKey(syntax)) {
            return (String)recordSerializer.get(syntax);
        }
        throw new JaferException("recordSyntax " + syntax + " not found in recordDescriptor file org/jafer/conf/recordDescriptor.xml");
    }

    public static String getRecordSerializerTargetSchema(String syntax) throws JaferException {
        if (recordSerializerTargetSchema.containsKey(syntax)) {
            return (String)recordSerializerTargetSchema.get(syntax);
        }
        throw new JaferException("recordSyntax " + syntax + " not found in recordDescriptor file org/jafer/conf/recordDescriptor.xml");
    }

    public static String getRecordNameFromSyntax(String syntax) throws JaferException {
        if (recordName.containsKey(syntax)) {
            return (String)recordName.get(syntax);
        }
        throw new JaferException("recordSyntax " + syntax + " not found in recordDescriptor file org/jafer/conf/recordDescriptor.xml");
    }

    public static String getRecordSyntaxFromName(String name) throws JaferException {
        if (recordSyntax.containsKey(name)) {
            return (String)recordSyntax.get(name);
        }
        throw new JaferException("syntax Name " + name + " not found in recordDescriptor file org/jafer/conf/recordDescriptor.xml");
    }

    public static boolean isSyntaxEqual(String syntaxA, String syntaxB) {
        return Config.isSyntaxEqual((int[])Config.convertSyntax((String)syntaxA), (int[])Config.convertSyntax((String)syntaxB));
    }

    public static boolean isSyntaxEqual(int[] syntaxA, int[] syntaxB) {
        if (syntaxA.length != syntaxB.length) {
            return false;
        }
        for (int x = 0; x < syntaxA.length; ++x) {
            if (syntaxA[x] == syntaxB[x]) continue;
            return false;
        }
        return true;
    }

    public static int[] convertSyntax(String syntaxString) {
        String[] oidStringArray = syntaxString.split("\\.");
        int[] syntaxArray = new int[oidStringArray.length];
        for (int i = 0; i < syntaxArray.length; ++i) {
            syntaxArray[i] = Integer.parseInt(oidStringArray[i]);
        }
        return syntaxArray;
    }

    public static String convertSyntax(int[] syntaxArray) {
        String syntaxString = String.valueOf(syntaxArray[0]);
        for (int i = 1; i < syntaxArray.length; ++i) {
            syntaxString = syntaxString.concat("." + String.valueOf(syntaxArray[i]));
        }
        return syntaxString;
    }

    public static String getRecordSyntax(String schema) throws JaferException {
        int currentPriority = 0;
        int priority = Integer.MAX_VALUE;
        String currentSyntax = null;
        String syntax = null;
        Enumeration syntaxKeys = recordTransformations.keys();
        while (syntaxKeys.hasMoreElements()) {
            currentSyntax = (String)syntaxKeys.nextElement();
            Hashtable transformsNodes = (Hashtable)((Hashtable)recordTransformations.get(currentSyntax)).get("fromSerializer");
            Node transformNode = (Node)transformsNodes.get(schema);
            if (transformNode == null || (currentPriority = Config.getTransforms((boolean)true, (Node)transformNode, new Vector())) > priority) continue;
            priority = currentPriority;
            syntax = currentSyntax;
        }
        if (syntax == null) {
            throw new JaferException("NULL recordSyntax: schema " + schema + " not found in recordDescriptor file org/jafer/conf/recordDescriptor.xml");
        }
        return syntax;
    }

    public static Vector getTransforms(boolean fromSerializer, String syntax, String schema) throws JaferException {
        Hashtable nodes;
        Hashtable transformNodes = (Hashtable)recordTransformations.get(syntax);
        if (fromSerializer && ((Hashtable)transformNodes.get("fromSerializer")).containsKey(schema)) {
            nodes = (Hashtable)transformNodes.get("fromSerializer");
        } else if (!fromSerializer && ((Hashtable)transformNodes.get("toSerializer")).containsKey(schema)) {
            nodes = (Hashtable)transformNodes.get("toSerializer");
        } else {
            throw new JaferException("Schema " + schema + " for recordSyntax " + syntax + " not found in recordDescriptor file org/jafer/conf/recordDescriptor.xml");
        }
        Node transformNode = (Node)nodes.get(schema);
        Vector transforms = new Vector();
        Config.getTransforms((boolean)fromSerializer, (Node)transformNode, transforms);
        return transforms;
    }

    private static int getTransforms(boolean fromSerializer, Node transformNode, Vector transforms) throws JaferException {
        if (transformNode.getNodeName().equals("serializer")) {
            try {
                return Integer.parseInt(Config.getValue((Node)Config.selectSingleNode((Node)transformNode, (String)"@priority")));
            }
            catch (NumberFormatException ex) {
                return Integer.MAX_VALUE;
            }
        }
        int priority = Config.getTransforms((boolean)fromSerializer, (Node)transformNode.getParentNode(), (Vector)transforms);
        if (fromSerializer) {
            transforms.add(Config.getValue((Node)transformNode));
        } else {
            transforms.add(0, Config.getValue((Node)transformNode));
        }
        return priority;
    }

    private static void buildBib1AttributeConfig(String bib1AttributesFile) throws JaferException {
        Document attributeDocument = config.parseDocument(bib1AttributesFile);
        attributeSets = new Hashtable();
        attributeTypeName = new Hashtable();
        attributeTypeValue = new Hashtable();
        attributeSetSyntax = Config.getValue((Node)Config.selectSingleNode((Node)attributeDocument, (String)"attributeSets/@syntax"));
        NodeList attributeSetNodes = Config.selectNodeList((Node)attributeDocument, (String)"attributeSets/attributeSet");
        for (int i = 0; i < attributeSetNodes.getLength(); ++i) {
            boolean defaultAttributeSet;
            Node node = attributeSetNodes.item(i);
            String name = Config.getValue((Node)Config.selectSingleNode((Node)node, (String)"@name"));
            Hashtable attributeSet = new Hashtable();
            attributeSets.put(name, attributeSet);
            if (Boolean.valueOf(Config.getValue((Node)Config.selectSingleNode((Node)node, (String)"@default"))).booleanValue()) {
                defaultAttributeSet = true;
                attributeSetName = name;
            } else {
                defaultAttributeSet = false;
            }
            NodeList attributeTypeNodes = Config.selectNodeList((Node)node, (String)"attributeType");
            for (int j = 0; j < attributeTypeNodes.getLength(); ++j) {
                node = attributeTypeNodes.item(j);
                name = Config.getValue((Node)Config.selectSingleNode((Node)node, (String)"@name"));
                String value = Config.getValue((Node)Config.selectSingleNode((Node)node, (String)"@value"));
                Hashtable<String, String> attributes = new Hashtable<String, String>();
                attributeSet.put(name, attributes);
                if (defaultAttributeSet) {
                    attributeTypeName.put(value, name);
                    attributeTypeValue.put(name, value);
                }
                NodeList attributeNodes = Config.selectNodeList((Node)node, (String)"attribute");
                for (int k = 0; k < attributeNodes.getLength(); ++k) {
                    node = attributeNodes.item(k);
                    name = Config.getValue((Node)Config.selectSingleNode((Node)node, (String)"@name"));
                    value = Config.getValue((Node)Config.selectSingleNode((Node)node, (String)"@value"));
                    attributes.put(name, value);
                }
            }
        }
    }

    public static String getAttributeSetName() {
        return attributeSetName;
    }

    public static String getAttributeSetSyntax() {
        return attributeSetSyntax;
    }

    public static int getAttributeValue(String attributeSetName, String attributeTypeName, String attributeName) {
        Hashtable attributeSet = (Hashtable)attributeSets.get(attributeSetName);
        Hashtable attributes = (Hashtable)attributeSet.get(attributeTypeName);
        return Integer.parseInt((String)attributes.get(attributeName));
    }

    public static int getAttributeType(String attributeTypeName) throws JaferException {
        try {
            return Integer.parseInt((String)attributeTypeValue.get(attributeTypeName));
        }
        catch (NumberFormatException ex) {
            throw new JaferException("attributeTypeName not found");
        }
    }

    public static String getAttributeType(int attributeTypeValue) throws JaferException {
        String attributeType = (String)attributeTypeName.get(String.valueOf(attributeTypeValue));
        if (attributeType == null) {
            throw new JaferException("attributeTypeValue not found");
        }
        return attributeType;
    }

    private static void buildBib1DiagnosticConfig(String bib1DiagnosticsFile) throws JaferException {
        Document diagnosticDocument = config.parseDocument(bib1DiagnosticsFile);
        bib1Diagnostic = new Hashtable();
        NodeList nodes = Config.selectNodeList((Node)diagnosticDocument, (String)"bib1Diagnostics/condition");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = Config.getValue((Node)node);
            String value = Config.getValue((Node)Config.selectSingleNode((Node)node, (String)"@value"));
            bib1Diagnostic.put(value, name);
        }
    }

    private static void buildSearchProfileConfig(String searchProfilesFile) throws JaferException {
        Document profileDocument = config.parseDocument(searchProfilesFile);
        searchProfileSyntax = new Hashtable();
        searchProfileName = new Hashtable();
        NodeList searchProfileNodes = Config.selectNodeList((Node)profileDocument, (String)"searchProfiles/searchProfile");
        for (int i = 0; i < searchProfileNodes.getLength(); ++i) {
            Node node = searchProfileNodes.item(i);
            String name = Config.getValue((Node)Config.selectSingleNode((Node)node, (String)"@name"));
            String syntax = Config.getValue((Node)Config.selectSingleNode((Node)node, (String)"@syntax"));
            searchProfileName.put(syntax, name);
            searchProfileSyntax.put(name, syntax);
        }
    }

    public static String getBib1Diagnostic(int condition) {
        return (String)bib1Diagnostic.get(String.valueOf(condition));
    }

    public static String getSearchProfileSyntaxFromName(String searchProfileName) {
        return (String)searchProfileSyntax.get(searchProfileName);
    }

    public static String getSearchProfileNameFromSyntax(String searchProfileSyntax) {
        return (String)searchProfileName.get(searchProfileSyntax);
    }

    public static Document getCharacterSetsMap() throws JaferException {
        return config.parseDocument("org/jafer/conf/characterSets/characterSets.xml");
    }

    public static Document getServerConfigDocument() throws JaferException {
        return config.parseDocument("org/jafer/conf/server.xml");
    }

    public static InputStream getServerDecode() throws JaferException {
        return Config.getResourceAsStream((String)"org/jafer/xsl/Server/server-decode.xsl");
    }

    public static InputStream getServerEncode() throws JaferException {
        return Config.getResourceAsStream((String)"org/jafer/xsl/Server/server-encode.xsl");
    }

    public static NodeList selectNodeList(Node node, String xPath) throws JaferException {
        NodeList nodeList = null;
        try {
            nodeList = xPathAPI.selectNodeList(node, xPath);
        }
        catch (TransformerException e) {
            String message = "Error selecting Nodes: " + e.getMessage();
            throw new JaferException(message, (Throwable)e);
        }
        return nodeList;
    }

    public static Node selectSingleNode(Node node, String xPath) throws JaferException {
        Node selection = null;
        try {
            selection = xPathAPI.selectSingleNode(node, xPath);
        }
        catch (TransformerException e) {
            String message = "Error selecting Node: " + e.getMessage();
            throw new JaferException(message, (Throwable)e);
        }
        return selection;
    }

    public static String getValue(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        if (node.hasChildNodes() && node.getFirstChild().getNodeType() == 3) {
            if (node.getFirstChild().getNodeValue() != null) {
                return node.getFirstChild().getNodeValue();
            }
            return "";
        }
        if (node.getNodeValue() != null) {
            return node.getNodeValue();
        }
        return "";
    }

    private Document parseDocument(String documentPath) throws JaferException {
        InputStream is = null;
        Document document = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(documentPath);
            document = DOMFactory.parse((InputStream)is);
        }
        catch (JaferException e) {
            String message = "Error parsing document; could not find resource: " + documentPath;
            throw new JaferException(message, (Throwable)e);
        }
        return document;
    }

    static {
        xPathAPI = new CachedXPathAPI();
        config = new Config();
        try {
            Config.buildRecordConfig((String)"org/jafer/conf/recordDescriptor.xml");
            Config.buildBib1AttributeConfig((String)"org/jafer/conf/bib1Attributes.xml");
            Config.buildBib1DiagnosticConfig((String)"org/jafer/conf/bib1Diagnostics.xml");
            Config.buildSearchProfileConfig((String)"org/jafer/conf/searchProfiles.xml");
        }
        catch (Exception e) {
            System.out.println("org.jafer.conf.Config - Error attempting to build configuration!");
            e.printStackTrace();
        }
    }
}

