/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.databeans;

import java.util.Hashtable;
import org.jafer.databeans.ActiveBean;
import org.jafer.exception.JaferException;
import org.jafer.interfaces.Databean;
import org.jafer.interfaces.DatabeanFactory;
import org.jafer.interfaces.Present;
import org.jafer.interfaces.Queriable;
import org.jafer.interfaces.QueryBuilder;
import org.jafer.interfaces.Search;
import org.jafer.record.Field;
import org.w3c.dom.Node;

public class DatabeanManager
extends Databean
implements Present,
Queriable,
Search {
    private Hashtable databeanFactories;
    private ActiveBean[] activeBeans;
    private int recordCursor;
    private String recordSchema;
    private String mode;
    private int totalRecords = 0;
    private String name;
    private String[] allDatabases;

    public void setDatabeanFactories(Hashtable databeanFactories) {
        this.databeanFactories = databeanFactories;
    }

    public Hashtable getDatabeanFactories() {
        return this.databeanFactories;
    }

    public QueryBuilder newQueryBuilder() {
        return new org.jafer.query.QueryBuilder();
    }

    public void setRecordCursor(int recordCursor) throws JaferException {
        this.recordCursor = recordCursor;
    }

    public int getRecordCursor() {
        return this.recordCursor;
    }

    public void setRecordSchema(String recordSchema) {
        this.recordSchema = recordSchema;
    }

    public String getRecordSchema() {
        return this.recordSchema;
    }

    public void setDatabases(String database) {
        this.setDatabases(new String[]{database});
    }

    public void setDatabases(String[] databases) {
        if (databases[0].equals(this.getName())) {
            databases = this.allDatabases;
        }
        this.activeBeans = new ActiveBean[databases.length];
        for (int n = 0; n < databases.length; ++n) {
            if (!this.databeanFactories.containsKey(databases[n])) continue;
            this.activeBeans[n] = new ActiveBean();
            DatabeanFactory factory = (DatabeanFactory)this.databeanFactories.get(databases[n]);
            this.activeBeans[n].setDatabean(factory.getDatabean());
            this.activeBeans[n].setName(databases[n]);
        }
    }

    public String[] getDatabases() {
        String[] databases = new String[this.activeBeans.length];
        for (int n = 0; n < this.activeBeans.length; ++n) {
            databases[n] = this.activeBeans[n].getName();
        }
        return databases;
    }

    public int submitQuery(Node query) throws JaferException {
        this.totalRecords = 0;
        for (int n = 0; n < this.activeBeans.length; ++n) {
            if (this.activeBeans[n].getDatabean() == null) continue;
            this.activeBeans[n].setQuery(query);
            this.activeBeans[n].start();
        }
        int currentRecord = 1;
        for (int n = 0; n < this.activeBeans.length; ++n) {
            if (this.activeBeans[n].getDatabean() == null) continue;
            while (this.activeBeans[n].isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            int rec = ((Search)this.activeBeans[n].getDatabean()).getNumberOfResults();
            if (rec <= 0) continue;
            this.activeBeans[n].setLimits(currentRecord, currentRecord + rec - 1);
            currentRecord += rec;
            this.totalRecords += rec;
            if (this.mode.equalsIgnoreCase("serial")) break;
        }
        return this.totalRecords;
    }

    public int getNumberOfResults() {
        return this.totalRecords;
    }

    public Field getCurrentRecord() throws JaferException {
        for (int n = 0; n < this.activeBeans.length; ++n) {
            if (this.activeBeans[n].getDatabean() == null || !this.activeBeans[n].containsRecord(this.recordCursor)) continue;
            return this.activeBeans[n].getRecord(this.recordCursor, this.recordSchema);
        }
        throw new JaferException("Out of range thingy!!");
    }

    public String getCurrentDatabase() throws JaferException {
        for (int n = 0; n < this.activeBeans.length; ++n) {
            if (this.activeBeans[n].getDatabean() == null || !this.activeBeans[n].containsRecord(this.recordCursor)) continue;
            return this.activeBeans[n].getName();
        }
        throw new JaferException("Out of range thingy!!");
    }

    public void setCheckRecordFormat(boolean checkRecordFormat) {
        throw new UnsupportedOperationException("Method setCheckRecordFormat() not yet implemented.");
    }

    public boolean isCheckRecordFormat() {
        throw new UnsupportedOperationException("Method isCheckRecordFormat() not yet implemented.");
    }

    public void setElementSpec(String elementSpec) {
        throw new UnsupportedOperationException("Method setElementSpec() not yet implemented.");
    }

    public String getElementSpec() {
        throw new UnsupportedOperationException("Method getElementSpec() not yet implemented.");
    }

    public void setResultSetName(String resultSetName) {
        throw new UnsupportedOperationException("Method setResultSetName() not yet implemented.");
    }

    public String getResultSetName() {
        throw new UnsupportedOperationException("Method getResultSetName() not yet implemented.");
    }

    public void setSearchProfile(String searchProfile) {
        throw new UnsupportedOperationException("Method setSearchProfile() not yet implemented.");
    }

    public String getSearchProfile() {
        throw new UnsupportedOperationException("Method getSearchProfile() not yet implemented.");
    }

    public void setParseQuery(boolean parseQuery) {
        throw new UnsupportedOperationException("Method setParseQuery() not yet implemented.");
    }

    public boolean isParseQuery() {
        throw new UnsupportedOperationException("Method isParseQuery() not yet implemented.");
    }

    public void saveQuery(String file) throws JaferException {
        throw new UnsupportedOperationException("Method saveQuery() not yet implemented.");
    }

    public Node getQuery() {
        throw new UnsupportedOperationException("Method getQuery() not yet implemented.");
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAllDatabases(String[] allDatabases) {
        this.allDatabases = allDatabases;
    }

    public String[] getAllDatabases() {
        return this.allDatabases;
    }
}

