/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.record;

import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.BEREncoding;
import org.jafer.conf.Config;
import org.jafer.record.RecordException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import z3950.v3.DefaultDiagFormat;

public class DataObject {
    private String dbName;
    private String schema;
    private BEREncoding ber;
    public Node root;
    private int[] syntax;

    public DataObject() {
    }

    public DataObject(String dbName, BEREncoding ber) {
        this.dbName = dbName;
        this.ber = ber;
    }

    public DataObject(String dbName, Node root) {
        this.dbName = dbName;
        this.root = root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] getRecordSyntax() throws RecordException {
        if (this.syntax != null) {
            return this.syntax;
        }
        if (this.root != null) {
            if (!((Element)this.root).hasAttribute("syntax")) throw new RecordException("Syntax attribute not found in XMLRecord root");
            this.syntax = Config.convertSyntax((String)((Element)this.root).getAttribute("syntax"));
            return this.syntax;
        }
        if (this.ber == null) throw new RecordException("NULL recordSyntax");
        try {
            ASN1External asn1External = new ASN1External(this.ber, true);
            this.syntax = asn1External.s_direct_reference.get();
            return this.syntax;
        }
        catch (ASN1Exception e1) {
            try {
                DefaultDiagFormat defaultDiagFormat = new DefaultDiagFormat(this.ber, true);
                this.syntax = defaultDiagFormat.s_diagnosticSetId.get();
                return this.syntax;
            }
            catch (ASN1Exception e2) {
                throw new RecordException("ASN1Exception processing record; " + e2.toString(), (Throwable)e2);
            }
        }
    }

    public String getRecordSchema() throws RecordException {
        if (this.root == null) {
            throw new RecordException("XMLRecord root is NULL");
        }
        if (((Element)this.root).hasAttribute("schema")) {
            return ((Element)this.root).getAttribute("schema");
        }
        throw new RecordException("schema attribute not found in XMLRecord root");
    }

    public BEREncoding getBER() throws RecordException {
        return this.ber;
    }

    public Node getXML(Document document) throws RecordException {
        if (this.root == null) {
            throw new RecordException("XMLRecord root is NULL");
        }
        if (document == null) {
            throw new RecordException("DOM Document is NULL");
        }
        if (this.root.getOwnerDocument() == null) {
            return document.importNode(this.root, true);
        }
        if (this.root.getOwnerDocument() == document) {
            return this.root;
        }
        return document.importNode(this.root, true);
    }

    public String getDatabaseName() {
        return this.dbName;
    }
}

