/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.record;

import java.io.CharArrayWriter;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.jafer.util.xml.DOMFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class MARC8Unicode {
    public static final char UNICODE_UNKNOWN = (char)Integer.parseInt("FFFD", 16);
    public static final char MARC8_UNKNOWN = (char)Integer.parseInt("7C", 16);
    public static final int ESC = Integer.parseInt("1B", 16);
    public static final int ASCII = Integer.parseInt("73", 16);
    public static final int MULTI_BYTE = Integer.parseInt("24", 16);
    public static final int G0_PAGE_CHAR1 = Integer.parseInt("28", 16);
    public static final int G0_PAGE_CHAR2 = Integer.parseInt("2C", 16);
    public static final int G1_PAGE_CHAR1 = Integer.parseInt("29", 16);
    public static final int G1_PAGE_CHAR2 = Integer.parseInt("2D", 16);
    public static final int C0_LIMITS_LOWER = Integer.parseInt("00", 16);
    public static final int C0_LIMITS_UPPER = Integer.parseInt("20", 16);
    public static final int C1_LIMITS_LOWER = Integer.parseInt("80", 16);
    public static final int C1_LIMITS_UPPER = Integer.parseInt("9F", 16);
    public static final int G0_LIMITS_LOWER = Integer.parseInt("20", 16);
    public static final int G0_LIMITS_UPPER = Integer.parseInt("7E", 16);
    public static final int G1_LIMITS_LOWER = Integer.parseInt("A1", 16);
    public static final int G1_LIMITS_UPPER = Integer.parseInt("FE", 16);
    public static final int DIACRITIC_BASIC_HEBREW_LOWER = Integer.parseInt("40", 16);
    public static final int DIACRITIC_BASIC_HEBREW_UPPER = Integer.parseInt("4F", 16);
    public static final int DIACRITIC_BASIC_ARABIC_LOWER = Integer.parseInt("40", 16);
    public static final int DIACRITIC_BASIC_ARABIC_UPPER = Integer.parseInt("7E", 16);
    public static final int DIACRITIC_EXTENDED_ARABIC_LOWER = Integer.parseInt("F0", 16);
    public static final int DIACRITIC_EXTENDED_ARABIC_UPPER = Integer.parseInt("FE", 16);
    public static final int DIACRITIC_BASIC_GREEK_LOWER = Integer.parseInt("21", 16);
    public static final int DIACRITIC_BASIC_GREEK_UPPER = Integer.parseInt("2F", 16);
    public static final int DIACRITIC_ANSEL_LOWER = Integer.parseInt("E0", 16);
    public static final int DIACRITIC_ANSEL_UPPER = Integer.parseInt("FE", 16);
    public static final String SUBSCRIPT = "62";
    public static final String GREEK_SYMBOL = "67";
    public static final String SUPERSCRIPT = "70";
    public static final String ASCII_TYPE_1 = "73";
    public static final String EACC = "31";
    public static final String BASIC_HEBREW = "32";
    public static final String BASIC_ARABIC = "33";
    public static final String EXTENDED_ARABIC = "34";
    public static final String ASCII_TYPE_2 = "42";
    public static final String BASIC_CYRILLIC = "4E";
    public static final String EXTENDED_CYRILLIC = "51";
    public static final String BASIC_GREEK = "53";
    public static final String ANSEL = "ANSEL";
    private static final String CONTROL = "CONTROLFUNCTION";
    private boolean esc = false;
    private boolean multiByte = false;
    private boolean pageG0 = false;
    private boolean pageG1 = false;
    private static Hashtable characterSetsMap;
    private static Hashtable marcKeyCharacterSets;
    private static Hashtable unicodeKeyCharacterSets;
    private static Logger logger;
    private final char marc8Unknown;
    private final char unicodeUnknown;
    private String G0PageId;
    private String G1PageId;
    private String currentG0PageId;
    private String currentG1PageId;
    private String controlPageId;
    private Hashtable G0Page;
    private Hashtable G1Page;
    private Hashtable controlPage;
    private Vector lookUpList;

    public MARC8Unicode() {
        this.marc8Unknown = MARC8_UNKNOWN;
        this.unicodeUnknown = UNICODE_UNKNOWN;
        this.buildLookUpList();
        try {
            this.setControlPage("CONTROLFUNCTION");
        }
        catch (JaferException ex) {
            String message = "Cannot load controlFunction characterSet: org/jafer/conf/characterSets/characterSets.xml";
            logger.warn(message, (Throwable)ex);
            System.exit(-1);
        }
    }

    public MARC8Unicode(char marc8Unknown, char unicodeUnknown) {
        this.marc8Unknown = marc8Unknown;
        this.unicodeUnknown = unicodeUnknown;
        this.buildLookUpList();
        try {
            this.setControlPage("CONTROLFUNCTION");
        }
        catch (JaferException ex) {
            String message = "Cannot load controlFunction characterSet: org/jafer/conf/characterSets/characterSets.xml";
            logger.warn(message, (Throwable)ex);
            System.exit(-1);
        }
    }

    public String toMARC8(String unicode) throws JaferException {
        StringBuffer out = new StringBuffer();
        StringBuffer diac = new StringBuffer();
        StringBuffer multi = new StringBuffer();
        this.setCurrentG0PageId("73");
        this.setCurrentG1PageId("ANSEL");
        for (int n = 0; n < unicode.length(); ++n) {
            char[] c = this.getMARC8Chars((int)unicode.charAt(n));
            if (this.isDiacritic((int)c[0]) && c.length == 1) {
                diac.append(c[0]);
                continue;
            }
            if (!this.isBufferEmpty(diac)) {
                diac = this.emptyBuffer(diac, out, -1);
            }
            if (this.isNewPage()) {
                out.append(this.getPageESCSequence());
            }
            out.append(c);
        }
        if (!this.isBufferEmpty(diac)) {
            this.emptyBuffer(diac, out, -1);
        }
        this.setG0PageId("73");
        this.setPageG0(true);
        if (this.isNewPage()) {
            out.append(this.getPageESCSequence());
        }
        return out.toString();
    }

    public String toUnicode(String marc8) throws JaferException {
        StringBuffer out = new StringBuffer();
        StringBuffer diac = new StringBuffer();
        StringBuffer multi = new StringBuffer();
        this.setG0Page("73");
        this.setG1Page("ANSEL");
        this.setMultiByte(false);
        char c = '\u0000';
        for (int n = 0; n < marc8.length(); ++n) {
            c = marc8.charAt(n);
            if (this.isESCChar((int)c)) {
                this.setESC(true);
                this.setPageG0(false);
                this.setPageG1(false);
                this.setMultiByte(false);
                continue;
            }
            if (this.isESC()) {
                if (this.isMultiByte()) {
                    if (this.isPageG0()) {
                        this.setG0Page((int)c);
                        continue;
                    }
                    if (this.isPageG1()) {
                        this.setG1Page((int)c);
                        continue;
                    }
                    if (this.isG1PageChar((int)c)) {
                        this.setPageG1(true);
                        continue;
                    }
                    if (this.isG0PageChar((int)c)) {
                        this.setPageG0(true);
                        continue;
                    }
                    this.setG0Page((int)c);
                    continue;
                }
                if (this.isPageG0()) {
                    this.setG0Page((int)c);
                    continue;
                }
                if (this.isPageG1()) {
                    this.setG1Page((int)c);
                    continue;
                }
                if (this.isMultiByteChar((int)c)) {
                    this.setMultiByte(true);
                    continue;
                }
                if (this.isG0PageChar((int)c)) {
                    this.setPageG0(true);
                    continue;
                }
                if (this.isG1PageChar((int)c)) {
                    this.setPageG1(true);
                    continue;
                }
                this.setG0Page((int)c);
                continue;
            }
            if (this.isMultiByte()) {
                multi = this.appendMultiByte((int)c, multi, out);
                continue;
            }
            if (this.isDiacritic((int)c)) {
                diac.append(this.getUnicodeCharacter((int)c));
                continue;
            }
            out.append(this.getUnicodeCharacter((int)c));
            if (this.isBufferEmpty(diac)) continue;
            diac = this.emptyBuffer(diac, out, 0);
        }
        return out.toString();
    }

    private static void loadCharacterSetsMap() throws JaferException {
        String file;
        Element e;
        characterSetsMap = new Hashtable();
        Document document = Config.getCharacterSetsMap();
        NodeList list = Config.selectNodeList((Node)document, (String)"characterSets/graphicCharacterSet");
        if (list.getLength() == 0) {
            throw new JaferException("graphicCharacterSet node not found");
        }
        for (int i = 0; i < list.getLength(); ++i) {
            e = (Element)list.item(i);
            String id = e.getAttribute("id").toUpperCase();
            file = e.getAttribute("file");
            characterSetsMap.put(id, file);
        }
        e = (Element)Config.selectSingleNode((Node)document, (String)"characterSets/controlFunctionSet");
        if (e == null) {
            throw new JaferException("controlFunctionSet node not found");
        }
        file = e.getAttribute("file");
        characterSetsMap.put("CONTROLFUNCTION", file);
    }

    private Hashtable getCharacterSet(String key, boolean marcKey) throws JaferException {
        if (!characterSetsMap.containsKey(key)) {
            String message = "Error looking up characterSet - " + key + "(HEX) not recognised as characterSet code";
            logger.warn(message);
            throw new JaferException(message);
        }
        Hashtable<Object, Object> characterSet = new Hashtable<Object, Object>();
        String path = (String)characterSetsMap.get(key);
        String message = "loading CharacterSet " + key + "; path: " + path;
        logger.debug(message);
        Document document = DOMFactory.parse((InputStream)Config.getResourceAsStream((String)path));
        NodeList list = Config.selectNodeList((Node)document, (String)"characterSet/character");
        Character marc = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Character unicode;
            Element e = (Element)list.item(i);
            if (key.equals("31")) {
                if (e.hasAttribute("eacc") && e.hasAttribute("unicode")) {
                    String eacc = e.getAttribute("eacc").toUpperCase();
                    unicode = new Character((char)Integer.parseInt(e.getAttribute("unicode").toUpperCase(), 16));
                    if (marcKey) {
                        characterSet.put(eacc, unicode);
                        continue;
                    }
                    characterSet.put(unicode, eacc);
                    continue;
                }
                message = "Invalid node (line " + (i + 2) + ") in EACC characterSet " + path;
                logger.warn(message);
                throw new JaferException(message);
            }
            if (e.hasAttribute("marc") && e.hasAttribute("unicode")) {
                marc = new Character((char)Integer.parseInt(e.getAttribute("marc").toUpperCase(), 16));
                unicode = new Character((char)Integer.parseInt(e.getAttribute("unicode").toUpperCase(), 16));
                if (marcKey) {
                    characterSet.put(marc, unicode);
                    continue;
                }
                characterSet.put(unicode, marc);
                continue;
            }
            message = "Invalid node (line " + (i + 2) + ") in characterSet " + path;
            logger.warn(message);
            throw new JaferException(message);
        }
        Enumeration en = characterSetsMap.keys();
        while (en.hasMoreElements()) {
            String currentKey = (String)en.nextElement();
            if (!characterSetsMap.get(currentKey).equals(characterSetsMap.get(key))) continue;
            if (marcKey) {
                marcKeyCharacterSets.put(currentKey, characterSet);
                continue;
            }
            unicodeKeyCharacterSets.put(currentKey, characterSet);
        }
        return characterSet;
    }

    private void setControlPage(String key) throws JaferException {
        this.controlPage = this.getPage(key, true);
        this.setControlPageId(key);
    }

    private void setG0Page(String key) throws JaferException {
        this.G0Page = this.getPage(key, true);
        this.setG0PageId(key);
        this.setESC(false);
    }

    private void setG1Page(String key) throws JaferException {
        this.G1Page = this.getPage(key, true);
        this.setG1PageId(key);
        this.setESC(false);
    }

    private void setG0Page(int c) throws JaferException {
        String key = new String(Integer.toHexString(c));
        this.G0Page = this.getPage(key, true);
        this.setG0PageId(key);
        this.setESC(false);
    }

    private void setG1Page(int c) throws JaferException {
        String key = new String(Integer.toHexString(c));
        this.G1Page = this.getPage(key, true);
        this.setG1PageId(key);
        this.setESC(false);
    }

    private Hashtable getPage(String key, boolean marcKey) throws JaferException {
        key = key.toUpperCase();
        if (marcKey) {
            if (marcKeyCharacterSets.containsKey(key)) {
                return (Hashtable)marcKeyCharacterSets.get(key);
            }
        } else if (unicodeKeyCharacterSets.containsKey(key)) {
            return (Hashtable)unicodeKeyCharacterSets.get(key);
        }
        return this.getCharacterSet(key, marcKey);
    }

    private Hashtable getControlPage() {
        return this.controlPage;
    }

    private Hashtable getG0Page() {
        return this.G0Page;
    }

    private Hashtable getG1Page() {
        return this.G1Page;
    }

    private void setControlPageId(String id) {
        this.controlPageId = id;
    }

    private void setG0PageId(String id) {
        this.G0PageId = id;
    }

    private void setCurrentG0PageId(String id) {
        this.currentG0PageId = id;
    }

    private void setG1PageId(String id) {
        this.G1PageId = id;
    }

    private void setCurrentG1PageId(String id) {
        this.currentG1PageId = id;
    }

    private String getPageESCSequence() {
        if (this.isPageG1() && this.getG1PageId().equals("ANSEL")) {
            return "";
        }
        String id = null;
        CharArrayWriter out = new CharArrayWriter();
        out.write(ESC);
        if (this.isMultiByte()) {
            out.write(MULTI_BYTE);
        }
        if (this.isPageG0()) {
            id = this.getG0PageId();
            if (!(id.equals("67") || id.equals("73") || id.equals("62") || id.equals("70"))) {
                out.write(G0_PAGE_CHAR2);
            }
        } else if (this.isPageG1()) {
            id = this.getG1PageId();
            out.write(G1_PAGE_CHAR2);
        }
        out.write(Integer.parseInt(id, 16));
        return out.toString();
    }

    private String getControlPageId() {
        return this.controlPageId;
    }

    private String getG0PageId() {
        return this.G0PageId;
    }

    private String getCurrentG0PageId() {
        return this.currentG0PageId;
    }

    private String getG1PageId() {
        return this.G1PageId;
    }

    private String getCurrentG1PageId() {
        return this.currentG1PageId;
    }

    private String getPageId(int c) throws JaferException {
        String id = null;
        if (this.isG0Page(c)) {
            id = this.getG0PageId();
        } else if (this.isG1Page(c)) {
            id = this.getG1PageId();
        } else if (this.isControlFunction(c)) {
            id = this.getControlPageId();
        }
        if (id == null) {
            String message = "CharacterSet PageId is null";
            logger.warn(message);
            throw new JaferException(message);
        }
        return id;
    }

    private void setESC(boolean state) {
        this.esc = state;
    }

    private boolean isESC() {
        return this.esc;
    }

    private boolean isESCChar(int c) {
        return c == ESC;
    }

    private void setPageG0(boolean state) {
        this.pageG0 = state;
    }

    private boolean isPageG0() {
        return this.pageG0;
    }

    private boolean isG0PageChar(int c) {
        return c == G0_PAGE_CHAR1 || c == G0_PAGE_CHAR2;
    }

    private void setPageG1(boolean state) {
        this.pageG1 = state;
    }

    private boolean isPageG1() {
        return this.pageG1;
    }

    private boolean isG1PageChar(int c) {
        return c == G1_PAGE_CHAR1 || c == G1_PAGE_CHAR2;
    }

    private boolean isBufferEmpty(StringBuffer buffer) {
        return buffer.length() < 1;
    }

    private StringBuffer emptyBuffer(StringBuffer bufferIn, StringBuffer bufferOut, int offset) {
        bufferOut.insert(bufferOut.length() + offset, bufferIn.toString());
        return new StringBuffer();
    }

    private boolean isNewPage() {
        if (this.isPageG0()) {
            if (this.getG0PageId().equals(this.getCurrentG0PageId())) {
                return false;
            }
            this.setCurrentG0PageId(this.getG0PageId());
            return true;
        }
        if (this.isPageG1()) {
            if (this.getG1PageId().equals(this.getCurrentG1PageId())) {
                return false;
            }
            this.setCurrentG1PageId(this.getG1PageId());
            return true;
        }
        return false;
    }

    private boolean isMultiByteChar(int c) {
        return c == MULTI_BYTE;
    }

    private void setMultiByte(boolean state) {
        this.multiByte = state;
    }

    private boolean isMultiByte() {
        return this.multiByte;
    }

    private boolean isControlFunction(int c) {
        return this.isC0Page(c) || this.isC1Page(c);
    }

    private boolean isC0Page(int c) {
        return c >= C0_LIMITS_LOWER && c <= C0_LIMITS_UPPER;
    }

    private boolean isC1Page(int c) {
        return c >= C1_LIMITS_LOWER && c <= C1_LIMITS_UPPER;
    }

    private boolean isG0Page(int c) {
        return c >= G0_LIMITS_LOWER && c <= G0_LIMITS_UPPER;
    }

    private boolean isG1Page(int c) {
        return c >= G1_LIMITS_LOWER && c <= G1_LIMITS_UPPER;
    }

    private boolean isDiacritic(int c) throws JaferException {
        if (this.getPageId(c).equals("32")) {
            return c >= DIACRITIC_BASIC_HEBREW_LOWER && c <= DIACRITIC_BASIC_HEBREW_UPPER;
        }
        if (this.getPageId(c).equals("33")) {
            return c >= DIACRITIC_BASIC_ARABIC_LOWER && c <= DIACRITIC_BASIC_ARABIC_UPPER;
        }
        if (this.getPageId(c).equals("34")) {
            return c >= DIACRITIC_EXTENDED_ARABIC_LOWER && c <= DIACRITIC_EXTENDED_ARABIC_UPPER;
        }
        if (this.getPageId(c).equals("53")) {
            return c >= DIACRITIC_BASIC_GREEK_LOWER && c <= DIACRITIC_BASIC_GREEK_UPPER;
        }
        if (this.getPageId(c).equals("ANSEL")) {
            return c >= DIACRITIC_ANSEL_LOWER && c <= DIACRITIC_ANSEL_UPPER;
        }
        return false;
    }

    private Character getControlCharacter(int c) throws JaferException {
        Character key = new Character((char)c);
        if (this.isControlFunction(c) && this.getControlPage().containsKey(key)) {
            return (Character)this.getControlPage().get(key);
        }
        String message = key + " (" + Integer.toHexString(c).toUpperCase() + " HEX) is not a MARC8 control function character or was not found in controlFunction characterSet";
        logger.warn(message);
        throw new JaferException(message);
    }

    private char[] toMultiByte(String multiByteHexValue) {
        char[] c = new char[3];
        for (int n = 0; n < multiByteHexValue.length(); n += 2) {
            c[(n + 2) / 2 - 1] = (char)Integer.parseInt(multiByteHexValue.substring(n, n + 2), 16);
        }
        return c;
    }

    private StringBuffer appendMultiByte(int c, StringBuffer bufferIn, StringBuffer bufferOut) throws JaferException {
        bufferIn.append(Integer.toHexString(c));
        if (bufferIn.length() == 6) {
            bufferOut.append(this.getEACCCharacter(bufferIn.toString()));
            return new StringBuffer();
        }
        return bufferIn;
    }

    private Character getEACCCharacter(String hexValue) throws JaferException {
        hexValue = hexValue.toUpperCase();
        if (this.getG0PageId().equals("31") && this.getG0Page().containsKey(hexValue)) {
            return (Character)this.getG0Page().get(hexValue);
        }
        if (this.getG1PageId().equals("31") && this.getG1Page().containsKey(hexValue)) {
            return (Character)this.getG1Page().get(hexValue);
        }
        String message = "MARC multi-byte character (" + hexValue + " HEX) not found in EACC character set (characterSetId: 31)";
        logger.warn(message);
        return new Character(this.unicodeUnknown);
    }

    private Character getUnicodeCharacter(int c) throws JaferException {
        Character key = new Character((char)c);
        String id = null;
        if (this.isG0Page(c)) {
            id = this.getG0PageId();
            if (this.getG0Page().containsKey(key)) {
                return (Character)this.getG0Page().get(key);
            }
        } else if (this.isG1Page(c)) {
            id = this.getG1PageId();
            if (this.getG1Page().containsKey(key)) {
                return (Character)this.getG1Page().get(key);
            }
        }
        String message = "MARC character " + key + " (" + Integer.toHexString(c).toUpperCase() + " HEX) not found in characterSetId: " + id;
        logger.warn(message);
        return new Character(this.unicodeUnknown);
    }

    private char[] getMARC8Chars(int unicodeChar) throws JaferException {
        if (unicodeChar == this.unicodeUnknown) {
            return new char[]{this.marc8Unknown};
        }
        Character key = new Character((char)unicodeChar);
        Hashtable page = null;
        this.setPageG0(false);
        this.setPageG1(false);
        int i = 0;
        while (i < this.getLookUpList().size()) {
            String pageId = (String)this.getLookUpList().get(i++);
            page = this.getPage(pageId, false);
            if (!page.containsKey(key)) continue;
            this.moveToFront(pageId, this.getLookUpList());
            if (pageId.equals("31")) {
                char[] c = this.toMultiByte((String)page.get(key));
                this.setPageG0(true);
                this.setG0PageId(pageId);
                this.setMultiByte(true);
                return c;
            }
            char[] c = new char[]{((Character)page.get(key)).charValue()};
            if (this.isG0Page((int)c[0])) {
                this.setPageG0(true);
                if (characterSetsMap.get("73").equals(characterSetsMap.get(pageId))) {
                    this.setG0PageId("73");
                } else {
                    this.setG0PageId(pageId);
                }
            } else if (this.isG1Page((int)c[0])) {
                this.setPageG1(true);
                if (characterSetsMap.get("ANSEL").equals(characterSetsMap.get(pageId))) {
                    this.setG1PageId("ANSEL");
                } else {
                    this.setG1PageId(pageId);
                }
            }
            this.setMultiByte(false);
            return c;
        }
        String message = "UnicodeCharacter " + key + " (" + Integer.toHexString(unicodeChar).toUpperCase() + " HEX) not found";
        logger.warn(message);
        return new char[]{this.marc8Unknown};
    }

    private void buildLookUpList() {
        this.lookUpList = new Vector();
        this.lookUpList.add("73");
        Enumeration en = characterSetsMap.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            int i = 0;
            boolean inList = false;
            while (!inList && i < this.lookUpList.size()) {
                if (!characterSetsMap.get(key).equals(characterSetsMap.get(this.lookUpList.get(i++)))) continue;
                inList = true;
            }
            if (inList) continue;
            this.lookUpList.add(key);
        }
        if (this.lookUpList.contains("31")) {
            this.moveToBack("31", this.lookUpList);
        }
    }

    private Vector getLookUpList() {
        return this.lookUpList;
    }

    private void moveToFront(String pageId, Vector lookUpList) {
        lookUpList.remove(pageId);
        lookUpList.add(0, pageId);
    }

    private void moveToBack(String pageId, Vector lookUpList) {
        lookUpList.remove(pageId);
        lookUpList.add(pageId);
    }

    static {
        try {
            logger = LoggerFactory.getLogger((String)"org.jafer.record");
            MARC8Unicode.loadCharacterSetsMap();
            marcKeyCharacterSets = new Hashtable();
            unicodeKeyCharacterSets = new Hashtable();
        }
        catch (JaferException ex) {
            String message = "Cannot load characterSetsMap: org/jafer/conf/characterSets/characterSets.xml";
            logger.warn(message, (Throwable)ex);
            System.exit(-1);
        }
    }
}

