/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.record;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Templates;
import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.jafer.record.DataObject;
import org.jafer.record.MARCRecord;
import org.jafer.util.xml.DOMFactory;
import org.jafer.util.xml.XMLTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RecordFactory {
    private static Hashtable templatesMap;
    private static Hashtable fromSerializer;
    private static Hashtable toSerializer;
    private static Logger logger;
    String encoding;

    public RecordFactory(String encoding) {
        logger = LoggerFactory.getLogger((String)"org.jafer.record");
        templatesMap = new Hashtable();
        fromSerializer = new Hashtable();
        toSerializer = new Hashtable();
        templatesMap.put(Boolean.TRUE, fromSerializer);
        templatesMap.put(Boolean.FALSE, toSerializer);
        this.encoding = encoding;
    }

    public Object getBER(DataObject dataObject, Document document, int recNo) throws JaferException {
        logger.debug("RecordFactory", (Object)"public Node getXML(DataObject dataObject)");
        String dbName = "";
        try {
            int[] recordSyntax = dataObject.getRecordSyntax();
            String serializerSchema = Config.getRecordSerializerTargetSchema((String)Config.convertSyntax((int[])recordSyntax));
            dbName = dataObject.getDatabaseName();
            Class recordClass = this.getRecordClass(recordSyntax);
            String sourceSchema = dataObject.getRecordSchema();
            Node recordRoot = dataObject.getXML(document);
            Node recordNode = recordRoot.getFirstChild();
            recordRoot.removeChild(recordNode);
            recordNode = this.transformRecord(recordNode, recordSyntax, sourceSchema, false);
            recordNode = this.getRecordRoot(document, recordNode, recordSyntax, serializerSchema, dbName, recNo);
            String encoding = dataObject.root.getAttributes().getNamedItem("encoding").getNodeValue();
            MARCRecord recordObject = new MARCRecord(dbName, recordNode, encoding);
            return recordObject.getBER();
        }
        catch (Exception e) {
            String message = "Error generating BER from XML record";
            logger.warn(message + "; " + e.getMessage());
            throw new JaferException(message, (Throwable)e);
        }
    }

    public Object getXML(DataObject dataObject, Document document, String targetSchema, int recNo) throws JaferException {
        Node recordNode;
        String serializerSchema;
        int[] recordSyntax;
        logger.debug("RecordFactory", (Object)"public Element getXML(DataObject dataObject, Integer recNo)");
        String dbName = "";
        try {
            recordSyntax = dataObject.getRecordSyntax();
            serializerSchema = Config.getRecordSerializerTargetSchema((String)Config.convertSyntax((int[])recordSyntax));
            dbName = dataObject.getDatabaseName();
            Class recordClass = this.getRecordClass(recordSyntax);
            DataObject recordObject = this.getRecordObject(recordClass, new Object[]{dataObject.getDatabaseName(), dataObject.getBER()});
            ((MARCRecord)recordObject).setEncoding(this.encoding);
            recordNode = recordObject.getXML(document);
        }
        catch (JaferException e) {
            Node recordNode2 = DOMFactory.getExceptionNode((Document)document, (Throwable)e, (StackTraceElement[])e.getStackTrace(), (String)"Error generating XML from record");
            logger.warn(e.getMessage());
            return this.getRecordRoot(document, recordNode2, Config.convertSyntax((String)Config.getRecordSyntaxFromName((String)"JAFER")), "JaferException", dbName, recNo);
        }
        try {
            recordNode = this.transformRecord(recordNode, recordSyntax, targetSchema, true);
        }
        catch (JaferException e) {
            logger.debug("RecordFactory: cannot transform XMLRecord - use checkRecordFormat to identify XMLRecords that do not conform to requested format");
            return this.getRecordRoot(document, recordNode, recordSyntax, serializerSchema, dbName, recNo);
        }
        logger.debug("RecordFactory", (Object)"public Element getXML(DataObject dataObject, Integer recNo)");
        return this.getRecordRoot(document, recordNode, recordSyntax, targetSchema, dbName, recNo);
    }

    private Class getRecordClass(int[] recordSyntax) throws JaferException {
        Class<?> recordClass = null;
        try {
            String className = Config.getRecordSerializer((String)Config.convertSyntax((int[])recordSyntax));
            recordClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            String message = "RecordFactory (cannot locate Record class) " + e.toString();
            throw new JaferException(message, (Throwable)e);
        }
        return recordClass;
    }

    private DataObject getRecordObject(Class recordClass, Object[] initArgs) throws JaferException {
        int index;
        Constructor<?>[] constructors = recordClass.getConstructors();
        for (index = 0; index < constructors.length; ++index) {
            Class<?>[] paramTypes = constructors[index].getParameterTypes();
            int j = 0;
            while (paramTypes[j].isInstance(initArgs[j]) && ++j != paramTypes.length) {
            }
            if (j == paramTypes.length) break;
        }
        DataObject recordObject = null;
        try {
            recordObject = (DataObject)constructors[index].newInstance(initArgs);
        }
        catch (SecurityException e) {
            String message = "RecordFactory (cannot instantiate Record Object) " + e.toString();
            throw new JaferException(message, (Throwable)e);
        }
        catch (InstantiationException e) {
            String message = "RecordFactory (cannot instantiate Record Object) " + e.toString();
            throw new JaferException(message, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String message = "RecordFactory (cannot instantiate Record Object) " + e.toString();
            throw new JaferException(message, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String message = "RecordFactory (cannot instantiate Record Object) " + e.toString();
            throw new JaferException(message, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String message = "RecordFactory (cannot instantiate Record Object) " + e.toString();
            throw new JaferException(message, (Throwable)e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String message = "RecordFactory (cannot instantiate Record Object) " + e.toString();
            throw new JaferException(message, (Throwable)e);
        }
        return recordObject;
    }

    private Node transformRecord(Node recordNode, int[] recordSyntax, String requestedRecordSchema, boolean fromSerializer) throws JaferException {
        Hashtable map = (Hashtable)templatesMap.get(fromSerializer);
        Vector transforms = Config.getTransforms((boolean)fromSerializer, (String)Config.convertSyntax((int[])recordSyntax), (String)requestedRecordSchema);
        for (int i = 0; i < transforms.size(); ++i) {
            Templates template;
            String styleSheet = (String)transforms.get(i);
            if (!map.containsKey(styleSheet)) {
                try {
                    URL resource = this.getClass().getClassLoader().getResource(styleSheet);
                    template = XMLTransformer.createTemplate((URL)resource);
                    map.put(styleSheet, template);
                }
                catch (Exception e) {
                    throw new JaferException("Error creating template from styleSheet: " + styleSheet, (Throwable)e);
                }
            }
            template = (Templates)map.get(styleSheet);
            recordNode = XMLTransformer.transform((Node)recordNode, (Templates)template);
        }
        return recordNode;
    }

    private Element getRecordRoot(Document document, Node recordNode, int[] recordSyntax, String recordSchema, String dbName, int recNo) {
        Element recordRoot = document.createElement("record");
        recordRoot.appendChild(recordNode);
        recordRoot.setAttribute("syntax", Config.convertSyntax((int[])recordSyntax));
        recordRoot.setAttribute("schema", recordSchema);
        recordRoot.setAttribute("dbName", dbName);
        recordRoot.setAttribute("number", String.valueOf(recNo));
        return recordRoot;
    }
}

