/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.util.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.templates.OutputProperties;
import org.jafer.exception.JaferException;
import org.jafer.util.xml.XMLTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class XMLSerializer {
    private static Logger logger = LoggerFactory.getLogger((String)"org.jafer.util");

    public static void out(Node node, boolean omitXMLDeclaration, OutputStream stream) throws JaferException {
        Transformer transformer = XMLSerializer.getTransformer((Properties)XMLSerializer.getDefaultProperties((String)"xml", (boolean)omitXMLDeclaration));
        XMLTransformer.transform((Node)node, (Transformer)transformer, (OutputStream)stream);
    }

    public static void out(Node node, boolean omitXMLDeclaration, Writer writer) throws JaferException {
        Transformer transformer = XMLSerializer.getTransformer((Properties)XMLSerializer.getDefaultProperties((String)"xml", (boolean)omitXMLDeclaration));
        XMLTransformer.transform((Node)node, (Transformer)transformer, (Writer)writer);
    }

    public static void out(Node node, boolean omitXMLDeclaration, String filePath) throws JaferException {
        XMLSerializer.out((Node)node, (boolean)omitXMLDeclaration, (OutputStream)XMLSerializer.getFileOutputStream((String)filePath));
    }

    public static void out(Node node, String method, OutputStream stream) throws JaferException {
        Transformer transformer = XMLSerializer.getTransformer((Properties)XMLSerializer.getDefaultProperties((String)method));
        XMLTransformer.transform((Node)node, (Transformer)transformer, (OutputStream)stream);
    }

    public static void out(Node node, String method, Writer writer) throws JaferException {
        Transformer transformer = XMLSerializer.getTransformer((Properties)XMLSerializer.getDefaultProperties((String)method));
        XMLTransformer.transform((Node)node, (Transformer)transformer, (Writer)writer);
    }

    public static void out(Node node, String method, String filePath) throws JaferException {
        XMLSerializer.out((Node)node, (String)method, (OutputStream)XMLSerializer.getFileOutputStream((String)filePath));
    }

    public static void transformOutput(Node sourceNode, URL stylesheet, OutputStream stream) throws JaferException {
        Transformer transformer = XMLSerializer.getTransformer((URL)stylesheet);
        XMLTransformer.transform((Node)sourceNode, (Transformer)transformer, (OutputStream)stream);
    }

    public static void transformOutput(Node sourceNode, URL stylesheet, Writer writer) throws JaferException {
        Transformer transformer = XMLSerializer.getTransformer((URL)stylesheet);
        XMLTransformer.transform((Node)sourceNode, (Transformer)transformer, (Writer)writer);
    }

    public static void transformOutput(Node sourceNode, URL stylesheet, String filePath) throws JaferException {
        XMLSerializer.transformOutput((Node)sourceNode, (URL)stylesheet, (OutputStream)XMLSerializer.getFileOutputStream((String)filePath));
    }

    public static void transformOutput(Node sourceNode, URL stylesheet, Map parameters, OutputStream stream) throws JaferException {
        Transformer transformer = XMLSerializer.getTransformer((URL)stylesheet, (Map)parameters);
        XMLTransformer.transform((Node)sourceNode, (Transformer)transformer, (OutputStream)stream);
    }

    public static void transformOutput(Node sourceNode, URL stylesheet, Map parameters, Writer writer) throws JaferException {
        Transformer transformer = XMLSerializer.getTransformer((URL)stylesheet, (Map)parameters);
        XMLTransformer.transform((Node)sourceNode, (Transformer)transformer, (Writer)writer);
    }

    public static void transformOutput(Node sourceNode, URL stylesheet, Map parameters, String filePath) throws JaferException {
        XMLSerializer.transformOutput((Node)sourceNode, (URL)stylesheet, (Map)parameters, (OutputStream)XMLSerializer.getFileOutputStream((String)filePath));
    }

    public static Properties getDefaultProperties(String method) throws JaferException {
        if ((method = method.toLowerCase()).equals("xml") || method.equals("html") || method.equals("xhtml") || method.equals("text")) {
            return OutputProperties.getDefaultMethodProperties((String)method);
        }
        throw new JaferException("Method supplied must be \"xml\", \"html\", \"xhtml\", or \"text\"");
    }

    private static Properties getDefaultProperties(String method, boolean omitXMLDeclaration) throws JaferException {
        Properties properties = XMLSerializer.getDefaultProperties((String)method);
        if (omitXMLDeclaration) {
            properties.setProperty("omit-xml-declaration", "yes");
        }
        return properties;
    }

    private static Transformer getTransformer() throws JaferException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            String message = "XMLSerializer (Error in transformation/serialization)";
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
    }

    private static Transformer getTransformer(URL stylesheet) throws JaferException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(stylesheet.getFile()));
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            String message = "XMLSerializer (Error in transformation: " + stylesheet + ") " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
    }

    private static Transformer getTransformer(URL stylesheet, Map parameters) throws JaferException {
        Transformer transformer = XMLSerializer.getTransformer((URL)stylesheet);
        for (String param : parameters.keySet()) {
            transformer.setParameter(param, parameters.get(param));
        }
        return transformer;
    }

    private static Transformer getTransformer(Properties properties) throws JaferException {
        Transformer transformer = XMLSerializer.getTransformer();
        transformer.setOutputProperties(properties);
        return transformer;
    }

    private static FileOutputStream getFileOutputStream(String filePath) throws JaferException {
        try {
            return new FileOutputStream(filePath);
        }
        catch (IOException e) {
            String message = "Error in serializing output: (I/O error with path: " + filePath + ")";
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
    }
}

