/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.util.xml;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jafer.exception.JaferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class XMLTransformer {
    private static Logger logger = LoggerFactory.getLogger((String)"org.jafer.util");
    private static TransformerFactory tFactory = TransformerFactory.newInstance();

    public static Node transform(Node sourceNode, Transformer transformer) throws JaferException {
        logger.debug("XMLTransformer", (Object)"public static Node transform(Node sourceNode, Transformer transformer)");
        try {
            DOMSource domSource = new DOMSource(sourceNode);
            DOMResult domResult = new DOMResult(sourceNode.cloneNode(false));
            transformer.transform(domSource, domResult);
            Node node = domResult.getNode().getFirstChild();
            return node;
        }
        catch (TransformerException e) {
            String message = "XMLTransformer; cannot transform node. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String message = "XMLTransformer; cannot transform node. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        catch (NullPointerException e) {
            String message = "XMLTransformer; cannot transform node. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        finally {
            logger.debug("XMLTransformer", (Object)"public static Node transform(Node sourceNode, Transformer transformer)");
        }
    }

    public static void transform(Node sourceNode, Transformer transformer, OutputStream stream) throws JaferException {
        logger.debug("XMLTransformer", (Object)"public static void transform(Node sourceNode, Transformer transformer, OutputStream stream");
        try {
            DOMSource domSource = new DOMSource(sourceNode);
            StreamResult streamResult = new StreamResult(stream);
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            String message = "XMLTransformer; cannot transform node. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String message = "XMLTransformer; cannot transform node. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        catch (NullPointerException e) {
            String message = "XMLTransformer; cannot transform node. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        finally {
            logger.debug("XMLTransformer", (Object)"public static void transform(Node sourceNode, Transformer transformer, OutputStream stream");
        }
    }

    public static void transform(Node sourceNode, Transformer transformer, Writer writer) throws JaferException {
        logger.debug("XMLTransformer", (Object)"public static void transform(Node sourceNode, Transformer transformer, Writer writer)");
        try {
            DOMSource domSource = new DOMSource(sourceNode);
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            String message = "XMLTransformer; cannot transform node. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String message = "XMLTransformer; cannot transform node. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        catch (NullPointerException e) {
            String message = "XMLTransformer; cannot transform node. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        finally {
            logger.debug("XMLTransformer", (Object)"public static void transform(Node sourceNode, Transformer transformer, Writer writer)");
        }
    }

    public static Node transform(Node sourceNode, Templates template) throws JaferException {
        logger.debug("XMLTransformer", (Object)"public static Node transform(Node sourceNode, Templates template)");
        try {
            Node node = XMLTransformer.transform((Node)sourceNode, (Transformer)template.newTransformer());
            return node;
        }
        catch (TransformerConfigurationException e) {
            String message = "XMLTransformer; cannot create transformer object from template. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        finally {
            logger.debug("XMLTransformer", (Object)"public static Node transform(Node sourceNode, Templates template)");
        }
    }

    public static Node transform(Node sourceNode, InputStream is) throws JaferException {
        logger.debug("XMLTransformer", (Object)"public static Node transform(Node sourceNode, String path)");
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer(new StreamSource(is));
            Node node = XMLTransformer.transform((Node)sourceNode, (Transformer)transformer);
            return node;
        }
        catch (TransformerConfigurationException e) {
            String message = "XMLTransformer; cannot create transformer object from styleSheet " + is.toString() + ". " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        catch (NullPointerException e) {
            String message = "XMLTransformer; cannot transform node, NULL template. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        finally {
            logger.debug("XMLTransformer", (Object)"public static Node transform(Node sourceNode, String path)");
        }
    }

    public static Node transform(Map paramMap, Node sourceNode, String path) throws JaferException {
        logger.debug("XMLTransformer", (Object)"public static Node transform(Map paramMap, Node sourceNode, String path)");
        Transformer transformer = null;
        try {
            Object param2;
            transformer = tFactory.newTransformer(new StreamSource(path));
            for (Object param2 : paramMap.keySet()) {
                String value = (String)paramMap.get(param2);
                transformer.setParameter((String)param2, value);
            }
            param2 = XMLTransformer.transform((Node)sourceNode, (Transformer)transformer);
            return param2;
        }
        catch (TransformerConfigurationException e) {
            String message = "XMLTransformer; cannot create transformer object from stylesheet " + path + ". " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        catch (NullPointerException e) {
            String message = "XMLTransformer; cannot transform node. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        finally {
            logger.debug("XMLTransformer", (Object)"public static Node transform(Map paramMap, Node sourceNode, String path)");
        }
    }

    public static Node transform(Map paramMap, Node sourceNode, URL resource) throws JaferException {
        logger.debug("XMLTransformer", (Object)"public static Node transform(Map paramMap, Node sourceNode, URL resource)");
        try {
            Node node = XMLTransformer.transform((Map)paramMap, (Node)sourceNode, (String)resource.getFile());
            return node;
        }
        catch (NullPointerException e) {
            String message = "XMLTransformer; cannot transform node, NULL resource. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        finally {
            logger.debug("XMLTransformer", (Object)"public static Node transform(Map paramMap, Node sourceNode, URL resource)");
        }
    }

    public static Node transform(Map paramMap, Node sourceNode, File file) throws JaferException {
        logger.debug("XMLTransformer", (Object)"public static Node transform(Map paramMap, Node sourceNode, File file)");
        try {
            Node node = XMLTransformer.transform((Map)paramMap, (Node)sourceNode, (String)file.getPath());
            return node;
        }
        catch (NullPointerException e) {
            String message = "XMLTransformer; cannot transform node, NULL file. " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        finally {
            logger.debug("XMLTransformer", (Object)"public static Node transform(Map paramMap, Node sourceNode, File file)");
        }
    }

    public static Templates createTemplate(String path) throws JaferException {
        logger.debug("XMLTransformer", (Object)"public static Templates createTemplate(String path)");
        try {
            Templates templates = tFactory.newTemplates(new StreamSource(path));
            return templates;
        }
        catch (TransformerConfigurationException e) {
            String message = "XMLTransformer; cannot create template using stylesheet: " + path + ". " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        finally {
            logger.debug("XMLTransformer", (Object)"public static Templates createTemplate(String path)");
        }
    }

    public static Templates createTemplate(URL resource) throws JaferException {
        return XMLTransformer.createTemplate((String)resource.getFile());
    }

    public static Templates createTemplate(File file) throws JaferException {
        return XMLTransformer.createTemplate((String)file.getPath());
    }

    static {
        if (!tFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature") || !tFactory.getFeature("http://javax.xml.transform.dom.DOMResult/feature")) {
            String message = "DOM node processing not supported - cannot continue!";
            logger.warn(message);
            System.exit(-1);
        }
    }
}

