/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zclient;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.jafer.exception.JaferException;
import org.jafer.util.ConnectionException;
import org.jafer.util.PDUDriver;
import org.jafer.zclient.operations.Init;
import org.jafer.zclient.operations.Present;
import org.jafer.zclient.operations.PresentException;
import org.jafer.zclient.operations.Scan;
import org.jafer.zclient.operations.Search;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ClientSession {
    private static Logger logger;
    private static int sessionId;
    private final String host;
    private final int port;
    private final int timeout;
    private PDUDriver pduDriver;
    private Socket socket;
    private String name;
    private String group;
    private String username;
    private String password;
    private String targetInfo = "Z39.50 server";
    private int targetVersion = 0;

    public ClientSession(String host, int port, int timeout) {
        logger = LoggerFactory.getLogger((String)"org.jafer.zclient");
        ++sessionId;
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    private void connect() throws ConnectionException {
        Object message = "";
        try {
            int CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(this.host, this.port), CONNECT_TIMEOUT);
            this.setPDUDriver(new PDUDriver(this.getName(), socket, this.timeout));
            message = this.getName() + " connected to " + this.host + " on port " + this.port;
            logger.debug((String)message);
        }
        catch (UnknownHostException e) {
            message = this.getName() + " error starting session: Unknown host " + this.host;
            logger.warn((String)message);
            throw new ConnectionException((String)message, (Throwable)e);
        }
        catch (SecurityException e) {
            message = this.getName() + " error starting session: Security error (" + e.toString() + ")";
            logger.warn((String)message);
            throw new ConnectionException((String)message, (Throwable)e);
        }
        catch (NullPointerException e) {
            message = this.getName() + " error starting session: host (" + this.host + ") or port (" + this.port + ") not found";
            logger.warn((String)message);
            throw new ConnectionException((String)message, (Throwable)e);
        }
        catch (IOException e) {
            message = this.getName() + " error starting session: IOException (" + e.toString() + ")";
            logger.warn((String)message);
            throw new ConnectionException((String)message, (Throwable)e);
        }
    }

    public void init(String group, String username, String password) throws ConnectionException {
        this.setName(group, username, password);
        this.connect();
        Init init = new Init(this);
        try {
            init.init(this.group, this.username, this.password);
            this.targetVersion = init.getTargetVersion();
            this.targetInfo = init.getTargetInfo();
            logger.info(this.getName() + " established with host on port " + this.port + "\n" + this.targetInfo);
        }
        catch (ConnectionException e) {
            logger.warn(this.getName() + " " + e.getMessage() + " - cannot connect to target " + init.getTargetInfo());
            throw e;
        }
    }

    public void close() {
        try {
            if (this.targetVersion > 2 || this.targetVersion == 0) {
                this.pduDriver.initClose(0);
            }
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
            logger.info(this.getName() + " closed connection to " + this.targetInfo);
        }
        catch (Exception e) {
            logger.warn(this.getName() + " error attempting to close session (" + e.toString() + ")");
        }
    }

    public int search(Node domQuery, String[] databases, String resultSetName) throws JaferException, ConnectionException {
        Search search = new Search(this);
        return search.search(domQuery, databases, resultSetName);
    }

    public int search(Object rpnQueryObject, String[] databases, String resultSetName) throws JaferException, ConnectionException {
        Search search = new Search(this);
        return search.search(rpnQueryObject, databases, resultSetName);
    }

    public Vector present(int nRecord, int nRecords, int[] recordOID, String eSpec, String resultSetName) throws PresentException, ConnectionException {
        Present present = new Present(this);
        Vector retval = present.present(nRecord, nRecords, recordOID, eSpec, resultSetName);
        return retval;
    }

    public Vector scan(String[] databases, int nTerms, int step, int position, Node term) throws JaferException, ConnectionException {
        Scan scan = new Scan(this);
        return scan.scan(databases, nTerms, step, position, term);
    }

    public Vector scan(String[] databases, int nTerms, int step, int position, Object termObject) throws JaferException, ConnectionException {
        Scan scan = new Scan(this);
        return scan.scan(databases, nTerms, step, position, termObject);
    }

    public PDUDriver getPDUDriver() {
        return this.pduDriver;
    }

    public void setPDUDriver(PDUDriver pduDriver) {
        this.pduDriver = pduDriver;
    }

    private void setName(String group, String username, String password) {
        this.name = "session-" + sessionId + " [";
        if (group == null && username == null && password == null) {
            this.name = this.name + "anonymous";
        } else {
            if (group != null) {
                this.name = this.name + group;
            }
            if (username != null) {
                this.name = this.name + "." + username;
            }
            if (password != null) {
                this.name = this.name + ".password";
            }
        }
        this.name = this.name + "]";
        this.group = group;
        this.username = username;
        this.password = password;
    }

    public int getId() {
        return sessionId;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    static {
        sessionId = 0;
    }
}

