/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zserver;

import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jafer.exception.JaferException;
import org.jafer.interfaces.Authenticate;
import org.jafer.interfaces.Databean;
import org.jafer.interfaces.DatabeanFactory;
import org.jafer.util.ConnectionException;
import org.jafer.util.PDUDriver;
import org.jafer.zserver.ZServerThread;
import org.jafer.zserver.operations.Delete;
import org.jafer.zserver.operations.Init;
import org.jafer.zserver.operations.Present;
import org.jafer.zserver.operations.Scan;
import org.jafer.zserver.operations.Search;
import org.jafer.zserver.operations.Sort;
import org.jafer.zserver.util.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import z3950.v3.PDU;

public class Session
extends ZServerThread {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    private Socket socket;
    private final DatabeanFactory databeanFactory;
    private PDUDriver pduDriver;
    private final Authenticate authenticate;
    private Hashtable databeans = new Hashtable();
    private Hashtable locks = new Hashtable();
    private int preferredMessageSize;
    private int exceptionalRecordSize;
    private int clientVersion;
    private String clientInfo;
    private boolean concurrent;
    private boolean authenticated;
    private String encoding;

    public Session(Socket socket, int timeout, DatabeanFactory databeanFactory, Authenticate authenticate) throws IOException {
        super("session");
        this.socket = socket;
        this.databeanFactory = databeanFactory;
        this.authenticate = authenticate;
        try {
            if (timeout < 0) {
                timeout = 900000;
            }
            this.setPDUDriver(new PDUDriver(this.getName(), socket, timeout));
        }
        catch (IOException e) {
            logger.warn(this.getName() + " Error starting session: IOException (" + e.toString() + ")");
            throw e;
        }
    }

    public void run() {
        this.setStopping(false);
        this.setStopped(false);
        this.setThreads(new Vector());
        this.setStartTime(System.currentTimeMillis() / 1000L);
        PDU pduRequest = null;
        while (!this.isStopping()) {
            try {
                pduRequest = this.getPDUDriver().getPDU();
                this.purgeThreads();
                if (pduRequest.c_initRequest != null) {
                    this.startThread((Thread)new Init(this, pduRequest));
                    continue;
                }
                if (pduRequest.c_searchRequest != null && this.getAuthenticated()) {
                    this.startThread((Thread)new Search(this, pduRequest));
                    continue;
                }
                if (pduRequest.c_deleteResultSetRequest != null && this.getAuthenticated()) {
                    this.startThread((Thread)new Delete(this, pduRequest));
                    continue;
                }
                if (pduRequest.c_presentRequest != null && this.getAuthenticated()) {
                    this.startThread((Thread)new Present(this, pduRequest));
                    continue;
                }
                if (pduRequest.c_scanRequest != null && this.getAuthenticated()) {
                    this.startThread((Thread)new Scan(this, pduRequest));
                    continue;
                }
                if (pduRequest.c_sortRequest != null && this.getAuthenticated()) {
                    this.startThread((Thread)new Sort(this, pduRequest));
                    continue;
                }
                if (pduRequest.c_close != null) {
                    this.getPDUDriver().respClose(pduRequest);
                } else if (!this.getAuthenticated()) {
                    this.getPDUDriver().initClose(5);
                } else {
                    this.getPDUDriver().initClose(6);
                }
                this.halt(10000L);
            }
            catch (ConnectionException ex) {
                logger.error(this.getName(), (Throwable)ex);
                this.close();
            }
        }
    }

    public void close() {
        if (!this.isStopped()) {
            logger.debug(this.getName() + " close...");
            this.cleanUpDatabeans();
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException ex) {
                logger.debug(this.getName() + " socket already closed");
            }
            finally {
                this.socket = null;
                this.setStopping(true);
                this.setStopped(true);
                this.setThreads(null);
                logger.debug(this.getName() + " association closed");
            }
        }
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public String getClientAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public void setAuthenticated(String user, String group, String password) {
        this.authenticated = this.authenticate == null ? true : this.authenticate.authenticate(user, group, password, this.getClientAddress());
    }

    public boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setPreferredMessageSize(int preferredMessageSize) {
        this.preferredMessageSize = preferredMessageSize;
    }

    public int getPreferredMessageSize() {
        return this.preferredMessageSize;
    }

    public void setExceptionalRecordSize(int exceptionalRecordSize) {
        this.exceptionalRecordSize = exceptionalRecordSize;
    }

    public int getExceptionalRecordSize() {
        return this.exceptionalRecordSize;
    }

    public void setClientVersion(int clientVersion) {
        this.clientVersion = clientVersion;
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    public void setClientInfo(String clientInfo) {
        this.clientInfo = clientInfo;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public void setPDUDriver(PDUDriver pduDriver) {
        this.pduDriver = pduDriver;
    }

    public PDUDriver getPDUDriver() {
        return this.pduDriver;
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
        if (concurrent) {
            logger.debug(this.getName() + " running in concurrent mode");
        }
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public boolean containsDatabean(String name) {
        return this.databeans.containsKey(name);
    }

    public Databean getDatabean() {
        return this.databeanFactory.getDatabean();
    }

    public void lockDatabean(String name) throws JaferException {
        if (this.isConcurrent()) {
            try {
                Lock lock = (Lock)this.locks.get(name);
                lock.getLock();
            }
            catch (Exception e) {
                throw new JaferException("Error obtaining lock for bean " + name + "; " + e.toString());
            }
        }
    }

    public void freeDatabean(String name) throws JaferException {
        if (this.isConcurrent()) {
            if (name == null || !this.locks.containsKey(name)) {
                return;
            }
            try {
                Lock lock = (Lock)this.locks.get(name);
                lock.freeLock(name);
            }
            catch (Exception e) {
                throw new JaferException("Error releasing lock for bean " + name + "; " + e.toString());
            }
        }
    }

    public synchronized Object getDatabean(String name) {
        if (name == null || !this.databeans.containsKey(name)) {
            return null;
        }
        return this.databeans.get(name);
    }

    public synchronized void setDatabean(String name, Object databean) throws JaferException {
        if (name == null || databean == null) {
            return;
        }
        this.removeDatabean(name);
        if (this.isConcurrent()) {
            this.locks.put(name, new Lock());
        }
        this.databeans.put(name, databean);
    }

    public synchronized void removeDatabean(String name) throws JaferException {
        if (name == null || !this.databeans.containsKey(name)) {
            return;
        }
        if (this.isConcurrent()) {
            this.lockDatabean(name);
            Lock lock = (Lock)this.locks.remove(name);
            lock.interrupt();
        }
        this.databeans.remove(name);
    }

    public void removeAllDatabeans() throws JaferException {
        if (this.isConcurrent()) {
            Enumeration keys = this.databeans.keys();
            while (keys.hasMoreElements()) {
                this.removeDatabean((String)keys.nextElement());
            }
        } else {
            this.databeans.clear();
        }
    }

    private void cleanUpDatabeans() {
        if (this.isConcurrent()) {
            Enumeration keys = this.locks.keys();
            Lock lock = null;
            while (keys.hasMoreElements()) {
                lock = (Lock)this.locks.get(keys.nextElement());
                if (lock == null) continue;
                lock.interrupt();
            }
        }
        this.locks.clear();
        this.databeans.clear();
        this.locks = null;
        this.databeans = null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

