/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zserver.operations;

import asn1.ASN1Integer;
import org.jafer.exception.JaferException;
import org.jafer.zserver.Session;
import org.jafer.zserver.operations.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import z3950.v3.DeleteResultSetRequest;
import z3950.v3.DeleteResultSetResponse;
import z3950.v3.DeleteSetStatus;
import z3950.v3.ListStatuses;
import z3950.v3.ListStatuses1;
import z3950.v3.PDU;
import z3950.v3.ResultSetId;

public class Delete
extends Operation {
    private static final Logger logger = LoggerFactory.getLogger(Delete.class);
    private final PDU pduRequest;
    private final PDU pduResponse;
    private boolean status = true;

    public Delete(Session session, PDU pduRequest) {
        super(session, "delete");
        this.pduRequest = pduRequest;
        this.pduResponse = new PDU();
    }

    public PDU runOp() throws Exception {
        this.pduResponse.c_deleteResultSetResponse = new DeleteResultSetResponse();
        this.pduResponse.c_deleteResultSetResponse.s_referenceId = this.pduRequest.c_deleteResultSetRequest.s_referenceId;
        DeleteResultSetRequest cfr_ignored_0 = this.pduRequest.c_deleteResultSetRequest;
        if (this.pduRequest.c_deleteResultSetRequest.s_deleteFunction == new ASN1Integer(1)) {
            try {
                this.getSession().removeAllDatabeans();
            }
            catch (JaferException ex) {
                logger.warn(this.getName() + ex.toString());
                this.status = false;
            }
        } else {
            this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses = new ListStatuses();
            this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses.value = new ListStatuses1[this.pduRequest.c_deleteResultSetRequest.s_resultSetList.length];
            for (int n = 0; n < this.pduRequest.c_deleteResultSetRequest.s_resultSetList.length; ++n) {
                this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses.value[n] = new ListStatuses1();
                this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses.value[n].s_id = new ResultSetId();
                this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses.value[n].s_id.value = this.pduRequest.c_deleteResultSetRequest.s_resultSetList[n].value;
                String resultSetName = this.pduRequest.c_deleteResultSetRequest.s_resultSetList[n].value.value.get();
                try {
                    if (this.getSession().containsDatabean(resultSetName)) {
                        this.getSession().removeDatabean(resultSetName);
                        this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses.value[n].s_status = new DeleteSetStatus();
                        DeleteSetStatus cfr_ignored_1 = this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses.value[n].s_status;
                        this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses.value[n].s_status.value = new ASN1Integer(0);
                        continue;
                    }
                    this.status = false;
                    DeleteSetStatus cfr_ignored_2 = this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses.value[n].s_status;
                    this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses.value[n].s_status.value = new ASN1Integer(1);
                    continue;
                }
                catch (JaferException ex) {
                    logger.warn(this.getName() + ex.toString());
                    this.status = false;
                    DeleteSetStatus cfr_ignored_3 = this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses.value[n].s_status;
                    this.pduResponse.c_deleteResultSetResponse.s_deleteListStatuses.value[n].s_status.value = new ASN1Integer(10);
                }
            }
        }
        this.pduResponse.c_deleteResultSetResponse.s_deleteOperationStatus = new DeleteSetStatus();
        if (this.status) {
            DeleteSetStatus cfr_ignored_4 = this.pduResponse.c_deleteResultSetResponse.s_deleteOperationStatus;
            this.pduResponse.c_deleteResultSetResponse.s_deleteOperationStatus.value = new ASN1Integer(9);
        } else {
            DeleteSetStatus cfr_ignored_5 = this.pduResponse.c_deleteResultSetResponse.s_deleteOperationStatus;
            this.pduResponse.c_deleteResultSetResponse.s_deleteOperationStatus.value = new ASN1Integer(0);
        }
        return this.pduResponse;
    }
}

