/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zserver.util;

import java.util.Iterator;
import java.util.Vector;

public class Lock {
    private Vector waiting = new Vector();
    private Thread locks = null;
    private int locksCount = 0;

    public synchronized void getLock() throws Exception {
        while (!this.tryGetLock()) {
            this.waiting.add(Thread.currentThread());
            System.out.println("waiting for lock");
            this.wait();
            System.out.println("got lock");
            this.waiting.remove(Thread.currentThread());
        }
    }

    private synchronized boolean tryGetLock() {
        if (this.locks == null) {
            this.locks = Thread.currentThread();
            this.locksCount = 1;
            return true;
        }
        if (this.locks == Thread.currentThread()) {
            ++this.locksCount;
            return true;
        }
        return false;
    }

    public synchronized void freeLock(String id) {
        if (this.locks == Thread.currentThread()) {
            --this.locksCount;
            if (this.locksCount == 0) {
                this.locks = null;
                this.notify();
            }
        }
    }

    public int getWaitingCount() {
        return this.waiting.size();
    }

    public synchronized void interrupt() {
        Iterator it = this.waiting.iterator();
        while (it.hasNext()) {
            ((Thread)it.next()).interrupt();
        }
    }
}

