/*
 * Decompiled with CFR 0.152.
 */
package z3950.DiagFormat;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.ASN1Null;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.AttributeList;

public final class DiagFormat_scan
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1Null c_nonZeroStepSize;
    public ASN1Null c_specifiedStepSize;
    public ASN1Null c_termList1;
    public AttributeList[] c_termList2;
    public ASN1Integer c_posInResponse;
    public ASN1Null c_resources;
    public ASN1Null c_endOfList;
    public static final int E_mustBeOne = 1;
    public static final int E_mustBePositive = 2;
    public static final int E_mustBeNonNegative = 3;
    public static final int E_other = 4;

    public DiagFormat_scan() {
    }

    public DiagFormat_scan(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_nonZeroStepSize = null;
        this.c_specifiedStepSize = null;
        this.c_termList1 = null;
        this.c_termList2 = null;
        this.c_posInResponse = null;
        this.c_resources = null;
        this.c_endOfList = null;
        if (berencoding.tag_get() == 0 && berencoding.tag_type_get() == 128) {
            this.c_nonZeroStepSize = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            this.c_specifiedStepSize = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 3 && berencoding.tag_type_get() == 128) {
            this.c_termList1 = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 4 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed;
            BEREncoding berencoding1 = berencoding;
            try {
                berconstructed = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis DiagFormat_scan: bad BER form\n");
            }
            int i = berconstructed.number_components();
            this.c_termList2 = new AttributeList[i];
            for (int j = 0; j < i; ++j) {
                this.c_termList2[j] = new AttributeList(berconstructed.elementAt(j), true);
            }
            return;
        }
        if (berencoding.tag_get() == 5 && berencoding.tag_type_get() == 128) {
            this.c_posInResponse = new ASN1Integer(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 6 && berencoding.tag_type_get() == 128) {
            this.c_resources = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 7 && berencoding.tag_type_get() == 128) {
            this.c_endOfList = new ASN1Null(berencoding, false);
            return;
        }
        throw new ASN1Exception("Verbis DiagFormat_scan: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding obj = null;
        if (this.c_nonZeroStepSize != null) {
            obj = this.c_nonZeroStepSize.ber_encode(128, 0);
        }
        if (this.c_specifiedStepSize != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_specifiedStepSize.ber_encode(128, 1);
        }
        if (this.c_termList1 != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_termList1.ber_encode(128, 3);
        }
        if (this.c_termList2 != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding = new BEREncoding[this.c_termList2.length];
            for (int i = 0; i < this.c_termList2.length; ++i) {
                aberencoding[i] = this.c_termList2[i].ber_encode();
            }
            obj = new BERConstructed(128, 4, aberencoding);
        }
        if (this.c_posInResponse != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_posInResponse.ber_encode(128, 5);
        }
        if (this.c_resources != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_resources.ber_encode(128, 6);
        }
        if (this.c_endOfList != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_endOfList.ber_encode(128, 7);
        }
        if (obj == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return obj;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis DiagFormat_scan: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_nonZeroStepSize != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: nonZeroStepSize> ");
            }
            flag = true;
            stringbuffer.append("nonZeroStepSize ");
            stringbuffer.append(this.c_nonZeroStepSize);
        }
        if (this.c_specifiedStepSize != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: specifiedStepSize> ");
            }
            flag = true;
            stringbuffer.append("specifiedStepSize ");
            stringbuffer.append(this.c_specifiedStepSize);
        }
        if (this.c_termList1 != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: termList1> ");
            }
            flag = true;
            stringbuffer.append("termList1 ");
            stringbuffer.append(this.c_termList1);
        }
        if (this.c_termList2 != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: termList2> ");
            }
            flag = true;
            stringbuffer.append("termList2 ");
            stringbuffer.append("{");
            for (int i = 0; i < this.c_termList2.length; ++i) {
                stringbuffer.append(this.c_termList2[i]);
            }
            stringbuffer.append("}");
        }
        if (this.c_posInResponse != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: posInResponse> ");
            }
            flag = true;
            stringbuffer.append("posInResponse ");
            stringbuffer.append(this.c_posInResponse);
        }
        if (this.c_resources != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: resources> ");
            }
            flag = true;
            stringbuffer.append("resources ");
            stringbuffer.append(this.c_resources);
        }
        if (this.c_endOfList != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: endOfList> ");
            }
            flag = true;
            stringbuffer.append("endOfList ");
            stringbuffer.append(this.c_endOfList);
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

