/*
 * Decompiled with CFR 0.152.
 */
package z3950.ESFormat_ExportInvocation;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.IntUnit;

public final class TargetPart
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public IntUnit s_estimatedQuantity;
    public IntUnit s_quantitySoFar;
    public IntUnit s_estimatedCost;
    public IntUnit s_costSoFar;

    public TargetPart() {
    }

    public TargetPart(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis TargetPart: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_estimatedQuantity = null;
        this.s_quantitySoFar = null;
        this.s_estimatedCost = null;
        this.s_costSoFar = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_estimatedQuantity = new IntUnit(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_quantitySoFar = new IntUnit(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_estimatedCost = new IntUnit(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            this.s_costSoFar = new IntUnit(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis TargetPart: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_estimatedQuantity != null) {
            ++k;
        }
        if (this.s_quantitySoFar != null) {
            ++k;
        }
        if (this.s_estimatedCost != null) {
            ++k;
        }
        if (this.s_costSoFar != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_estimatedQuantity != null) {
            aberencoding[l++] = this.s_estimatedQuantity.ber_encode(128, 1);
        }
        if (this.s_quantitySoFar != null) {
            aberencoding[l++] = this.s_quantitySoFar.ber_encode(128, 2);
        }
        if (this.s_estimatedCost != null) {
            aberencoding[l++] = this.s_estimatedCost.ber_encode(128, 3);
        }
        if (this.s_costSoFar != null) {
            aberencoding[l++] = this.s_costSoFar.ber_encode(128, 4);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_estimatedQuantity != null) {
            stringbuffer.append("estimatedQuantity ");
            stringbuffer.append(this.s_estimatedQuantity);
            ++i;
        }
        if (this.s_quantitySoFar != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("quantitySoFar ");
            stringbuffer.append(this.s_quantitySoFar);
            ++i;
        }
        if (this.s_estimatedCost != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("estimatedCost ");
            stringbuffer.append(this.s_estimatedCost);
            ++i;
        }
        if (this.s_costSoFar != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("costSoFar ");
            stringbuffer.append(this.s_costSoFar);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

