/*
 * Decompiled with CFR 0.152.
 */
package z3950.ESFormat_ItemOrder;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.InternationalString;

public final class CreditCardInfo
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public InternationalString s_nameOnCard;
    public InternationalString s_expirationDate;
    public InternationalString s_cardNumber;

    public CreditCardInfo() {
    }

    public CreditCardInfo(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis CreditCardInfo: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis CreditCardInfo: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis CreditCardInfo: bad tag in s_nameOnCard\n");
        }
        this.s_nameOnCard = new InternationalString(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis CreditCardInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis CreditCardInfo: bad tag in s_expirationDate\n");
        }
        this.s_expirationDate = new InternationalString(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis CreditCardInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 3 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis CreditCardInfo: bad tag in s_cardNumber\n");
        }
        this.s_cardNumber = new InternationalString(berencoding1, false);
        if (++j < i) {
            throw new ASN1Exception("Verbis CreditCardInfo: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int byte0 = 3;
        BEREncoding[] aberencoding = new BEREncoding[byte0];
        int k = 0;
        aberencoding[k++] = this.s_nameOnCard.ber_encode(128, 1);
        aberencoding[k++] = this.s_expirationDate.ber_encode(128, 2);
        aberencoding[k++] = this.s_cardNumber.ber_encode(128, 3);
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        stringbuffer.append("nameOnCard ");
        stringbuffer.append(this.s_nameOnCard);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("expirationDate ");
        stringbuffer.append(this.s_expirationDate);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("cardNumber ");
        stringbuffer.append(this.s_cardNumber);
        ++i;
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

