/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.ElementInfo;
import z3950.RS_Explain.PrimitiveDataType;

public final class ElementDataType
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public PrimitiveDataType c_primitive;
    public ElementInfo[] c_structured;

    public ElementDataType() {
    }

    public ElementDataType(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_primitive = null;
        this.c_structured = null;
        if (berencoding.tag_get() == 0 && berencoding.tag_type_get() == 128) {
            this.c_primitive = new PrimitiveDataType(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed;
            BEREncoding berencoding1 = berencoding;
            try {
                berconstructed = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis ElementDataType: bad BER form\n");
            }
            int i = berconstructed.number_components();
            this.c_structured = new ElementInfo[i];
            for (int j = 0; j < i; ++j) {
                this.c_structured[j] = new ElementInfo(berconstructed.elementAt(j), true);
            }
            return;
        }
        throw new ASN1Exception("Verbis ElementDataType: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding obj = null;
        if (this.c_primitive != null) {
            obj = this.c_primitive.ber_encode(128, 0);
        }
        if (this.c_structured != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding = new BEREncoding[this.c_structured.length];
            for (int i = 0; i < this.c_structured.length; ++i) {
                aberencoding[i] = this.c_structured[i].ber_encode();
            }
            obj = new BERConstructed(128, 1, aberencoding);
        }
        if (obj == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return obj;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis ElementDataType: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_primitive != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: primitive> ");
            }
            flag = true;
            stringbuffer.append("primitive ");
            stringbuffer.append(this.c_primitive);
        }
        if (this.c_structured != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: structured> ");
            }
            flag = true;
            stringbuffer.append("structured ");
            stringbuffer.append("{");
            for (int i = 0; i < this.c_structured.length; ++i) {
                stringbuffer.append(this.c_structured[i]);
            }
            stringbuffer.append("}");
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

