/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1Boolean;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.CommonInfo;
import z3950.RS_Explain.HumanString;
import z3950.v3.InternationalString;

public final class ExtendedServicesInfo
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public CommonInfo s_commonInfo;
    public ASN1ObjectIdentifier s_type;
    public InternationalString s_name;
    public ASN1Boolean s_privateType;
    public ASN1Boolean s_restrictionsApply;
    public ASN1Boolean s_feeApply;
    public ASN1Boolean s_available;
    public ASN1Boolean s_retentionSupported;
    public ASN1Integer s_waitAction;
    public HumanString s_description;
    public ASN1External s_specificExplain;
    public InternationalString s_esASN;
    public static final int E_waitSupported = 1;
    public static final int E_waitAlways = 2;
    public static final int E_waitNotSupported = 3;
    public static final int E_depends = 4;
    public static final int E_notSaying = 5;

    public ExtendedServicesInfo() {
    }

    public ExtendedServicesInfo(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ExtendedServicesInfo: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis ExtendedServicesInfo: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 0 && berencoding1.tag_type_get() == 128) {
            this.s_commonInfo = new CommonInfo(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ExtendedServicesInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ExtendedServicesInfo: bad tag in s_type\n");
        }
        this.s_type = new ASN1ObjectIdentifier(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ExtendedServicesInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_name = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ExtendedServicesInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 3 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ExtendedServicesInfo: bad tag in s_privateType\n");
        }
        this.s_privateType = new ASN1Boolean(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ExtendedServicesInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 5 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ExtendedServicesInfo: bad tag in s_restrictionsApply\n");
        }
        this.s_restrictionsApply = new ASN1Boolean(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ExtendedServicesInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 6 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ExtendedServicesInfo: bad tag in s_feeApply\n");
        }
        this.s_feeApply = new ASN1Boolean(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ExtendedServicesInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 7 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ExtendedServicesInfo: bad tag in s_available\n");
        }
        this.s_available = new ASN1Boolean(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ExtendedServicesInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 8 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ExtendedServicesInfo: bad tag in s_retentionSupported\n");
        }
        this.s_retentionSupported = new ASN1Boolean(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ExtendedServicesInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 9 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ExtendedServicesInfo: bad tag in s_waitAction\n");
        }
        this.s_waitAction = new ASN1Integer(berencoding1, false);
        this.s_description = null;
        this.s_specificExplain = null;
        this.s_esASN = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 10 && berencoding1.tag_type_get() == 128) {
            this.s_description = new HumanString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 11 && berencoding1.tag_type_get() == 128) {
            this.s_specificExplain = new ASN1External(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 12 && berencoding1.tag_type_get() == 128) {
            this.s_esASN = new InternationalString(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ExtendedServicesInfo: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 7;
        if (this.s_commonInfo != null) {
            ++k;
        }
        if (this.s_name != null) {
            ++k;
        }
        if (this.s_description != null) {
            ++k;
        }
        if (this.s_specificExplain != null) {
            ++k;
        }
        if (this.s_esASN != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_commonInfo != null) {
            aberencoding[l++] = this.s_commonInfo.ber_encode(128, 0);
        }
        aberencoding[l++] = this.s_type.ber_encode(128, 1);
        if (this.s_name != null) {
            aberencoding[l++] = this.s_name.ber_encode(128, 2);
        }
        aberencoding[l++] = this.s_privateType.ber_encode(128, 3);
        aberencoding[l++] = this.s_restrictionsApply.ber_encode(128, 5);
        aberencoding[l++] = this.s_feeApply.ber_encode(128, 6);
        aberencoding[l++] = this.s_available.ber_encode(128, 7);
        aberencoding[l++] = this.s_retentionSupported.ber_encode(128, 8);
        aberencoding[l++] = this.s_waitAction.ber_encode(128, 9);
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 10);
        }
        if (this.s_specificExplain != null) {
            aberencoding[l++] = this.s_specificExplain.ber_encode(128, 11);
        }
        if (this.s_esASN != null) {
            aberencoding[l++] = this.s_esASN.ber_encode(128, 12);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_commonInfo != null) {
            stringbuffer.append("commonInfo ");
            stringbuffer.append(this.s_commonInfo);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("type ");
        stringbuffer.append(this.s_type);
        ++i;
        if (this.s_name != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("name ");
            stringbuffer.append(this.s_name);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("privateType ");
        stringbuffer.append(this.s_privateType);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("restrictionsApply ");
        stringbuffer.append(this.s_restrictionsApply);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("feeApply ");
        stringbuffer.append(this.s_feeApply);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("available ");
        stringbuffer.append(this.s_available);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("retentionSupported ");
        stringbuffer.append(this.s_retentionSupported);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("waitAction ");
        stringbuffer.append(this.s_waitAction);
        ++i;
        if (this.s_description != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++i;
        }
        if (this.s_specificExplain != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("specificExplain ");
            stringbuffer.append(this.s_specificExplain);
            ++i;
        }
        if (this.s_esASN != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("esASN ");
            stringbuffer.append(this.s_esASN);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

