/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.HumanString;
import z3950.RS_Explain.SearchKey;

public final class Iso8777Capabilities
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public SearchKey[] s_searchKeys;
    public HumanString s_restrictions;

    public Iso8777Capabilities() {
    }

    public Iso8777Capabilities(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis Iso8777Capabilities: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis Iso8777Capabilities: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 0 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis Iso8777Capabilities: bad tag in s_searchKeys\n");
        }
        try {
            BERConstructed berconstructed1 = (BERConstructed)berencoding1;
            int k = berconstructed1.number_components();
            this.s_searchKeys = new SearchKey[k];
            for (int l = 0; l < k; ++l) {
                this.s_searchKeys[l] = new SearchKey(berconstructed1.elementAt(l), true);
            }
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Bad BER");
        }
        this.s_restrictions = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_restrictions = new HumanString(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis Iso8777Capabilities: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_restrictions != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        BEREncoding[] aberencoding1 = new BEREncoding[this.s_searchKeys.length];
        for (int i1 = 0; i1 < this.s_searchKeys.length; ++i1) {
            aberencoding1[i1] = this.s_searchKeys[i1].ber_encode();
        }
        aberencoding[l++] = new BERConstructed(128, 0, aberencoding1);
        if (this.s_restrictions != null) {
            aberencoding[l++] = this.s_restrictions.ber_encode(128, 1);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        stringbuffer.append("searchKeys ");
        stringbuffer.append("{");
        for (int i = 0; i < this.s_searchKeys.length; ++i) {
            if (i != 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append(this.s_searchKeys[i]);
        }
        stringbuffer.append("}");
        ++j;
        if (this.s_restrictions != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("restrictions ");
            stringbuffer.append(this.s_restrictions);
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

