/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BEREncoding;
import z3950.RS_Explain.HumanString;
import z3950.RS_Explain.Iso8777Capabilities;
import z3950.RS_Explain.PrivateCapabilities;
import z3950.RS_Explain.RpnCapabilities;

public final class QueryTypeDetails
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public PrivateCapabilities c_private;
    public RpnCapabilities c_rpn;
    public Iso8777Capabilities c_iso8777;
    public HumanString c_z39_58;
    public RpnCapabilities c_erpn;
    public HumanString c_rankedList;

    public QueryTypeDetails() {
    }

    public QueryTypeDetails(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_private = null;
        this.c_rpn = null;
        this.c_iso8777 = null;
        this.c_z39_58 = null;
        this.c_erpn = null;
        this.c_rankedList = null;
        if (berencoding.tag_get() == 0 && berencoding.tag_type_get() == 128) {
            this.c_private = new PrivateCapabilities(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            this.c_rpn = new RpnCapabilities(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 2 && berencoding.tag_type_get() == 128) {
            this.c_iso8777 = new Iso8777Capabilities(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 100 && berencoding.tag_type_get() == 128) {
            this.c_z39_58 = new HumanString(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 101 && berencoding.tag_type_get() == 128) {
            this.c_erpn = new RpnCapabilities(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 102 && berencoding.tag_type_get() == 128) {
            this.c_rankedList = new HumanString(berencoding, false);
            return;
        }
        throw new ASN1Exception("Verbis QueryTypeDetails: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding berencoding = null;
        if (this.c_private != null) {
            berencoding = this.c_private.ber_encode(128, 0);
        }
        if (this.c_rpn != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_rpn.ber_encode(128, 1);
        }
        if (this.c_iso8777 != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_iso8777.ber_encode(128, 2);
        }
        if (this.c_z39_58 != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_z39_58.ber_encode(128, 100);
        }
        if (this.c_erpn != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_erpn.ber_encode(128, 101);
        }
        if (this.c_rankedList != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_rankedList.ber_encode(128, 102);
        }
        if (berencoding == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return berencoding;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis QueryTypeDetails: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_private != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: private> ");
            }
            flag = true;
            stringbuffer.append("private ");
            stringbuffer.append(this.c_private);
        }
        if (this.c_rpn != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: rpn> ");
            }
            flag = true;
            stringbuffer.append("rpn ");
            stringbuffer.append(this.c_rpn);
        }
        if (this.c_iso8777 != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: iso8777> ");
            }
            flag = true;
            stringbuffer.append("iso8777 ");
            stringbuffer.append(this.c_iso8777);
        }
        if (this.c_z39_58 != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: z39-58> ");
            }
            flag = true;
            stringbuffer.append("z39-58 ");
            stringbuffer.append(this.c_z39_58);
        }
        if (this.c_erpn != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: erpn> ");
            }
            flag = true;
            stringbuffer.append("erpn ");
            stringbuffer.append(this.c_erpn);
        }
        if (this.c_rankedList != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: rankedList> ");
            }
            flag = true;
            stringbuffer.append("rankedList ");
            stringbuffer.append(this.c_rankedList);
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

