/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.CommonInfo;
import z3950.RS_Explain.ElementInfo;
import z3950.RS_Explain.HumanString;
import z3950.v3.InternationalString;

public final class RecordSyntaxInfo
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public CommonInfo s_commonInfo;
    public ASN1ObjectIdentifier s_recordSyntax;
    public InternationalString s_name;
    public ASN1ObjectIdentifier[] s_transferSyntaxes;
    public HumanString s_description;
    public InternationalString s_asn1Module;
    public ElementInfo[] s_abstractStructure;

    public RecordSyntaxInfo() {
    }

    public RecordSyntaxInfo(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis RecordSyntaxInfo: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis RecordSyntaxInfo: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 0 && berencoding1.tag_type_get() == 128) {
            this.s_commonInfo = new CommonInfo(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis RecordSyntaxInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis RecordSyntaxInfo: bad tag in s_recordSyntax\n");
        }
        this.s_recordSyntax = new ASN1ObjectIdentifier(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis RecordSyntaxInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis RecordSyntaxInfo: bad tag in s_name\n");
        }
        this.s_name = new InternationalString(berencoding1, false);
        this.s_transferSyntaxes = null;
        this.s_description = null;
        this.s_asn1Module = null;
        this.s_abstractStructure = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_transferSyntaxes = new ASN1ObjectIdentifier[k];
                for (int i1 = 0; i1 < k; ++i1) {
                    this.s_transferSyntaxes[i1] = new ASN1ObjectIdentifier(berconstructed1.elementAt(i1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            this.s_description = new HumanString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 5 && berencoding1.tag_type_get() == 128) {
            this.s_asn1Module = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 6 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed2 = (BERConstructed)berencoding1;
                int l = berconstructed2.number_components();
                this.s_abstractStructure = new ElementInfo[l];
                for (int j1 = 0; j1 < l; ++j1) {
                    this.s_abstractStructure[j1] = new ElementInfo(berconstructed2.elementAt(j1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis RecordSyntaxInfo: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 2;
        if (this.s_commonInfo != null) {
            ++k;
        }
        if (this.s_transferSyntaxes != null) {
            ++k;
        }
        if (this.s_description != null) {
            ++k;
        }
        if (this.s_asn1Module != null) {
            ++k;
        }
        if (this.s_abstractStructure != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_commonInfo != null) {
            aberencoding[l++] = this.s_commonInfo.ber_encode(128, 0);
        }
        aberencoding[l++] = this.s_recordSyntax.ber_encode(128, 1);
        aberencoding[l++] = this.s_name.ber_encode(128, 2);
        if (this.s_transferSyntaxes != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_transferSyntaxes.length];
            for (int i1 = 0; i1 < this.s_transferSyntaxes.length; ++i1) {
                aberencoding1[i1] = this.s_transferSyntaxes[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 3, aberencoding1);
        }
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 4);
        }
        if (this.s_asn1Module != null) {
            aberencoding[l++] = this.s_asn1Module.ber_encode(128, 5);
        }
        if (this.s_abstractStructure != null) {
            BEREncoding[] aberencoding2 = new BEREncoding[this.s_abstractStructure.length];
            for (int j1 = 0; j1 < this.s_abstractStructure.length; ++j1) {
                aberencoding2[j1] = this.s_abstractStructure[j1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 6, aberencoding2);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int k = 0;
        if (this.s_commonInfo != null) {
            stringbuffer.append("commonInfo ");
            stringbuffer.append(this.s_commonInfo);
            ++k;
        }
        if (k > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("recordSyntax ");
        stringbuffer.append(this.s_recordSyntax);
        if (++k > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("name ");
        stringbuffer.append(this.s_name);
        ++k;
        if (this.s_transferSyntaxes != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("transferSyntaxes ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_transferSyntaxes.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_transferSyntaxes[i]);
            }
            stringbuffer.append("}");
            ++k;
        }
        if (this.s_description != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++k;
        }
        if (this.s_asn1Module != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("asn1Module ");
            stringbuffer.append(this.s_asn1Module);
            ++k;
        }
        if (this.s_abstractStructure != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("abstractStructure ");
            stringbuffer.append("{");
            for (int j = 0; j < this.s_abstractStructure.length; ++j) {
                if (j != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_abstractStructure[j]);
            }
            stringbuffer.append("}");
            ++k;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

