/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.CommonInfo;
import z3950.RS_Explain.HumanString;
import z3950.RS_Explain.PerElementDetails;
import z3950.v3.DatabaseName;

public final class RetrievalRecordDetails
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public CommonInfo s_commonInfo;
    public DatabaseName s_databaseName;
    public ASN1ObjectIdentifier s_schema;
    public ASN1ObjectIdentifier s_recordSyntax;
    public HumanString s_description;
    public PerElementDetails[] s_detailsPerElement;

    public RetrievalRecordDetails() {
    }

    public RetrievalRecordDetails(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis RetrievalRecordDetails: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis RetrievalRecordDetails: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 0 && berencoding1.tag_type_get() == 128) {
            this.s_commonInfo = new CommonInfo(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis RetrievalRecordDetails: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis RetrievalRecordDetails: bad tag in s_databaseName\n");
        }
        this.s_databaseName = new DatabaseName(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis RetrievalRecordDetails: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis RetrievalRecordDetails: bad tag in s_schema\n");
        }
        this.s_schema = new ASN1ObjectIdentifier(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis RetrievalRecordDetails: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 3 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis RetrievalRecordDetails: bad tag in s_recordSyntax\n");
        }
        this.s_recordSyntax = new ASN1ObjectIdentifier(berencoding1, false);
        this.s_description = null;
        this.s_detailsPerElement = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            this.s_description = new HumanString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 5 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_detailsPerElement = new PerElementDetails[k];
                for (int l = 0; l < k; ++l) {
                    this.s_detailsPerElement[l] = new PerElementDetails(berconstructed1.elementAt(l), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis RetrievalRecordDetails: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 3;
        if (this.s_commonInfo != null) {
            ++k;
        }
        if (this.s_description != null) {
            ++k;
        }
        if (this.s_detailsPerElement != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_commonInfo != null) {
            aberencoding[l++] = this.s_commonInfo.ber_encode(128, 0);
        }
        aberencoding[l++] = this.s_databaseName.ber_encode(128, 1);
        aberencoding[l++] = this.s_schema.ber_encode(128, 2);
        aberencoding[l++] = this.s_recordSyntax.ber_encode(128, 3);
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 4);
        }
        if (this.s_detailsPerElement != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_detailsPerElement.length];
            for (int i1 = 0; i1 < this.s_detailsPerElement.length; ++i1) {
                aberencoding1[i1] = this.s_detailsPerElement[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 5, aberencoding1);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_commonInfo != null) {
            stringbuffer.append("commonInfo ");
            stringbuffer.append(this.s_commonInfo);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("databaseName ");
        stringbuffer.append(this.s_databaseName);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("schema ");
        stringbuffer.append(this.s_schema);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("recordSyntax ");
        stringbuffer.append(this.s_recordSyntax);
        ++j;
        if (this.s_description != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++j;
        }
        if (this.s_detailsPerElement != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("detailsPerElement ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_detailsPerElement.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_detailsPerElement[i]);
            }
            stringbuffer.append("}");
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

